<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketingInfoType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgTicketingInfoType extends AbstractStructBase
{
    /**
     * The TicketAdvisory
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFreeTextType[]
     */
    public $TicketAdvisory;
    /**
     * The TicketTimeLimit
     * @var string
     */
    public $TicketTimeLimit;
    /**
     * The OldTicketTimeLimit
     * @var string
     */
    public $OldTicketTimeLimit;
    /**
     * The TicketType
     * @var string
     */
    public $TicketType;
    /**
     * The TicketingStatus
     * @var string
     */
    public $TicketingStatus;
    /**
     * The FlightSegmentRefNumber
     * @var string[]
     */
    public $FlightSegmentRefNumber;
    /**
     * The TravelerRefNumber
     * @var string
     */
    public $TravelerRefNumber;
    /**
     * The ReverseTktgSegmentsInd
     * @var bool
     */
    public $ReverseTktgSegmentsInd;
    /**
     * The PseudoCityCode
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The RequestedTicketingDate
     * @var string
     */
    public $RequestedTicketingDate;
    /**
     * The TimeLimitMinutes
     * @var int
     */
    public $TimeLimitMinutes;
    /**
     * Constructor method for TicketingInfoType
     * @uses DgTicketingInfoType::setTicketAdvisory()
     * @uses DgTicketingInfoType::setTicketTimeLimit()
     * @uses DgTicketingInfoType::setOldTicketTimeLimit()
     * @uses DgTicketingInfoType::setTicketType()
     * @uses DgTicketingInfoType::setTicketingStatus()
     * @uses DgTicketingInfoType::setFlightSegmentRefNumber()
     * @uses DgTicketingInfoType::setTravelerRefNumber()
     * @uses DgTicketingInfoType::setReverseTktgSegmentsInd()
     * @uses DgTicketingInfoType::setPseudoCityCode()
     * @uses DgTicketingInfoType::setRequestedTicketingDate()
     * @uses DgTicketingInfoType::setTimeLimitMinutes()
     * @param \dgsoft\StructType\DgFreeTextType[] $ticketAdvisory
     * @param string $ticketTimeLimit
     * @param string $oldTicketTimeLimit
     * @param string $ticketType
     * @param string $ticketingStatus
     * @param string[] $flightSegmentRefNumber
     * @param string $travelerRefNumber
     * @param bool $reverseTktgSegmentsInd
     * @param string $pseudoCityCode
     * @param string $requestedTicketingDate
     * @param int $timeLimitMinutes
     */
    public function __construct(array $ticketAdvisory = array(), $ticketTimeLimit = null, $oldTicketTimeLimit = null, $ticketType = null, $ticketingStatus = null, array $flightSegmentRefNumber = array(), $travelerRefNumber = null, $reverseTktgSegmentsInd = null, $pseudoCityCode = null, $requestedTicketingDate = null, $timeLimitMinutes = null)
    {
        $this
            ->setTicketAdvisory($ticketAdvisory)
            ->setTicketTimeLimit($ticketTimeLimit)
            ->setOldTicketTimeLimit($oldTicketTimeLimit)
            ->setTicketType($ticketType)
            ->setTicketingStatus($ticketingStatus)
            ->setFlightSegmentRefNumber($flightSegmentRefNumber)
            ->setTravelerRefNumber($travelerRefNumber)
            ->setReverseTktgSegmentsInd($reverseTktgSegmentsInd)
            ->setPseudoCityCode($pseudoCityCode)
            ->setRequestedTicketingDate($requestedTicketingDate)
            ->setTimeLimitMinutes($timeLimitMinutes);
    }
    /**
     * Get TicketAdvisory value
     * @return \dgsoft\StructType\DgFreeTextType[]|null
     */
    public function getTicketAdvisory()
    {
        return $this->TicketAdvisory;
    }
    /**
     * Set TicketAdvisory value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFreeTextType[] $ticketAdvisory
     * @return \dgsoft\StructType\DgTicketingInfoType
     */
    public function setTicketAdvisory(array $ticketAdvisory = array())
    {
        foreach ($ticketAdvisory as $ticketingInfoTypeTicketAdvisoryItem) {
            // validation for constraint: itemType
            if (!$ticketingInfoTypeTicketAdvisoryItem instanceof \dgsoft\StructType\DgFreeTextType) {
                throw new \InvalidArgumentException(sprintf('The TicketAdvisory property can only contain items of \dgsoft\StructType\DgFreeTextType, "%s" given', is_object($ticketingInfoTypeTicketAdvisoryItem) ? get_class($ticketingInfoTypeTicketAdvisoryItem) : gettype($ticketingInfoTypeTicketAdvisoryItem)), __LINE__);
            }
        }
        $this->TicketAdvisory = $ticketAdvisory;
        return $this;
    }
    /**
     * Add item to TicketAdvisory value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFreeTextType $item
     * @return \dgsoft\StructType\DgTicketingInfoType
     */
    public function addToTicketAdvisory(\dgsoft\StructType\DgFreeTextType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFreeTextType) {
            throw new \InvalidArgumentException(sprintf('The TicketAdvisory property can only contain items of \dgsoft\StructType\DgFreeTextType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TicketAdvisory[] = $item;
        return $this;
    }
    /**
     * Get TicketTimeLimit value
     * @return string|null
     */
    public function getTicketTimeLimit()
    {
        return $this->TicketTimeLimit;
    }
    /**
     * Set TicketTimeLimit value
     * @param string $ticketTimeLimit
     * @return \dgsoft\StructType\DgTicketingInfoType
     */
    public function setTicketTimeLimit($ticketTimeLimit = null)
    {
        // validation for constraint: string
        if (!is_null($ticketTimeLimit) && !is_string($ticketTimeLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketTimeLimit)), __LINE__);
        }
        $this->TicketTimeLimit = $ticketTimeLimit;
        return $this;
    }
    /**
     * Get OldTicketTimeLimit value
     * @return string|null
     */
    public function getOldTicketTimeLimit()
    {
        return $this->OldTicketTimeLimit;
    }
    /**
     * Set OldTicketTimeLimit value
     * @param string $oldTicketTimeLimit
     * @return \dgsoft\StructType\DgTicketingInfoType
     */
    public function setOldTicketTimeLimit($oldTicketTimeLimit = null)
    {
        // validation for constraint: string
        if (!is_null($oldTicketTimeLimit) && !is_string($oldTicketTimeLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oldTicketTimeLimit)), __LINE__);
        }
        $this->OldTicketTimeLimit = $oldTicketTimeLimit;
        return $this;
    }
    /**
     * Get TicketType value
     * @return string|null
     */
    public function getTicketType()
    {
        return $this->TicketType;
    }
    /**
     * Set TicketType value
     * @uses \dgsoft\EnumType\DgTicketType::valueIsValid()
     * @uses \dgsoft\EnumType\DgTicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketType
     * @return \dgsoft\StructType\DgTicketingInfoType
     */
    public function setTicketType($ticketType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgTicketType::valueIsValid($ticketType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ticketType, implode(', ', \dgsoft\EnumType\DgTicketType::getValidValues())), __LINE__);
        }
        $this->TicketType = $ticketType;
        return $this;
    }
    /**
     * Get TicketingStatus value
     * @return string|null
     */
    public function getTicketingStatus()
    {
        return $this->TicketingStatus;
    }
    /**
     * Set TicketingStatus value
     * @param string $ticketingStatus
     * @return \dgsoft\StructType\DgTicketingInfoType
     */
    public function setTicketingStatus($ticketingStatus = null)
    {
        // validation for constraint: string
        if (!is_null($ticketingStatus) && !is_string($ticketingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketingStatus)), __LINE__);
        }
        $this->TicketingStatus = $ticketingStatus;
        return $this;
    }
    /**
     * Get FlightSegmentRefNumber value
     * @return string[]|null
     */
    public function getFlightSegmentRefNumber()
    {
        return $this->FlightSegmentRefNumber;
    }
    /**
     * Set FlightSegmentRefNumber value
     * @throws \InvalidArgumentException
     * @param string[] $flightSegmentRefNumber
     * @return \dgsoft\StructType\DgTicketingInfoType
     */
    public function setFlightSegmentRefNumber(array $flightSegmentRefNumber = array())
    {
        foreach ($flightSegmentRefNumber as $ticketingInfoTypeFlightSegmentRefNumberItem) {
            // validation for constraint: itemType
            if (!is_string($ticketingInfoTypeFlightSegmentRefNumberItem)) {
                throw new \InvalidArgumentException(sprintf('The FlightSegmentRefNumber property can only contain items of string, "%s" given', is_object($ticketingInfoTypeFlightSegmentRefNumberItem) ? get_class($ticketingInfoTypeFlightSegmentRefNumberItem) : gettype($ticketingInfoTypeFlightSegmentRefNumberItem)), __LINE__);
            }
        }
        $this->FlightSegmentRefNumber = $flightSegmentRefNumber;
        return $this;
    }
    /**
     * Add item to FlightSegmentRefNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgTicketingInfoType
     */
    public function addToFlightSegmentRefNumber($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The FlightSegmentRefNumber property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FlightSegmentRefNumber[] = $item;
        return $this;
    }
    /**
     * Get TravelerRefNumber value
     * @return string|null
     */
    public function getTravelerRefNumber()
    {
        return $this->TravelerRefNumber;
    }
    /**
     * Set TravelerRefNumber value
     * @param string $travelerRefNumber
     * @return \dgsoft\StructType\DgTicketingInfoType
     */
    public function setTravelerRefNumber($travelerRefNumber = null)
    {
        // validation for constraint: string
        if (!is_null($travelerRefNumber) && !is_string($travelerRefNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelerRefNumber)), __LINE__);
        }
        $this->TravelerRefNumber = $travelerRefNumber;
        return $this;
    }
    /**
     * Get ReverseTktgSegmentsInd value
     * @return bool|null
     */
    public function getReverseTktgSegmentsInd()
    {
        return $this->ReverseTktgSegmentsInd;
    }
    /**
     * Set ReverseTktgSegmentsInd value
     * @param bool $reverseTktgSegmentsInd
     * @return \dgsoft\StructType\DgTicketingInfoType
     */
    public function setReverseTktgSegmentsInd($reverseTktgSegmentsInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($reverseTktgSegmentsInd) && !is_bool($reverseTktgSegmentsInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($reverseTktgSegmentsInd)), __LINE__);
        }
        $this->ReverseTktgSegmentsInd = $reverseTktgSegmentsInd;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \dgsoft\StructType\DgTicketingInfoType
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($pseudoCityCode) && !is_string($pseudoCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pseudoCityCode)), __LINE__);
        }
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get RequestedTicketingDate value
     * @return string|null
     */
    public function getRequestedTicketingDate()
    {
        return $this->RequestedTicketingDate;
    }
    /**
     * Set RequestedTicketingDate value
     * @param string $requestedTicketingDate
     * @return \dgsoft\StructType\DgTicketingInfoType
     */
    public function setRequestedTicketingDate($requestedTicketingDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestedTicketingDate) && !is_string($requestedTicketingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestedTicketingDate)), __LINE__);
        }
        $this->RequestedTicketingDate = $requestedTicketingDate;
        return $this;
    }
    /**
     * Get TimeLimitMinutes value
     * @return int|null
     */
    public function getTimeLimitMinutes()
    {
        return $this->TimeLimitMinutes;
    }
    /**
     * Set TimeLimitMinutes value
     * @param int $timeLimitMinutes
     * @return \dgsoft\StructType\DgTicketingInfoType
     */
    public function setTimeLimitMinutes($timeLimitMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($timeLimitMinutes) && !is_numeric($timeLimitMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($timeLimitMinutes)), __LINE__);
        }
        $this->TimeLimitMinutes = $timeLimitMinutes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgTicketingInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
