<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing StructType
 * @package Dg
 * @subpackage Structs
 */
class DgTicketing extends DgTicketingInfoType
{
    /**
     * The TicketingVendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTicketingVendor
     */
    public $TicketingVendor;
    /**
     * The PricingSystem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPricingSystem
     */
    public $PricingSystem;
    /**
     * Constructor method for Ticketing
     * @uses DgTicketing::setTicketingVendor()
     * @uses DgTicketing::setPricingSystem()
     * @param \dgsoft\StructType\DgTicketingVendor $ticketingVendor
     * @param \dgsoft\StructType\DgPricingSystem $pricingSystem
     */
    public function __construct(\dgsoft\StructType\DgTicketingVendor $ticketingVendor = null, \dgsoft\StructType\DgPricingSystem $pricingSystem = null)
    {
        $this
            ->setTicketingVendor($ticketingVendor)
            ->setPricingSystem($pricingSystem);
    }
    /**
     * Get TicketingVendor value
     * @return \dgsoft\StructType\DgTicketingVendor|null
     */
    public function getTicketingVendor()
    {
        return $this->TicketingVendor;
    }
    /**
     * Set TicketingVendor value
     * @param \dgsoft\StructType\DgTicketingVendor $ticketingVendor
     * @return \dgsoft\StructType\DgTicketing
     */
    public function setTicketingVendor(\dgsoft\StructType\DgTicketingVendor $ticketingVendor = null)
    {
        $this->TicketingVendor = $ticketingVendor;
        return $this;
    }
    /**
     * Get PricingSystem value
     * @return \dgsoft\StructType\DgPricingSystem|null
     */
    public function getPricingSystem()
    {
        return $this->PricingSystem;
    }
    /**
     * Set PricingSystem value
     * @param \dgsoft\StructType\DgPricingSystem $pricingSystem
     * @return \dgsoft\StructType\DgTicketing
     */
    public function setPricingSystem(\dgsoft\StructType\DgPricingSystem $pricingSystem = null)
    {
        $this->PricingSystem = $pricingSystem;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgTicketing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
