<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemCodes StructType
 * @package Dg
 * @subpackage Structs
 */
class DgSystemCodes extends AbstractStructBase
{
    /**
     * The SystemCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSystemCode[]
     */
    public $SystemCode;
    /**
     * The SystemCodesInclusive
     * @var bool
     */
    public $SystemCodesInclusive;
    /**
     * Constructor method for SystemCodes
     * @uses DgSystemCodes::setSystemCode()
     * @uses DgSystemCodes::setSystemCodesInclusive()
     * @param \dgsoft\StructType\DgSystemCode[] $systemCode
     * @param bool $systemCodesInclusive
     */
    public function __construct(array $systemCode = array(), $systemCodesInclusive = null)
    {
        $this
            ->setSystemCode($systemCode)
            ->setSystemCodesInclusive($systemCodesInclusive);
    }
    /**
     * Get SystemCode value
     * @return \dgsoft\StructType\DgSystemCode[]|null
     */
    public function getSystemCode()
    {
        return $this->SystemCode;
    }
    /**
     * Set SystemCode value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSystemCode[] $systemCode
     * @return \dgsoft\StructType\DgSystemCodes
     */
    public function setSystemCode(array $systemCode = array())
    {
        foreach ($systemCode as $systemCodesSystemCodeItem) {
            // validation for constraint: itemType
            if (!$systemCodesSystemCodeItem instanceof \dgsoft\StructType\DgSystemCode) {
                throw new \InvalidArgumentException(sprintf('The SystemCode property can only contain items of \dgsoft\StructType\DgSystemCode, "%s" given', is_object($systemCodesSystemCodeItem) ? get_class($systemCodesSystemCodeItem) : gettype($systemCodesSystemCodeItem)), __LINE__);
            }
        }
        $this->SystemCode = $systemCode;
        return $this;
    }
    /**
     * Add item to SystemCode value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSystemCode $item
     * @return \dgsoft\StructType\DgSystemCodes
     */
    public function addToSystemCode(\dgsoft\StructType\DgSystemCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgSystemCode) {
            throw new \InvalidArgumentException(sprintf('The SystemCode property can only contain items of \dgsoft\StructType\DgSystemCode, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SystemCode[] = $item;
        return $this;
    }
    /**
     * Get SystemCodesInclusive value
     * @return bool|null
     */
    public function getSystemCodesInclusive()
    {
        return $this->SystemCodesInclusive;
    }
    /**
     * Set SystemCodesInclusive value
     * @param bool $systemCodesInclusive
     * @return \dgsoft\StructType\DgSystemCodes
     */
    public function setSystemCodesInclusive($systemCodesInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($systemCodesInclusive) && !is_bool($systemCodesInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($systemCodesInclusive)), __LINE__);
        }
        $this->SystemCodesInclusive = $systemCodesInclusive;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgSystemCodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
