<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialServiceRequest StructType
 * @package Dg
 * @subpackage Structs
 */
class DgSpecialServiceRequest extends DgSpecialServiceRequestType
{
    /**
     * The SSRType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $SSRType;
    /**
     * The WithDogSpecified
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $WithDogSpecified;
    /**
     * The AnimalBoxType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AnimalBoxType;
    /**
     * The FlightLeg
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFlightLegType
     */
    public $FlightLeg;
    /**
     * The RequiredParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSSRRequiredParameterRQ
     */
    public $RequiredParameters;
    /**
     * The Height
     * @var int
     */
    public $Height;
    /**
     * The Width
     * @var int
     */
    public $Width;
    /**
     * The Length
     * @var int
     */
    public $Length;
    /**
     * The Weight
     * @var int
     */
    public $Weight;
    /**
     * The OtherEquipment
     * @var string
     */
    public $OtherEquipment;
    /**
     * The BaggageName
     * @var string
     */
    public $BaggageName;
    /**
     * The DisabledPassenger
     * @var string
     */
    public $DisabledPassenger;
    /**
     * The OtherAnimalType
     * @var string
     */
    public $OtherAnimalType;
    /**
     * The TravelerRefNumberRPHList
     * @var string[]
     */
    public $TravelerRefNumberRPHList;
    /**
     * The FlightRefNumberRPHList
     * @var string[]
     */
    public $FlightRefNumberRPHList;
    /**
     * The Notes
     * @var string
     */
    public $Notes;
    /**
     * The WithDog
     * @var bool
     */
    public $WithDog;
    /**
     * The AirlineCode
     * @var string
     */
    public $AirlineCode;
    /**
     * Constructor method for SpecialServiceRequest
     * @uses DgSpecialServiceRequest::setSSRType()
     * @uses DgSpecialServiceRequest::setWithDogSpecified()
     * @uses DgSpecialServiceRequest::setAnimalBoxType()
     * @uses DgSpecialServiceRequest::setFlightLeg()
     * @uses DgSpecialServiceRequest::setRequiredParameters()
     * @uses DgSpecialServiceRequest::setHeight()
     * @uses DgSpecialServiceRequest::setWidth()
     * @uses DgSpecialServiceRequest::setLength()
     * @uses DgSpecialServiceRequest::setWeight()
     * @uses DgSpecialServiceRequest::setOtherEquipment()
     * @uses DgSpecialServiceRequest::setBaggageName()
     * @uses DgSpecialServiceRequest::setDisabledPassenger()
     * @uses DgSpecialServiceRequest::setOtherAnimalType()
     * @uses DgSpecialServiceRequest::setTravelerRefNumberRPHList()
     * @uses DgSpecialServiceRequest::setFlightRefNumberRPHList()
     * @uses DgSpecialServiceRequest::setNotes()
     * @uses DgSpecialServiceRequest::setWithDog()
     * @uses DgSpecialServiceRequest::setAirlineCode()
     * @param string $sSRType
     * @param bool $withDogSpecified
     * @param string $animalBoxType
     * @param \dgsoft\StructType\DgFlightLegType $flightLeg
     * @param \dgsoft\ArrayType\DgArrayOfSSRRequiredParameterRQ $requiredParameters
     * @param int $height
     * @param int $width
     * @param int $length
     * @param int $weight
     * @param string $otherEquipment
     * @param string $baggageName
     * @param string $disabledPassenger
     * @param string $otherAnimalType
     * @param string[] $travelerRefNumberRPHList
     * @param string[] $flightRefNumberRPHList
     * @param string $notes
     * @param bool $withDog
     * @param string $airlineCode
     */
    public function __construct($sSRType = null, $withDogSpecified = null, $animalBoxType = null, \dgsoft\StructType\DgFlightLegType $flightLeg = null, \dgsoft\ArrayType\DgArrayOfSSRRequiredParameterRQ $requiredParameters = null, $height = null, $width = null, $length = null, $weight = null, $otherEquipment = null, $baggageName = null, $disabledPassenger = null, $otherAnimalType = null, array $travelerRefNumberRPHList = array(), array $flightRefNumberRPHList = array(), $notes = null, $withDog = null, $airlineCode = null)
    {
        $this
            ->setSSRType($sSRType)
            ->setWithDogSpecified($withDogSpecified)
            ->setAnimalBoxType($animalBoxType)
            ->setFlightLeg($flightLeg)
            ->setRequiredParameters($requiredParameters)
            ->setHeight($height)
            ->setWidth($width)
            ->setLength($length)
            ->setWeight($weight)
            ->setOtherEquipment($otherEquipment)
            ->setBaggageName($baggageName)
            ->setDisabledPassenger($disabledPassenger)
            ->setOtherAnimalType($otherAnimalType)
            ->setTravelerRefNumberRPHList($travelerRefNumberRPHList)
            ->setFlightRefNumberRPHList($flightRefNumberRPHList)
            ->setNotes($notes)
            ->setWithDog($withDog)
            ->setAirlineCode($airlineCode);
    }
    /**
     * Get SSRType value
     * @return string
     */
    public function getSSRType()
    {
        return $this->SSRType;
    }
    /**
     * Set SSRType value
     * @param string $sSRType
     * @return \dgsoft\StructType\DgSpecialServiceRequest
     */
    public function setSSRType($sSRType = null)
    {
        // validation for constraint: string
        if (!is_null($sSRType) && !is_string($sSRType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sSRType)), __LINE__);
        }
        $this->SSRType = $sSRType;
        return $this;
    }
    /**
     * Get WithDogSpecified value
     * @return bool
     */
    public function getWithDogSpecified()
    {
        return $this->WithDogSpecified;
    }
    /**
     * Set WithDogSpecified value
     * @param bool $withDogSpecified
     * @return \dgsoft\StructType\DgSpecialServiceRequest
     */
    public function setWithDogSpecified($withDogSpecified = null)
    {
        // validation for constraint: boolean
        if (!is_null($withDogSpecified) && !is_bool($withDogSpecified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($withDogSpecified)), __LINE__);
        }
        $this->WithDogSpecified = $withDogSpecified;
        return $this;
    }
    /**
     * Get AnimalBoxType value
     * @return string|null
     */
    public function getAnimalBoxType()
    {
        return $this->AnimalBoxType;
    }
    /**
     * Set AnimalBoxType value
     * @param string $animalBoxType
     * @return \dgsoft\StructType\DgSpecialServiceRequest
     */
    public function setAnimalBoxType($animalBoxType = null)
    {
        // validation for constraint: string
        if (!is_null($animalBoxType) && !is_string($animalBoxType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($animalBoxType)), __LINE__);
        }
        $this->AnimalBoxType = $animalBoxType;
        return $this;
    }
    /**
     * Get FlightLeg value
     * @return \dgsoft\StructType\DgFlightLegType|null
     */
    public function getFlightLeg()
    {
        return $this->FlightLeg;
    }
    /**
     * Set FlightLeg value
     * @param \dgsoft\StructType\DgFlightLegType $flightLeg
     * @return \dgsoft\StructType\DgSpecialServiceRequest
     */
    public function setFlightLeg(\dgsoft\StructType\DgFlightLegType $flightLeg = null)
    {
        $this->FlightLeg = $flightLeg;
        return $this;
    }
    /**
     * Get RequiredParameters value
     * @return \dgsoft\ArrayType\DgArrayOfSSRRequiredParameterRQ|null
     */
    public function getRequiredParameters()
    {
        return $this->RequiredParameters;
    }
    /**
     * Set RequiredParameters value
     * @param \dgsoft\ArrayType\DgArrayOfSSRRequiredParameterRQ $requiredParameters
     * @return \dgsoft\StructType\DgSpecialServiceRequest
     */
    public function setRequiredParameters(\dgsoft\ArrayType\DgArrayOfSSRRequiredParameterRQ $requiredParameters = null)
    {
        $this->RequiredParameters = $requiredParameters;
        return $this;
    }
    /**
     * Get Height value
     * @return int|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param int $height
     * @return \dgsoft\StructType\DgSpecialServiceRequest
     */
    public function setHeight($height = null)
    {
        // validation for constraint: int
        if (!is_null($height) && !is_numeric($height)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Get Width value
     * @return int|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param int $width
     * @return \dgsoft\StructType\DgSpecialServiceRequest
     */
    public function setWidth($width = null)
    {
        // validation for constraint: int
        if (!is_null($width) && !is_numeric($width)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get Length value
     * @return int|null
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param int $length
     * @return \dgsoft\StructType\DgSpecialServiceRequest
     */
    public function setLength($length = null)
    {
        // validation for constraint: int
        if (!is_null($length) && !is_numeric($length)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($length)), __LINE__);
        }
        $this->Length = $length;
        return $this;
    }
    /**
     * Get Weight value
     * @return int|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param int $weight
     * @return \dgsoft\StructType\DgSpecialServiceRequest
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: int
        if (!is_null($weight) && !is_numeric($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get OtherEquipment value
     * @return string|null
     */
    public function getOtherEquipment()
    {
        return $this->OtherEquipment;
    }
    /**
     * Set OtherEquipment value
     * @param string $otherEquipment
     * @return \dgsoft\StructType\DgSpecialServiceRequest
     */
    public function setOtherEquipment($otherEquipment = null)
    {
        // validation for constraint: string
        if (!is_null($otherEquipment) && !is_string($otherEquipment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherEquipment)), __LINE__);
        }
        $this->OtherEquipment = $otherEquipment;
        return $this;
    }
    /**
     * Get BaggageName value
     * @return string|null
     */
    public function getBaggageName()
    {
        return $this->BaggageName;
    }
    /**
     * Set BaggageName value
     * @param string $baggageName
     * @return \dgsoft\StructType\DgSpecialServiceRequest
     */
    public function setBaggageName($baggageName = null)
    {
        // validation for constraint: string
        if (!is_null($baggageName) && !is_string($baggageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baggageName)), __LINE__);
        }
        $this->BaggageName = $baggageName;
        return $this;
    }
    /**
     * Get DisabledPassenger value
     * @return string|null
     */
    public function getDisabledPassenger()
    {
        return $this->DisabledPassenger;
    }
    /**
     * Set DisabledPassenger value
     * @param string $disabledPassenger
     * @return \dgsoft\StructType\DgSpecialServiceRequest
     */
    public function setDisabledPassenger($disabledPassenger = null)
    {
        // validation for constraint: string
        if (!is_null($disabledPassenger) && !is_string($disabledPassenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($disabledPassenger)), __LINE__);
        }
        $this->DisabledPassenger = $disabledPassenger;
        return $this;
    }
    /**
     * Get OtherAnimalType value
     * @return string|null
     */
    public function getOtherAnimalType()
    {
        return $this->OtherAnimalType;
    }
    /**
     * Set OtherAnimalType value
     * @param string $otherAnimalType
     * @return \dgsoft\StructType\DgSpecialServiceRequest
     */
    public function setOtherAnimalType($otherAnimalType = null)
    {
        // validation for constraint: string
        if (!is_null($otherAnimalType) && !is_string($otherAnimalType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherAnimalType)), __LINE__);
        }
        $this->OtherAnimalType = $otherAnimalType;
        return $this;
    }
    /**
     * Get TravelerRefNumberRPHList value
     * @return string[]|null
     */
    public function getTravelerRefNumberRPHList()
    {
        return $this->TravelerRefNumberRPHList;
    }
    /**
     * Set TravelerRefNumberRPHList value
     * @throws \InvalidArgumentException
     * @param string[] $travelerRefNumberRPHList
     * @return \dgsoft\StructType\DgSpecialServiceRequest
     */
    public function setTravelerRefNumberRPHList(array $travelerRefNumberRPHList = array())
    {
        foreach ($travelerRefNumberRPHList as $specialServiceRequestTravelerRefNumberRPHListItem) {
            // validation for constraint: itemType
            if (!is_string($specialServiceRequestTravelerRefNumberRPHListItem)) {
                throw new \InvalidArgumentException(sprintf('The TravelerRefNumberRPHList property can only contain items of string, "%s" given', is_object($specialServiceRequestTravelerRefNumberRPHListItem) ? get_class($specialServiceRequestTravelerRefNumberRPHListItem) : gettype($specialServiceRequestTravelerRefNumberRPHListItem)), __LINE__);
            }
        }
        $this->TravelerRefNumberRPHList = $travelerRefNumberRPHList;
        return $this;
    }
    /**
     * Add item to TravelerRefNumberRPHList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgSpecialServiceRequest
     */
    public function addToTravelerRefNumberRPHList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The TravelerRefNumberRPHList property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TravelerRefNumberRPHList[] = $item;
        return $this;
    }
    /**
     * Get FlightRefNumberRPHList value
     * @return string[]|null
     */
    public function getFlightRefNumberRPHList()
    {
        return $this->FlightRefNumberRPHList;
    }
    /**
     * Set FlightRefNumberRPHList value
     * @throws \InvalidArgumentException
     * @param string[] $flightRefNumberRPHList
     * @return \dgsoft\StructType\DgSpecialServiceRequest
     */
    public function setFlightRefNumberRPHList(array $flightRefNumberRPHList = array())
    {
        foreach ($flightRefNumberRPHList as $specialServiceRequestFlightRefNumberRPHListItem) {
            // validation for constraint: itemType
            if (!is_string($specialServiceRequestFlightRefNumberRPHListItem)) {
                throw new \InvalidArgumentException(sprintf('The FlightRefNumberRPHList property can only contain items of string, "%s" given', is_object($specialServiceRequestFlightRefNumberRPHListItem) ? get_class($specialServiceRequestFlightRefNumberRPHListItem) : gettype($specialServiceRequestFlightRefNumberRPHListItem)), __LINE__);
            }
        }
        $this->FlightRefNumberRPHList = $flightRefNumberRPHList;
        return $this;
    }
    /**
     * Add item to FlightRefNumberRPHList value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgSpecialServiceRequest
     */
    public function addToFlightRefNumberRPHList($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The FlightRefNumberRPHList property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FlightRefNumberRPHList[] = $item;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \dgsoft\StructType\DgSpecialServiceRequest
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get WithDog value
     * @return bool|null
     */
    public function getWithDog()
    {
        return $this->WithDog;
    }
    /**
     * Set WithDog value
     * @param bool $withDog
     * @return \dgsoft\StructType\DgSpecialServiceRequest
     */
    public function setWithDog($withDog = null)
    {
        // validation for constraint: boolean
        if (!is_null($withDog) && !is_bool($withDog)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($withDog)), __LINE__);
        }
        $this->WithDog = $withDog;
        return $this;
    }
    /**
     * Get AirlineCode value
     * @return string|null
     */
    public function getAirlineCode()
    {
        return $this->AirlineCode;
    }
    /**
     * Set AirlineCode value
     * @param string $airlineCode
     * @return \dgsoft\StructType\DgSpecialServiceRequest
     */
    public function setAirlineCode($airlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($airlineCode) && !is_string($airlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airlineCode)), __LINE__);
        }
        $this->AirlineCode = $airlineCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgSpecialServiceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
