<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialRemark StructType
 * @package Dg
 * @subpackage Structs
 */
class DgSpecialRemark extends DgSpecialRemarkType
{
    /**
     * The FlightLeg
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFlightLegType
     */
    public $FlightLeg;
    /**
     * The Operation
     * @var string
     */
    public $Operation;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for SpecialRemark
     * @uses DgSpecialRemark::setFlightLeg()
     * @uses DgSpecialRemark::setOperation()
     * @uses DgSpecialRemark::setRPH()
     * @param \dgsoft\StructType\DgFlightLegType $flightLeg
     * @param string $operation
     * @param string $rPH
     */
    public function __construct(\dgsoft\StructType\DgFlightLegType $flightLeg = null, $operation = null, $rPH = null)
    {
        $this
            ->setFlightLeg($flightLeg)
            ->setOperation($operation)
            ->setRPH($rPH);
    }
    /**
     * Get FlightLeg value
     * @return \dgsoft\StructType\DgFlightLegType|null
     */
    public function getFlightLeg()
    {
        return $this->FlightLeg;
    }
    /**
     * Set FlightLeg value
     * @param \dgsoft\StructType\DgFlightLegType $flightLeg
     * @return \dgsoft\StructType\DgSpecialRemark
     */
    public function setFlightLeg(\dgsoft\StructType\DgFlightLegType $flightLeg = null)
    {
        $this->FlightLeg = $flightLeg;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \dgsoft\EnumType\DgActionType::valueIsValid()
     * @uses \dgsoft\EnumType\DgActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \dgsoft\StructType\DgSpecialRemark
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $operation, implode(', ', \dgsoft\EnumType\DgActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \dgsoft\StructType\DgSpecialRemark
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgSpecialRemark
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
