<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServicesTypeService StructType
 * @package Dg
 * @subpackage Structs
 */
class DgServicesTypeService extends AbstractStructBase
{
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAmountType[]
     */
    public $Price;
    /**
     * The ServiceDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgResCommonDetailType
     */
    public $ServiceDetails;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The ServicePricingType
     * @var string
     */
    public $ServicePricingType;
    /**
     * The ReservationStatusType
     * @var string
     */
    public $ReservationStatusType;
    /**
     * The ServiceRPH
     * @var string
     */
    public $ServiceRPH;
    /**
     * The ServiceInventoryCode
     * @var string
     */
    public $ServiceInventoryCode;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The InventoryBlockCode
     * @var string
     */
    public $InventoryBlockCode;
    /**
     * The PriceGuaranteed
     * @var bool
     */
    public $PriceGuaranteed;
    /**
     * The Inclusive
     * @var bool
     */
    public $Inclusive;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The RequestedIndicator
     * @var bool
     */
    public $RequestedIndicator;
    /**
     * Constructor method for ServicesTypeService
     * @uses DgServicesTypeService::setPrice()
     * @uses DgServicesTypeService::setServiceDetails()
     * @uses DgServicesTypeService::setTPA_Extensions()
     * @uses DgServicesTypeService::setServicePricingType()
     * @uses DgServicesTypeService::setReservationStatusType()
     * @uses DgServicesTypeService::setServiceRPH()
     * @uses DgServicesTypeService::setServiceInventoryCode()
     * @uses DgServicesTypeService::setRatePlanCode()
     * @uses DgServicesTypeService::setInventoryBlockCode()
     * @uses DgServicesTypeService::setPriceGuaranteed()
     * @uses DgServicesTypeService::setInclusive()
     * @uses DgServicesTypeService::setQuantity()
     * @uses DgServicesTypeService::setRequestedIndicator()
     * @param \dgsoft\StructType\DgAmountType[] $price
     * @param \dgsoft\StructType\DgResCommonDetailType $serviceDetails
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param string $servicePricingType
     * @param string $reservationStatusType
     * @param string $serviceRPH
     * @param string $serviceInventoryCode
     * @param string $ratePlanCode
     * @param string $inventoryBlockCode
     * @param bool $priceGuaranteed
     * @param bool $inclusive
     * @param int $quantity
     * @param bool $requestedIndicator
     */
    public function __construct(array $price = array(), \dgsoft\StructType\DgResCommonDetailType $serviceDetails = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $servicePricingType = null, $reservationStatusType = null, $serviceRPH = null, $serviceInventoryCode = null, $ratePlanCode = null, $inventoryBlockCode = null, $priceGuaranteed = null, $inclusive = null, $quantity = null, $requestedIndicator = null)
    {
        $this
            ->setPrice($price)
            ->setServiceDetails($serviceDetails)
            ->setTPA_Extensions($tPA_Extensions)
            ->setServicePricingType($servicePricingType)
            ->setReservationStatusType($reservationStatusType)
            ->setServiceRPH($serviceRPH)
            ->setServiceInventoryCode($serviceInventoryCode)
            ->setRatePlanCode($ratePlanCode)
            ->setInventoryBlockCode($inventoryBlockCode)
            ->setPriceGuaranteed($priceGuaranteed)
            ->setInclusive($inclusive)
            ->setQuantity($quantity)
            ->setRequestedIndicator($requestedIndicator);
    }
    /**
     * Get Price value
     * @return \dgsoft\StructType\DgAmountType[]|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAmountType[] $price
     * @return \dgsoft\StructType\DgServicesTypeService
     */
    public function setPrice(array $price = array())
    {
        foreach ($price as $servicesTypeServicePriceItem) {
            // validation for constraint: itemType
            if (!$servicesTypeServicePriceItem instanceof \dgsoft\StructType\DgAmountType) {
                throw new \InvalidArgumentException(sprintf('The Price property can only contain items of \dgsoft\StructType\DgAmountType, "%s" given', is_object($servicesTypeServicePriceItem) ? get_class($servicesTypeServicePriceItem) : gettype($servicesTypeServicePriceItem)), __LINE__);
            }
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Add item to Price value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAmountType $item
     * @return \dgsoft\StructType\DgServicesTypeService
     */
    public function addToPrice(\dgsoft\StructType\DgAmountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAmountType) {
            throw new \InvalidArgumentException(sprintf('The Price property can only contain items of \dgsoft\StructType\DgAmountType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Price[] = $item;
        return $this;
    }
    /**
     * Get ServiceDetails value
     * @return \dgsoft\StructType\DgResCommonDetailType|null
     */
    public function getServiceDetails()
    {
        return $this->ServiceDetails;
    }
    /**
     * Set ServiceDetails value
     * @param \dgsoft\StructType\DgResCommonDetailType $serviceDetails
     * @return \dgsoft\StructType\DgServicesTypeService
     */
    public function setServiceDetails(\dgsoft\StructType\DgResCommonDetailType $serviceDetails = null)
    {
        $this->ServiceDetails = $serviceDetails;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgServicesTypeService
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ServicePricingType value
     * @return string|null
     */
    public function getServicePricingType()
    {
        return $this->ServicePricingType;
    }
    /**
     * Set ServicePricingType value
     * @uses \dgsoft\EnumType\DgPricingType::valueIsValid()
     * @uses \dgsoft\EnumType\DgPricingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $servicePricingType
     * @return \dgsoft\StructType\DgServicesTypeService
     */
    public function setServicePricingType($servicePricingType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgPricingType::valueIsValid($servicePricingType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $servicePricingType, implode(', ', \dgsoft\EnumType\DgPricingType::getValidValues())), __LINE__);
        }
        $this->ServicePricingType = $servicePricingType;
        return $this;
    }
    /**
     * Get ReservationStatusType value
     * @return string|null
     */
    public function getReservationStatusType()
    {
        return $this->ReservationStatusType;
    }
    /**
     * Set ReservationStatusType value
     * @uses \dgsoft\EnumType\DgPMS_ResStatusType::valueIsValid()
     * @uses \dgsoft\EnumType\DgPMS_ResStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reservationStatusType
     * @return \dgsoft\StructType\DgServicesTypeService
     */
    public function setReservationStatusType($reservationStatusType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgPMS_ResStatusType::valueIsValid($reservationStatusType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $reservationStatusType, implode(', ', \dgsoft\EnumType\DgPMS_ResStatusType::getValidValues())), __LINE__);
        }
        $this->ReservationStatusType = $reservationStatusType;
        return $this;
    }
    /**
     * Get ServiceRPH value
     * @return string|null
     */
    public function getServiceRPH()
    {
        return $this->ServiceRPH;
    }
    /**
     * Set ServiceRPH value
     * @param string $serviceRPH
     * @return \dgsoft\StructType\DgServicesTypeService
     */
    public function setServiceRPH($serviceRPH = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRPH) && !is_string($serviceRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceRPH)), __LINE__);
        }
        $this->ServiceRPH = $serviceRPH;
        return $this;
    }
    /**
     * Get ServiceInventoryCode value
     * @return string|null
     */
    public function getServiceInventoryCode()
    {
        return $this->ServiceInventoryCode;
    }
    /**
     * Set ServiceInventoryCode value
     * @param string $serviceInventoryCode
     * @return \dgsoft\StructType\DgServicesTypeService
     */
    public function setServiceInventoryCode($serviceInventoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceInventoryCode) && !is_string($serviceInventoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceInventoryCode)), __LINE__);
        }
        $this->ServiceInventoryCode = $serviceInventoryCode;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \dgsoft\StructType\DgServicesTypeService
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get InventoryBlockCode value
     * @return string|null
     */
    public function getInventoryBlockCode()
    {
        return $this->InventoryBlockCode;
    }
    /**
     * Set InventoryBlockCode value
     * @param string $inventoryBlockCode
     * @return \dgsoft\StructType\DgServicesTypeService
     */
    public function setInventoryBlockCode($inventoryBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryBlockCode) && !is_string($inventoryBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inventoryBlockCode)), __LINE__);
        }
        $this->InventoryBlockCode = $inventoryBlockCode;
        return $this;
    }
    /**
     * Get PriceGuaranteed value
     * @return bool|null
     */
    public function getPriceGuaranteed()
    {
        return $this->PriceGuaranteed;
    }
    /**
     * Set PriceGuaranteed value
     * @param bool $priceGuaranteed
     * @return \dgsoft\StructType\DgServicesTypeService
     */
    public function setPriceGuaranteed($priceGuaranteed = null)
    {
        // validation for constraint: boolean
        if (!is_null($priceGuaranteed) && !is_bool($priceGuaranteed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($priceGuaranteed)), __LINE__);
        }
        $this->PriceGuaranteed = $priceGuaranteed;
        return $this;
    }
    /**
     * Get Inclusive value
     * @return bool|null
     */
    public function getInclusive()
    {
        return $this->Inclusive;
    }
    /**
     * Set Inclusive value
     * @param bool $inclusive
     * @return \dgsoft\StructType\DgServicesTypeService
     */
    public function setInclusive($inclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inclusive) && !is_bool($inclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($inclusive)), __LINE__);
        }
        $this->Inclusive = $inclusive;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \dgsoft\StructType\DgServicesTypeService
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get RequestedIndicator value
     * @return bool|null
     */
    public function getRequestedIndicator()
    {
        return $this->RequestedIndicator;
    }
    /**
     * Set RequestedIndicator value
     * @param bool $requestedIndicator
     * @return \dgsoft\StructType\DgServicesTypeService
     */
    public function setRequestedIndicator($requestedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($requestedIndicator) && !is_bool($requestedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($requestedIndicator)), __LINE__);
        }
        $this->RequestedIndicator = $requestedIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgServicesTypeService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
