<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceFeesType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgServiceFeesType extends AbstractStructBase
{
    /**
     * The ServiceFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgServiceFeeType[]
     */
    public $ServiceFee;
    /**
     * The BookingFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgBookingFeeType
     */
    public $BookingFee;
    /**
     * The HotelExtraFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgHotelExtraFeeType
     */
    public $HotelExtraFee;
    /**
     * The CarExtraFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCarExtraFeeType
     */
    public $CarExtraFee;
    /**
     * The InsuranceExtraFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgInsuranceExtraFeeType
     */
    public $InsuranceExtraFee;
    /**
     * The DeliveryFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDeliveryFeeType
     */
    public $DeliveryFee;
    /**
     * The PaymentFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPaymentFeeType
     */
    public $PaymentFee;
    /**
     * The AirlineOBFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAirlineOBFeeType
     */
    public $AirlineOBFee;
    /**
     * The AncillaryFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAncillaryFeeType
     */
    public $AncillaryFee;
    /**
     * The CCOBFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCCOBFeeType
     */
    public $CCOBFee;
    /**
     * The OtherExtraCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOtherExtraCostType[]
     */
    public $OtherExtraCost;
    /**
     * Constructor method for ServiceFeesType
     * @uses DgServiceFeesType::setServiceFee()
     * @uses DgServiceFeesType::setBookingFee()
     * @uses DgServiceFeesType::setHotelExtraFee()
     * @uses DgServiceFeesType::setCarExtraFee()
     * @uses DgServiceFeesType::setInsuranceExtraFee()
     * @uses DgServiceFeesType::setDeliveryFee()
     * @uses DgServiceFeesType::setPaymentFee()
     * @uses DgServiceFeesType::setAirlineOBFee()
     * @uses DgServiceFeesType::setAncillaryFee()
     * @uses DgServiceFeesType::setCCOBFee()
     * @uses DgServiceFeesType::setOtherExtraCost()
     * @param \dgsoft\StructType\DgServiceFeeType[] $serviceFee
     * @param \dgsoft\StructType\DgBookingFeeType $bookingFee
     * @param \dgsoft\StructType\DgHotelExtraFeeType $hotelExtraFee
     * @param \dgsoft\StructType\DgCarExtraFeeType $carExtraFee
     * @param \dgsoft\StructType\DgInsuranceExtraFeeType $insuranceExtraFee
     * @param \dgsoft\StructType\DgDeliveryFeeType $deliveryFee
     * @param \dgsoft\StructType\DgPaymentFeeType $paymentFee
     * @param \dgsoft\StructType\DgAirlineOBFeeType $airlineOBFee
     * @param \dgsoft\StructType\DgAncillaryFeeType $ancillaryFee
     * @param \dgsoft\StructType\DgCCOBFeeType $cCOBFee
     * @param \dgsoft\StructType\DgOtherExtraCostType[] $otherExtraCost
     */
    public function __construct(array $serviceFee = array(), \dgsoft\StructType\DgBookingFeeType $bookingFee = null, \dgsoft\StructType\DgHotelExtraFeeType $hotelExtraFee = null, \dgsoft\StructType\DgCarExtraFeeType $carExtraFee = null, \dgsoft\StructType\DgInsuranceExtraFeeType $insuranceExtraFee = null, \dgsoft\StructType\DgDeliveryFeeType $deliveryFee = null, \dgsoft\StructType\DgPaymentFeeType $paymentFee = null, \dgsoft\StructType\DgAirlineOBFeeType $airlineOBFee = null, \dgsoft\StructType\DgAncillaryFeeType $ancillaryFee = null, \dgsoft\StructType\DgCCOBFeeType $cCOBFee = null, array $otherExtraCost = array())
    {
        $this
            ->setServiceFee($serviceFee)
            ->setBookingFee($bookingFee)
            ->setHotelExtraFee($hotelExtraFee)
            ->setCarExtraFee($carExtraFee)
            ->setInsuranceExtraFee($insuranceExtraFee)
            ->setDeliveryFee($deliveryFee)
            ->setPaymentFee($paymentFee)
            ->setAirlineOBFee($airlineOBFee)
            ->setAncillaryFee($ancillaryFee)
            ->setCCOBFee($cCOBFee)
            ->setOtherExtraCost($otherExtraCost);
    }
    /**
     * Get ServiceFee value
     * @return \dgsoft\StructType\DgServiceFeeType[]|null
     */
    public function getServiceFee()
    {
        return $this->ServiceFee;
    }
    /**
     * Set ServiceFee value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgServiceFeeType[] $serviceFee
     * @return \dgsoft\StructType\DgServiceFeesType
     */
    public function setServiceFee(array $serviceFee = array())
    {
        foreach ($serviceFee as $serviceFeesTypeServiceFeeItem) {
            // validation for constraint: itemType
            if (!$serviceFeesTypeServiceFeeItem instanceof \dgsoft\StructType\DgServiceFeeType) {
                throw new \InvalidArgumentException(sprintf('The ServiceFee property can only contain items of \dgsoft\StructType\DgServiceFeeType, "%s" given', is_object($serviceFeesTypeServiceFeeItem) ? get_class($serviceFeesTypeServiceFeeItem) : gettype($serviceFeesTypeServiceFeeItem)), __LINE__);
            }
        }
        $this->ServiceFee = $serviceFee;
        return $this;
    }
    /**
     * Add item to ServiceFee value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgServiceFeeType $item
     * @return \dgsoft\StructType\DgServiceFeesType
     */
    public function addToServiceFee(\dgsoft\StructType\DgServiceFeeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgServiceFeeType) {
            throw new \InvalidArgumentException(sprintf('The ServiceFee property can only contain items of \dgsoft\StructType\DgServiceFeeType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ServiceFee[] = $item;
        return $this;
    }
    /**
     * Get BookingFee value
     * @return \dgsoft\StructType\DgBookingFeeType|null
     */
    public function getBookingFee()
    {
        return $this->BookingFee;
    }
    /**
     * Set BookingFee value
     * @param \dgsoft\StructType\DgBookingFeeType $bookingFee
     * @return \dgsoft\StructType\DgServiceFeesType
     */
    public function setBookingFee(\dgsoft\StructType\DgBookingFeeType $bookingFee = null)
    {
        $this->BookingFee = $bookingFee;
        return $this;
    }
    /**
     * Get HotelExtraFee value
     * @return \dgsoft\StructType\DgHotelExtraFeeType|null
     */
    public function getHotelExtraFee()
    {
        return $this->HotelExtraFee;
    }
    /**
     * Set HotelExtraFee value
     * @param \dgsoft\StructType\DgHotelExtraFeeType $hotelExtraFee
     * @return \dgsoft\StructType\DgServiceFeesType
     */
    public function setHotelExtraFee(\dgsoft\StructType\DgHotelExtraFeeType $hotelExtraFee = null)
    {
        $this->HotelExtraFee = $hotelExtraFee;
        return $this;
    }
    /**
     * Get CarExtraFee value
     * @return \dgsoft\StructType\DgCarExtraFeeType|null
     */
    public function getCarExtraFee()
    {
        return $this->CarExtraFee;
    }
    /**
     * Set CarExtraFee value
     * @param \dgsoft\StructType\DgCarExtraFeeType $carExtraFee
     * @return \dgsoft\StructType\DgServiceFeesType
     */
    public function setCarExtraFee(\dgsoft\StructType\DgCarExtraFeeType $carExtraFee = null)
    {
        $this->CarExtraFee = $carExtraFee;
        return $this;
    }
    /**
     * Get InsuranceExtraFee value
     * @return \dgsoft\StructType\DgInsuranceExtraFeeType|null
     */
    public function getInsuranceExtraFee()
    {
        return $this->InsuranceExtraFee;
    }
    /**
     * Set InsuranceExtraFee value
     * @param \dgsoft\StructType\DgInsuranceExtraFeeType $insuranceExtraFee
     * @return \dgsoft\StructType\DgServiceFeesType
     */
    public function setInsuranceExtraFee(\dgsoft\StructType\DgInsuranceExtraFeeType $insuranceExtraFee = null)
    {
        $this->InsuranceExtraFee = $insuranceExtraFee;
        return $this;
    }
    /**
     * Get DeliveryFee value
     * @return \dgsoft\StructType\DgDeliveryFeeType|null
     */
    public function getDeliveryFee()
    {
        return $this->DeliveryFee;
    }
    /**
     * Set DeliveryFee value
     * @param \dgsoft\StructType\DgDeliveryFeeType $deliveryFee
     * @return \dgsoft\StructType\DgServiceFeesType
     */
    public function setDeliveryFee(\dgsoft\StructType\DgDeliveryFeeType $deliveryFee = null)
    {
        $this->DeliveryFee = $deliveryFee;
        return $this;
    }
    /**
     * Get PaymentFee value
     * @return \dgsoft\StructType\DgPaymentFeeType|null
     */
    public function getPaymentFee()
    {
        return $this->PaymentFee;
    }
    /**
     * Set PaymentFee value
     * @param \dgsoft\StructType\DgPaymentFeeType $paymentFee
     * @return \dgsoft\StructType\DgServiceFeesType
     */
    public function setPaymentFee(\dgsoft\StructType\DgPaymentFeeType $paymentFee = null)
    {
        $this->PaymentFee = $paymentFee;
        return $this;
    }
    /**
     * Get AirlineOBFee value
     * @return \dgsoft\StructType\DgAirlineOBFeeType|null
     */
    public function getAirlineOBFee()
    {
        return $this->AirlineOBFee;
    }
    /**
     * Set AirlineOBFee value
     * @param \dgsoft\StructType\DgAirlineOBFeeType $airlineOBFee
     * @return \dgsoft\StructType\DgServiceFeesType
     */
    public function setAirlineOBFee(\dgsoft\StructType\DgAirlineOBFeeType $airlineOBFee = null)
    {
        $this->AirlineOBFee = $airlineOBFee;
        return $this;
    }
    /**
     * Get AncillaryFee value
     * @return \dgsoft\StructType\DgAncillaryFeeType|null
     */
    public function getAncillaryFee()
    {
        return $this->AncillaryFee;
    }
    /**
     * Set AncillaryFee value
     * @param \dgsoft\StructType\DgAncillaryFeeType $ancillaryFee
     * @return \dgsoft\StructType\DgServiceFeesType
     */
    public function setAncillaryFee(\dgsoft\StructType\DgAncillaryFeeType $ancillaryFee = null)
    {
        $this->AncillaryFee = $ancillaryFee;
        return $this;
    }
    /**
     * Get CCOBFee value
     * @return \dgsoft\StructType\DgCCOBFeeType|null
     */
    public function getCCOBFee()
    {
        return $this->CCOBFee;
    }
    /**
     * Set CCOBFee value
     * @param \dgsoft\StructType\DgCCOBFeeType $cCOBFee
     * @return \dgsoft\StructType\DgServiceFeesType
     */
    public function setCCOBFee(\dgsoft\StructType\DgCCOBFeeType $cCOBFee = null)
    {
        $this->CCOBFee = $cCOBFee;
        return $this;
    }
    /**
     * Get OtherExtraCost value
     * @return \dgsoft\StructType\DgOtherExtraCostType[]|null
     */
    public function getOtherExtraCost()
    {
        return $this->OtherExtraCost;
    }
    /**
     * Set OtherExtraCost value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOtherExtraCostType[] $otherExtraCost
     * @return \dgsoft\StructType\DgServiceFeesType
     */
    public function setOtherExtraCost(array $otherExtraCost = array())
    {
        foreach ($otherExtraCost as $serviceFeesTypeOtherExtraCostItem) {
            // validation for constraint: itemType
            if (!$serviceFeesTypeOtherExtraCostItem instanceof \dgsoft\StructType\DgOtherExtraCostType) {
                throw new \InvalidArgumentException(sprintf('The OtherExtraCost property can only contain items of \dgsoft\StructType\DgOtherExtraCostType, "%s" given', is_object($serviceFeesTypeOtherExtraCostItem) ? get_class($serviceFeesTypeOtherExtraCostItem) : gettype($serviceFeesTypeOtherExtraCostItem)), __LINE__);
            }
        }
        $this->OtherExtraCost = $otherExtraCost;
        return $this;
    }
    /**
     * Add item to OtherExtraCost value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOtherExtraCostType $item
     * @return \dgsoft\StructType\DgServiceFeesType
     */
    public function addToOtherExtraCost(\dgsoft\StructType\DgOtherExtraCostType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgOtherExtraCostType) {
            throw new \InvalidArgumentException(sprintf('The OtherExtraCost property can only contain items of \dgsoft\StructType\DgOtherExtraCostType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OtherExtraCost[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgServiceFeesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
