<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectedSailing StructType
 * @package Dg
 * @subpackage Structs
 */
class DgSelectedSailing extends AbstractStructBase
{
    /**
     * The VoyageID
     * @var string
     */
    public $VoyageID;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The GroupCode
     * @var string
     */
    public $GroupCode;
    /**
     * Constructor method for SelectedSailing
     * @uses DgSelectedSailing::setVoyageID()
     * @uses DgSelectedSailing::setStatus()
     * @uses DgSelectedSailing::setGroupCode()
     * @param string $voyageID
     * @param string $status
     * @param string $groupCode
     */
    public function __construct($voyageID = null, $status = null, $groupCode = null)
    {
        $this
            ->setVoyageID($voyageID)
            ->setStatus($status)
            ->setGroupCode($groupCode);
    }
    /**
     * Get VoyageID value
     * @return string|null
     */
    public function getVoyageID()
    {
        return $this->VoyageID;
    }
    /**
     * Set VoyageID value
     * @param string $voyageID
     * @return \dgsoft\StructType\DgSelectedSailing
     */
    public function setVoyageID($voyageID = null)
    {
        // validation for constraint: string
        if (!is_null($voyageID) && !is_string($voyageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voyageID)), __LINE__);
        }
        $this->VoyageID = $voyageID;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \dgsoft\StructType\DgSelectedSailing
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get GroupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param string $groupCode
     * @return \dgsoft\StructType\DgSelectedSailing
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupCode)), __LINE__);
        }
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgSelectedSailing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
