<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatTakenParameter StructType
 * @package Dg
 * @subpackage Structs
 */
class DgSeatTakenParameter extends AbstractStructBase
{
    /**
     * The SegmentRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SegmentRef;
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * Constructor method for SeatTakenParameter
     * @uses DgSeatTakenParameter::setSegmentRef()
     * @uses DgSeatTakenParameter::setStatusCode()
     * @param string $segmentRef
     * @param string $statusCode
     */
    public function __construct($segmentRef = null, $statusCode = null)
    {
        $this
            ->setSegmentRef($segmentRef)
            ->setStatusCode($statusCode);
    }
    /**
     * Get SegmentRef value
     * @return string|null
     */
    public function getSegmentRef()
    {
        return $this->SegmentRef;
    }
    /**
     * Set SegmentRef value
     * @param string $segmentRef
     * @return \dgsoft\StructType\DgSeatTakenParameter
     */
    public function setSegmentRef($segmentRef = null)
    {
        // validation for constraint: string
        if (!is_null($segmentRef) && !is_string($segmentRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($segmentRef)), __LINE__);
        }
        $this->SegmentRef = $segmentRef;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \dgsoft\StructType\DgSeatTakenParameter
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgSeatTakenParameter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
