<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatRequestType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgSeatRequestType extends AbstractStructBase
{
    /**
     * The DepartureAirport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLocationType
     */
    public $DepartureAirport;
    /**
     * The ArrivalAirport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLocationType
     */
    public $ArrivalAirport;
    /**
     * The SeatNumber
     * @var string
     */
    public $SeatNumber;
    /**
     * The SeatPrice
     * @var string
     */
    public $SeatPrice;
    /**
     * The SeatPriceCurrency
     * @var string
     */
    public $SeatPriceCurrency;
    /**
     * The SeatPreference
     * @var string
     */
    public $SeatPreference;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The FlightNumber
     * @var string
     */
    public $FlightNumber;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The ItineraryID
     * @var string
     */
    public $ItineraryID;
    /**
     * The SegmentID
     * @var string
     */
    public $SegmentID;
    /**
     * Constructor method for SeatRequestType
     * @uses DgSeatRequestType::setDepartureAirport()
     * @uses DgSeatRequestType::setArrivalAirport()
     * @uses DgSeatRequestType::setSeatNumber()
     * @uses DgSeatRequestType::setSeatPrice()
     * @uses DgSeatRequestType::setSeatPriceCurrency()
     * @uses DgSeatRequestType::setSeatPreference()
     * @uses DgSeatRequestType::setDepartureDate()
     * @uses DgSeatRequestType::setFlightNumber()
     * @uses DgSeatRequestType::setStatus()
     * @uses DgSeatRequestType::setItineraryID()
     * @uses DgSeatRequestType::setSegmentID()
     * @param \dgsoft\StructType\DgLocationType $departureAirport
     * @param \dgsoft\StructType\DgLocationType $arrivalAirport
     * @param string $seatNumber
     * @param string $seatPrice
     * @param string $seatPriceCurrency
     * @param string $seatPreference
     * @param string $departureDate
     * @param string $flightNumber
     * @param string $status
     * @param string $itineraryID
     * @param string $segmentID
     */
    public function __construct(\dgsoft\StructType\DgLocationType $departureAirport = null, \dgsoft\StructType\DgLocationType $arrivalAirport = null, $seatNumber = null, $seatPrice = null, $seatPriceCurrency = null, $seatPreference = null, $departureDate = null, $flightNumber = null, $status = null, $itineraryID = null, $segmentID = null)
    {
        $this
            ->setDepartureAirport($departureAirport)
            ->setArrivalAirport($arrivalAirport)
            ->setSeatNumber($seatNumber)
            ->setSeatPrice($seatPrice)
            ->setSeatPriceCurrency($seatPriceCurrency)
            ->setSeatPreference($seatPreference)
            ->setDepartureDate($departureDate)
            ->setFlightNumber($flightNumber)
            ->setStatus($status)
            ->setItineraryID($itineraryID)
            ->setSegmentID($segmentID);
    }
    /**
     * Get DepartureAirport value
     * @return \dgsoft\StructType\DgLocationType|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param \dgsoft\StructType\DgLocationType $departureAirport
     * @return \dgsoft\StructType\DgSeatRequestType
     */
    public function setDepartureAirport(\dgsoft\StructType\DgLocationType $departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return \dgsoft\StructType\DgLocationType|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param \dgsoft\StructType\DgLocationType $arrivalAirport
     * @return \dgsoft\StructType\DgSeatRequestType
     */
    public function setArrivalAirport(\dgsoft\StructType\DgLocationType $arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get SeatNumber value
     * @return string|null
     */
    public function getSeatNumber()
    {
        return $this->SeatNumber;
    }
    /**
     * Set SeatNumber value
     * @param string $seatNumber
     * @return \dgsoft\StructType\DgSeatRequestType
     */
    public function setSeatNumber($seatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seatNumber) && !is_string($seatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seatNumber)), __LINE__);
        }
        $this->SeatNumber = $seatNumber;
        return $this;
    }
    /**
     * Get SeatPrice value
     * @return string|null
     */
    public function getSeatPrice()
    {
        return $this->SeatPrice;
    }
    /**
     * Set SeatPrice value
     * @param string $seatPrice
     * @return \dgsoft\StructType\DgSeatRequestType
     */
    public function setSeatPrice($seatPrice = null)
    {
        // validation for constraint: string
        if (!is_null($seatPrice) && !is_string($seatPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seatPrice)), __LINE__);
        }
        $this->SeatPrice = $seatPrice;
        return $this;
    }
    /**
     * Get SeatPriceCurrency value
     * @return string|null
     */
    public function getSeatPriceCurrency()
    {
        return $this->SeatPriceCurrency;
    }
    /**
     * Set SeatPriceCurrency value
     * @param string $seatPriceCurrency
     * @return \dgsoft\StructType\DgSeatRequestType
     */
    public function setSeatPriceCurrency($seatPriceCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($seatPriceCurrency) && !is_string($seatPriceCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seatPriceCurrency)), __LINE__);
        }
        $this->SeatPriceCurrency = $seatPriceCurrency;
        return $this;
    }
    /**
     * Get SeatPreference value
     * @return string|null
     */
    public function getSeatPreference()
    {
        return $this->SeatPreference;
    }
    /**
     * Set SeatPreference value
     * @param string $seatPreference
     * @return \dgsoft\StructType\DgSeatRequestType
     */
    public function setSeatPreference($seatPreference = null)
    {
        // validation for constraint: string
        if (!is_null($seatPreference) && !is_string($seatPreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seatPreference)), __LINE__);
        }
        $this->SeatPreference = $seatPreference;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \dgsoft\StructType\DgSeatRequestType
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \dgsoft\StructType\DgSeatRequestType
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \dgsoft\StructType\DgSeatRequestType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ItineraryID value
     * @return string|null
     */
    public function getItineraryID()
    {
        return $this->ItineraryID;
    }
    /**
     * Set ItineraryID value
     * @param string $itineraryID
     * @return \dgsoft\StructType\DgSeatRequestType
     */
    public function setItineraryID($itineraryID = null)
    {
        // validation for constraint: string
        if (!is_null($itineraryID) && !is_string($itineraryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itineraryID)), __LINE__);
        }
        $this->ItineraryID = $itineraryID;
        return $this;
    }
    /**
     * Get SegmentID value
     * @return string|null
     */
    public function getSegmentID()
    {
        return $this->SegmentID;
    }
    /**
     * Set SegmentID value
     * @param string $segmentID
     * @return \dgsoft\StructType\DgSeatRequestType
     */
    public function setSegmentID($segmentID = null)
    {
        // validation for constraint: string
        if (!is_null($segmentID) && !is_string($segmentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($segmentID)), __LINE__);
        }
        $this->SegmentID = $segmentID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgSeatRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
