<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatMapDetailsType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgSeatMapDetailsType extends AbstractStructBase
{
    /**
     * The CabinClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCabinClassType[]
     */
    public $CabinClass;
    /**
     * The TravelerRefNumberRPHs
     * @var string[]
     */
    public $TravelerRefNumberRPHs;
    /**
     * Constructor method for SeatMapDetailsType
     * @uses DgSeatMapDetailsType::setCabinClass()
     * @uses DgSeatMapDetailsType::setTravelerRefNumberRPHs()
     * @param \dgsoft\StructType\DgCabinClassType[] $cabinClass
     * @param string[] $travelerRefNumberRPHs
     */
    public function __construct(array $cabinClass = array(), array $travelerRefNumberRPHs = array())
    {
        $this
            ->setCabinClass($cabinClass)
            ->setTravelerRefNumberRPHs($travelerRefNumberRPHs);
    }
    /**
     * Get CabinClass value
     * @return \dgsoft\StructType\DgCabinClassType[]|null
     */
    public function getCabinClass()
    {
        return $this->CabinClass;
    }
    /**
     * Set CabinClass value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCabinClassType[] $cabinClass
     * @return \dgsoft\StructType\DgSeatMapDetailsType
     */
    public function setCabinClass(array $cabinClass = array())
    {
        foreach ($cabinClass as $seatMapDetailsTypeCabinClassItem) {
            // validation for constraint: itemType
            if (!$seatMapDetailsTypeCabinClassItem instanceof \dgsoft\StructType\DgCabinClassType) {
                throw new \InvalidArgumentException(sprintf('The CabinClass property can only contain items of \dgsoft\StructType\DgCabinClassType, "%s" given', is_object($seatMapDetailsTypeCabinClassItem) ? get_class($seatMapDetailsTypeCabinClassItem) : gettype($seatMapDetailsTypeCabinClassItem)), __LINE__);
            }
        }
        $this->CabinClass = $cabinClass;
        return $this;
    }
    /**
     * Add item to CabinClass value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCabinClassType $item
     * @return \dgsoft\StructType\DgSeatMapDetailsType
     */
    public function addToCabinClass(\dgsoft\StructType\DgCabinClassType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCabinClassType) {
            throw new \InvalidArgumentException(sprintf('The CabinClass property can only contain items of \dgsoft\StructType\DgCabinClassType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CabinClass[] = $item;
        return $this;
    }
    /**
     * Get TravelerRefNumberRPHs value
     * @return string[]|null
     */
    public function getTravelerRefNumberRPHs()
    {
        return $this->TravelerRefNumberRPHs;
    }
    /**
     * Set TravelerRefNumberRPHs value
     * @throws \InvalidArgumentException
     * @param string[] $travelerRefNumberRPHs
     * @return \dgsoft\StructType\DgSeatMapDetailsType
     */
    public function setTravelerRefNumberRPHs(array $travelerRefNumberRPHs = array())
    {
        foreach ($travelerRefNumberRPHs as $seatMapDetailsTypeTravelerRefNumberRPHsItem) {
            // validation for constraint: itemType
            if (!is_string($seatMapDetailsTypeTravelerRefNumberRPHsItem)) {
                throw new \InvalidArgumentException(sprintf('The TravelerRefNumberRPHs property can only contain items of string, "%s" given', is_object($seatMapDetailsTypeTravelerRefNumberRPHsItem) ? get_class($seatMapDetailsTypeTravelerRefNumberRPHsItem) : gettype($seatMapDetailsTypeTravelerRefNumberRPHsItem)), __LINE__);
            }
        }
        $this->TravelerRefNumberRPHs = $travelerRefNumberRPHs;
        return $this;
    }
    /**
     * Add item to TravelerRefNumberRPHs value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgSeatMapDetailsType
     */
    public function addToTravelerRefNumberRPHs($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The TravelerRefNumberRPHs property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TravelerRefNumberRPHs[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgSeatMapDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
