<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchTravelerType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgSearchTravelerType extends AbstractStructBase
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAddressInfoType
     */
    public $Address;
    /**
     * The CitizenCountryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSearchTravelerTypeCitizenCountryName
     */
    public $CitizenCountryName;
    /**
     * The IndCoverageReqs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgIndCoverageReqsType
     */
    public $IndCoverageReqs;
    /**
     * The PassengerType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPassengerTypeQuantityType
     */
    public $PassengerType;
    /**
     * The BirthDate
     * @var string
     */
    public $BirthDate;
    /**
     * The Age
     * @var int
     */
    public $Age;
    /**
     * The Relation
     * @var string
     */
    public $Relation;
    /**
     * The Gender
     * @var string
     */
    public $Gender;
    /**
     * Constructor method for SearchTravelerType
     * @uses DgSearchTravelerType::setAddress()
     * @uses DgSearchTravelerType::setCitizenCountryName()
     * @uses DgSearchTravelerType::setIndCoverageReqs()
     * @uses DgSearchTravelerType::setPassengerType()
     * @uses DgSearchTravelerType::setBirthDate()
     * @uses DgSearchTravelerType::setAge()
     * @uses DgSearchTravelerType::setRelation()
     * @uses DgSearchTravelerType::setGender()
     * @param \dgsoft\StructType\DgAddressInfoType $address
     * @param \dgsoft\StructType\DgSearchTravelerTypeCitizenCountryName $citizenCountryName
     * @param \dgsoft\StructType\DgIndCoverageReqsType $indCoverageReqs
     * @param \dgsoft\StructType\DgPassengerTypeQuantityType $passengerType
     * @param string $birthDate
     * @param int $age
     * @param string $relation
     * @param string $gender
     */
    public function __construct(\dgsoft\StructType\DgAddressInfoType $address = null, \dgsoft\StructType\DgSearchTravelerTypeCitizenCountryName $citizenCountryName = null, \dgsoft\StructType\DgIndCoverageReqsType $indCoverageReqs = null, \dgsoft\StructType\DgPassengerTypeQuantityType $passengerType = null, $birthDate = null, $age = null, $relation = null, $gender = null)
    {
        $this
            ->setAddress($address)
            ->setCitizenCountryName($citizenCountryName)
            ->setIndCoverageReqs($indCoverageReqs)
            ->setPassengerType($passengerType)
            ->setBirthDate($birthDate)
            ->setAge($age)
            ->setRelation($relation)
            ->setGender($gender);
    }
    /**
     * Get Address value
     * @return \dgsoft\StructType\DgAddressInfoType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \dgsoft\StructType\DgAddressInfoType $address
     * @return \dgsoft\StructType\DgSearchTravelerType
     */
    public function setAddress(\dgsoft\StructType\DgAddressInfoType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get CitizenCountryName value
     * @return \dgsoft\StructType\DgSearchTravelerTypeCitizenCountryName|null
     */
    public function getCitizenCountryName()
    {
        return $this->CitizenCountryName;
    }
    /**
     * Set CitizenCountryName value
     * @param \dgsoft\StructType\DgSearchTravelerTypeCitizenCountryName $citizenCountryName
     * @return \dgsoft\StructType\DgSearchTravelerType
     */
    public function setCitizenCountryName(\dgsoft\StructType\DgSearchTravelerTypeCitizenCountryName $citizenCountryName = null)
    {
        $this->CitizenCountryName = $citizenCountryName;
        return $this;
    }
    /**
     * Get IndCoverageReqs value
     * @return \dgsoft\StructType\DgIndCoverageReqsType|null
     */
    public function getIndCoverageReqs()
    {
        return $this->IndCoverageReqs;
    }
    /**
     * Set IndCoverageReqs value
     * @param \dgsoft\StructType\DgIndCoverageReqsType $indCoverageReqs
     * @return \dgsoft\StructType\DgSearchTravelerType
     */
    public function setIndCoverageReqs(\dgsoft\StructType\DgIndCoverageReqsType $indCoverageReqs = null)
    {
        $this->IndCoverageReqs = $indCoverageReqs;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return \dgsoft\StructType\DgPassengerTypeQuantityType|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @param \dgsoft\StructType\DgPassengerTypeQuantityType $passengerType
     * @return \dgsoft\StructType\DgSearchTravelerType
     */
    public function setPassengerType(\dgsoft\StructType\DgPassengerTypeQuantityType $passengerType = null)
    {
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \dgsoft\StructType\DgSearchTravelerType
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \dgsoft\StructType\DgSearchTravelerType
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !is_numeric($age)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($age)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
    /**
     * Get Relation value
     * @return string|null
     */
    public function getRelation()
    {
        return $this->Relation;
    }
    /**
     * Set Relation value
     * @param string $relation
     * @return \dgsoft\StructType\DgSearchTravelerType
     */
    public function setRelation($relation = null)
    {
        // validation for constraint: string
        if (!is_null($relation) && !is_string($relation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relation)), __LINE__);
        }
        $this->Relation = $relation;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \dgsoft\StructType\DgSearchTravelerType
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgSearchTravelerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
