<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuleInfo StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRuleInfo extends DgRuleInfoType
{
    /**
     * The TripType
     * @var string
     */
    public $TripType;
    /**
     * The MoneySaverInd
     * @var bool
     */
    public $MoneySaverInd;
    /**
     * Constructor method for RuleInfo
     * @uses DgRuleInfo::setTripType()
     * @uses DgRuleInfo::setMoneySaverInd()
     * @param string $tripType
     * @param bool $moneySaverInd
     */
    public function __construct($tripType = null, $moneySaverInd = null)
    {
        $this
            ->setTripType($tripType)
            ->setMoneySaverInd($moneySaverInd);
    }
    /**
     * Get TripType value
     * @return string|null
     */
    public function getTripType()
    {
        return $this->TripType;
    }
    /**
     * Set TripType value
     * @uses \dgsoft\EnumType\DgAirTripType::valueIsValid()
     * @uses \dgsoft\EnumType\DgAirTripType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tripType
     * @return \dgsoft\StructType\DgRuleInfo
     */
    public function setTripType($tripType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgAirTripType::valueIsValid($tripType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tripType, implode(', ', \dgsoft\EnumType\DgAirTripType::getValidValues())), __LINE__);
        }
        $this->TripType = $tripType;
        return $this;
    }
    /**
     * Get MoneySaverInd value
     * @return bool|null
     */
    public function getMoneySaverInd()
    {
        return $this->MoneySaverInd;
    }
    /**
     * Set MoneySaverInd value
     * @param bool $moneySaverInd
     * @return \dgsoft\StructType\DgRuleInfo
     */
    public function setMoneySaverInd($moneySaverInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($moneySaverInd) && !is_bool($moneySaverInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($moneySaverInd)), __LINE__);
        }
        $this->MoneySaverInd = $moneySaverInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRuleInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
