<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RowDetailsTypeAirSeat StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRowDetailsTypeAirSeat extends AbstractStructBase
{
    /**
     * The ServiceFees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAncillaryServiceFeesType
     */
    public $ServiceFees;
    /**
     * The SeatAvailability
     * @var string
     */
    public $SeatAvailability;
    /**
     * The SeatNumber
     * @var string
     */
    public $SeatNumber;
    /**
     * The SeatPrice
     * @var string
     */
    public $SeatPrice;
    /**
     * The SeatPriceCurrency
     * @var string
     */
    public $SeatPriceCurrency;
    /**
     * The SeatCharacteristics
     * @var string[]
     */
    public $SeatCharacteristics;
    /**
     * The AirBookDesigCode
     * @var string
     */
    public $AirBookDesigCode;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for RowDetailsTypeAirSeat
     * @uses DgRowDetailsTypeAirSeat::setServiceFees()
     * @uses DgRowDetailsTypeAirSeat::setSeatAvailability()
     * @uses DgRowDetailsTypeAirSeat::setSeatNumber()
     * @uses DgRowDetailsTypeAirSeat::setSeatPrice()
     * @uses DgRowDetailsTypeAirSeat::setSeatPriceCurrency()
     * @uses DgRowDetailsTypeAirSeat::setSeatCharacteristics()
     * @uses DgRowDetailsTypeAirSeat::setAirBookDesigCode()
     * @uses DgRowDetailsTypeAirSeat::setRPH()
     * @param \dgsoft\StructType\DgAncillaryServiceFeesType $serviceFees
     * @param string $seatAvailability
     * @param string $seatNumber
     * @param string $seatPrice
     * @param string $seatPriceCurrency
     * @param string[] $seatCharacteristics
     * @param string $airBookDesigCode
     * @param string $rPH
     */
    public function __construct(\dgsoft\StructType\DgAncillaryServiceFeesType $serviceFees = null, $seatAvailability = null, $seatNumber = null, $seatPrice = null, $seatPriceCurrency = null, array $seatCharacteristics = array(), $airBookDesigCode = null, $rPH = null)
    {
        $this
            ->setServiceFees($serviceFees)
            ->setSeatAvailability($seatAvailability)
            ->setSeatNumber($seatNumber)
            ->setSeatPrice($seatPrice)
            ->setSeatPriceCurrency($seatPriceCurrency)
            ->setSeatCharacteristics($seatCharacteristics)
            ->setAirBookDesigCode($airBookDesigCode)
            ->setRPH($rPH);
    }
    /**
     * Get ServiceFees value
     * @return \dgsoft\StructType\DgAncillaryServiceFeesType|null
     */
    public function getServiceFees()
    {
        return $this->ServiceFees;
    }
    /**
     * Set ServiceFees value
     * @param \dgsoft\StructType\DgAncillaryServiceFeesType $serviceFees
     * @return \dgsoft\StructType\DgRowDetailsTypeAirSeat
     */
    public function setServiceFees(\dgsoft\StructType\DgAncillaryServiceFeesType $serviceFees = null)
    {
        $this->ServiceFees = $serviceFees;
        return $this;
    }
    /**
     * Get SeatAvailability value
     * @return string|null
     */
    public function getSeatAvailability()
    {
        return $this->SeatAvailability;
    }
    /**
     * Set SeatAvailability value
     * @param string $seatAvailability
     * @return \dgsoft\StructType\DgRowDetailsTypeAirSeat
     */
    public function setSeatAvailability($seatAvailability = null)
    {
        // validation for constraint: string
        if (!is_null($seatAvailability) && !is_string($seatAvailability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seatAvailability)), __LINE__);
        }
        $this->SeatAvailability = $seatAvailability;
        return $this;
    }
    /**
     * Get SeatNumber value
     * @return string|null
     */
    public function getSeatNumber()
    {
        return $this->SeatNumber;
    }
    /**
     * Set SeatNumber value
     * @param string $seatNumber
     * @return \dgsoft\StructType\DgRowDetailsTypeAirSeat
     */
    public function setSeatNumber($seatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seatNumber) && !is_string($seatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seatNumber)), __LINE__);
        }
        $this->SeatNumber = $seatNumber;
        return $this;
    }
    /**
     * Get SeatPrice value
     * @return string|null
     */
    public function getSeatPrice()
    {
        return $this->SeatPrice;
    }
    /**
     * Set SeatPrice value
     * @param string $seatPrice
     * @return \dgsoft\StructType\DgRowDetailsTypeAirSeat
     */
    public function setSeatPrice($seatPrice = null)
    {
        // validation for constraint: string
        if (!is_null($seatPrice) && !is_string($seatPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seatPrice)), __LINE__);
        }
        $this->SeatPrice = $seatPrice;
        return $this;
    }
    /**
     * Get SeatPriceCurrency value
     * @return string|null
     */
    public function getSeatPriceCurrency()
    {
        return $this->SeatPriceCurrency;
    }
    /**
     * Set SeatPriceCurrency value
     * @param string $seatPriceCurrency
     * @return \dgsoft\StructType\DgRowDetailsTypeAirSeat
     */
    public function setSeatPriceCurrency($seatPriceCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($seatPriceCurrency) && !is_string($seatPriceCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seatPriceCurrency)), __LINE__);
        }
        $this->SeatPriceCurrency = $seatPriceCurrency;
        return $this;
    }
    /**
     * Get SeatCharacteristics value
     * @return string[]|null
     */
    public function getSeatCharacteristics()
    {
        return $this->SeatCharacteristics;
    }
    /**
     * Set SeatCharacteristics value
     * @throws \InvalidArgumentException
     * @param string[] $seatCharacteristics
     * @return \dgsoft\StructType\DgRowDetailsTypeAirSeat
     */
    public function setSeatCharacteristics(array $seatCharacteristics = array())
    {
        foreach ($seatCharacteristics as $rowDetailsTypeAirSeatSeatCharacteristicsItem) {
            // validation for constraint: itemType
            if (!is_string($rowDetailsTypeAirSeatSeatCharacteristicsItem)) {
                throw new \InvalidArgumentException(sprintf('The SeatCharacteristics property can only contain items of string, "%s" given', is_object($rowDetailsTypeAirSeatSeatCharacteristicsItem) ? get_class($rowDetailsTypeAirSeatSeatCharacteristicsItem) : gettype($rowDetailsTypeAirSeatSeatCharacteristicsItem)), __LINE__);
            }
        }
        $this->SeatCharacteristics = $seatCharacteristics;
        return $this;
    }
    /**
     * Add item to SeatCharacteristics value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgRowDetailsTypeAirSeat
     */
    public function addToSeatCharacteristics($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The SeatCharacteristics property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SeatCharacteristics[] = $item;
        return $this;
    }
    /**
     * Get AirBookDesigCode value
     * @return string|null
     */
    public function getAirBookDesigCode()
    {
        return $this->AirBookDesigCode;
    }
    /**
     * Set AirBookDesigCode value
     * @param string $airBookDesigCode
     * @return \dgsoft\StructType\DgRowDetailsTypeAirSeat
     */
    public function setAirBookDesigCode($airBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($airBookDesigCode) && !is_string($airBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airBookDesigCode)), __LINE__);
        }
        $this->AirBookDesigCode = $airBookDesigCode;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \dgsoft\StructType\DgRowDetailsTypeAirSeat
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRowDetailsTypeAirSeat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
