<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RowDetailsType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRowDetailsType extends AbstractStructBase
{
    /**
     * The AirSeats
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfRowDetailsTypeAirSeat
     */
    public $AirSeats;
    /**
     * The AirRowCharacteristics
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRowDetailsTypeAirRowCharacteristics
     */
    public $AirRowCharacteristics;
    /**
     * The MaxNumberOfSeats
     * @var int
     */
    public $MaxNumberOfSeats;
    /**
     * The RowNumber
     * @var int
     */
    public $RowNumber;
    /**
     * The AirBookDesigCode
     * @var string
     */
    public $AirBookDesigCode;
    /**
     * Constructor method for RowDetailsType
     * @uses DgRowDetailsType::setAirSeats()
     * @uses DgRowDetailsType::setAirRowCharacteristics()
     * @uses DgRowDetailsType::setMaxNumberOfSeats()
     * @uses DgRowDetailsType::setRowNumber()
     * @uses DgRowDetailsType::setAirBookDesigCode()
     * @param \dgsoft\ArrayType\DgArrayOfRowDetailsTypeAirSeat $airSeats
     * @param \dgsoft\StructType\DgRowDetailsTypeAirRowCharacteristics $airRowCharacteristics
     * @param int $maxNumberOfSeats
     * @param int $rowNumber
     * @param string $airBookDesigCode
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfRowDetailsTypeAirSeat $airSeats = null, \dgsoft\StructType\DgRowDetailsTypeAirRowCharacteristics $airRowCharacteristics = null, $maxNumberOfSeats = null, $rowNumber = null, $airBookDesigCode = null)
    {
        $this
            ->setAirSeats($airSeats)
            ->setAirRowCharacteristics($airRowCharacteristics)
            ->setMaxNumberOfSeats($maxNumberOfSeats)
            ->setRowNumber($rowNumber)
            ->setAirBookDesigCode($airBookDesigCode);
    }
    /**
     * Get AirSeats value
     * @return \dgsoft\ArrayType\DgArrayOfRowDetailsTypeAirSeat|null
     */
    public function getAirSeats()
    {
        return $this->AirSeats;
    }
    /**
     * Set AirSeats value
     * @param \dgsoft\ArrayType\DgArrayOfRowDetailsTypeAirSeat $airSeats
     * @return \dgsoft\StructType\DgRowDetailsType
     */
    public function setAirSeats(\dgsoft\ArrayType\DgArrayOfRowDetailsTypeAirSeat $airSeats = null)
    {
        $this->AirSeats = $airSeats;
        return $this;
    }
    /**
     * Get AirRowCharacteristics value
     * @return \dgsoft\StructType\DgRowDetailsTypeAirRowCharacteristics|null
     */
    public function getAirRowCharacteristics()
    {
        return $this->AirRowCharacteristics;
    }
    /**
     * Set AirRowCharacteristics value
     * @param \dgsoft\StructType\DgRowDetailsTypeAirRowCharacteristics $airRowCharacteristics
     * @return \dgsoft\StructType\DgRowDetailsType
     */
    public function setAirRowCharacteristics(\dgsoft\StructType\DgRowDetailsTypeAirRowCharacteristics $airRowCharacteristics = null)
    {
        $this->AirRowCharacteristics = $airRowCharacteristics;
        return $this;
    }
    /**
     * Get MaxNumberOfSeats value
     * @return int|null
     */
    public function getMaxNumberOfSeats()
    {
        return $this->MaxNumberOfSeats;
    }
    /**
     * Set MaxNumberOfSeats value
     * @param int $maxNumberOfSeats
     * @return \dgsoft\StructType\DgRowDetailsType
     */
    public function setMaxNumberOfSeats($maxNumberOfSeats = null)
    {
        // validation for constraint: int
        if (!is_null($maxNumberOfSeats) && !is_numeric($maxNumberOfSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxNumberOfSeats)), __LINE__);
        }
        $this->MaxNumberOfSeats = $maxNumberOfSeats;
        return $this;
    }
    /**
     * Get RowNumber value
     * @return int|null
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param int $rowNumber
     * @return \dgsoft\StructType\DgRowDetailsType
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumber) && !is_numeric($rowNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rowNumber)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Get AirBookDesigCode value
     * @return string|null
     */
    public function getAirBookDesigCode()
    {
        return $this->AirBookDesigCode;
    }
    /**
     * Set AirBookDesigCode value
     * @param string $airBookDesigCode
     * @return \dgsoft\StructType\DgRowDetailsType
     */
    public function setAirBookDesigCode($airBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($airBookDesigCode) && !is_string($airBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airBookDesigCode)), __LINE__);
        }
        $this->AirBookDesigCode = $airBookDesigCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRowDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
