<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomStays StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRoomStays extends AbstractStructBase
{
    /**
     * The RoomStay
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRoomStay[]
     */
    public $RoomStay;
    /**
     * The MoreIndicator
     * @var string
     */
    public $MoreIndicator;
    /**
     * Constructor method for RoomStays
     * @uses DgRoomStays::setRoomStay()
     * @uses DgRoomStays::setMoreIndicator()
     * @param \dgsoft\StructType\DgRoomStay[] $roomStay
     * @param string $moreIndicator
     */
    public function __construct(array $roomStay = array(), $moreIndicator = null)
    {
        $this
            ->setRoomStay($roomStay)
            ->setMoreIndicator($moreIndicator);
    }
    /**
     * Get RoomStay value
     * @return \dgsoft\StructType\DgRoomStay[]|null
     */
    public function getRoomStay()
    {
        return $this->RoomStay;
    }
    /**
     * Set RoomStay value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRoomStay[] $roomStay
     * @return \dgsoft\StructType\DgRoomStays
     */
    public function setRoomStay(array $roomStay = array())
    {
        foreach ($roomStay as $roomStaysRoomStayItem) {
            // validation for constraint: itemType
            if (!$roomStaysRoomStayItem instanceof \dgsoft\StructType\DgRoomStay) {
                throw new \InvalidArgumentException(sprintf('The RoomStay property can only contain items of \dgsoft\StructType\DgRoomStay, "%s" given', is_object($roomStaysRoomStayItem) ? get_class($roomStaysRoomStayItem) : gettype($roomStaysRoomStayItem)), __LINE__);
            }
        }
        $this->RoomStay = $roomStay;
        return $this;
    }
    /**
     * Add item to RoomStay value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRoomStay $item
     * @return \dgsoft\StructType\DgRoomStays
     */
    public function addToRoomStay(\dgsoft\StructType\DgRoomStay $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgRoomStay) {
            throw new \InvalidArgumentException(sprintf('The RoomStay property can only contain items of \dgsoft\StructType\DgRoomStay, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoomStay[] = $item;
        return $this;
    }
    /**
     * Get MoreIndicator value
     * @return string|null
     */
    public function getMoreIndicator()
    {
        return $this->MoreIndicator;
    }
    /**
     * Set MoreIndicator value
     * @param string $moreIndicator
     * @return \dgsoft\StructType\DgRoomStays
     */
    public function setMoreIndicator($moreIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($moreIndicator) && !is_string($moreIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moreIndicator)), __LINE__);
        }
        $this->MoreIndicator = $moreIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRoomStays
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
