<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomStay StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRoomStay extends DgRoomStayType
{
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgReference
     */
    public $Reference;
    /**
     * The ServiceRPHs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfServiceRPHsTypeServiceRPH
     */
    public $ServiceRPHs;
    /**
     * The RoomID
     * @var string
     */
    public $RoomID;
    /**
     * The IsAlternate
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $IsAlternate;
    /**
     * The AvailabilityStatus
     * @var string
     */
    public $AvailabilityStatus;
    /**
     * The ResponseType
     * Meta informations extracted from the WSDL
     * - default: PropertyList
     * @var string
     */
    public $ResponseType;
    /**
     * The RoomStayCandidateRPH
     * @var string
     */
    public $RoomStayCandidateRPH;
    /**
     * The MoreDataEchoToken
     * @var string
     */
    public $MoreDataEchoToken;
    /**
     * The InfoSource
     * @var string
     */
    public $InfoSource;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The AvailableIndicator
     * @var bool
     */
    public $AvailableIndicator;
    /**
     * Constructor method for RoomStay
     * @uses DgRoomStay::setReference()
     * @uses DgRoomStay::setServiceRPHs()
     * @uses DgRoomStay::setRoomID()
     * @uses DgRoomStay::setIsAlternate()
     * @uses DgRoomStay::setAvailabilityStatus()
     * @uses DgRoomStay::setResponseType()
     * @uses DgRoomStay::setRoomStayCandidateRPH()
     * @uses DgRoomStay::setMoreDataEchoToken()
     * @uses DgRoomStay::setInfoSource()
     * @uses DgRoomStay::setRPH()
     * @uses DgRoomStay::setAvailableIndicator()
     * @param \dgsoft\StructType\DgReference $reference
     * @param \dgsoft\ArrayType\DgArrayOfServiceRPHsTypeServiceRPH $serviceRPHs
     * @param string $roomID
     * @param bool $isAlternate
     * @param string $availabilityStatus
     * @param string $responseType
     * @param string $roomStayCandidateRPH
     * @param string $moreDataEchoToken
     * @param string $infoSource
     * @param string $rPH
     * @param bool $availableIndicator
     */
    public function __construct(\dgsoft\StructType\DgReference $reference = null, \dgsoft\ArrayType\DgArrayOfServiceRPHsTypeServiceRPH $serviceRPHs = null, $roomID = null, $isAlternate = false, $availabilityStatus = null, $responseType = 'PropertyList', $roomStayCandidateRPH = null, $moreDataEchoToken = null, $infoSource = null, $rPH = null, $availableIndicator = null)
    {
        $this
            ->setReference($reference)
            ->setServiceRPHs($serviceRPHs)
            ->setRoomID($roomID)
            ->setIsAlternate($isAlternate)
            ->setAvailabilityStatus($availabilityStatus)
            ->setResponseType($responseType)
            ->setRoomStayCandidateRPH($roomStayCandidateRPH)
            ->setMoreDataEchoToken($moreDataEchoToken)
            ->setInfoSource($infoSource)
            ->setRPH($rPH)
            ->setAvailableIndicator($availableIndicator);
    }
    /**
     * Get Reference value
     * @return \dgsoft\StructType\DgReference|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \dgsoft\StructType\DgReference $reference
     * @return \dgsoft\StructType\DgRoomStay
     */
    public function setReference(\dgsoft\StructType\DgReference $reference = null)
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get ServiceRPHs value
     * @return \dgsoft\ArrayType\DgArrayOfServiceRPHsTypeServiceRPH|null
     */
    public function getServiceRPHs()
    {
        return $this->ServiceRPHs;
    }
    /**
     * Set ServiceRPHs value
     * @param \dgsoft\ArrayType\DgArrayOfServiceRPHsTypeServiceRPH $serviceRPHs
     * @return \dgsoft\StructType\DgRoomStay
     */
    public function setServiceRPHs(\dgsoft\ArrayType\DgArrayOfServiceRPHsTypeServiceRPH $serviceRPHs = null)
    {
        $this->ServiceRPHs = $serviceRPHs;
        return $this;
    }
    /**
     * Get RoomID value
     * @return string|null
     */
    public function getRoomID()
    {
        return $this->RoomID;
    }
    /**
     * Set RoomID value
     * @param string $roomID
     * @return \dgsoft\StructType\DgRoomStay
     */
    public function setRoomID($roomID = null)
    {
        // validation for constraint: string
        if (!is_null($roomID) && !is_string($roomID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomID)), __LINE__);
        }
        $this->RoomID = $roomID;
        return $this;
    }
    /**
     * Get IsAlternate value
     * @return bool|null
     */
    public function getIsAlternate()
    {
        return $this->IsAlternate;
    }
    /**
     * Set IsAlternate value
     * @param bool $isAlternate
     * @return \dgsoft\StructType\DgRoomStay
     */
    public function setIsAlternate($isAlternate = false)
    {
        // validation for constraint: boolean
        if (!is_null($isAlternate) && !is_bool($isAlternate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAlternate)), __LINE__);
        }
        $this->IsAlternate = $isAlternate;
        return $this;
    }
    /**
     * Get AvailabilityStatus value
     * @return string|null
     */
    public function getAvailabilityStatus()
    {
        return $this->AvailabilityStatus;
    }
    /**
     * Set AvailabilityStatus value
     * @uses \dgsoft\EnumType\DgRateIndicatorType::valueIsValid()
     * @uses \dgsoft\EnumType\DgRateIndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availabilityStatus
     * @return \dgsoft\StructType\DgRoomStay
     */
    public function setAvailabilityStatus($availabilityStatus = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgRateIndicatorType::valueIsValid($availabilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $availabilityStatus, implode(', ', \dgsoft\EnumType\DgRateIndicatorType::getValidValues())), __LINE__);
        }
        $this->AvailabilityStatus = $availabilityStatus;
        return $this;
    }
    /**
     * Get ResponseType value
     * @return string|null
     */
    public function getResponseType()
    {
        return $this->ResponseType;
    }
    /**
     * Set ResponseType value
     * @param string $responseType
     * @return \dgsoft\StructType\DgRoomStay
     */
    public function setResponseType($responseType = 'PropertyList')
    {
        // validation for constraint: string
        if (!is_null($responseType) && !is_string($responseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseType)), __LINE__);
        }
        $this->ResponseType = $responseType;
        return $this;
    }
    /**
     * Get RoomStayCandidateRPH value
     * @return string|null
     */
    public function getRoomStayCandidateRPH()
    {
        return $this->RoomStayCandidateRPH;
    }
    /**
     * Set RoomStayCandidateRPH value
     * @param string $roomStayCandidateRPH
     * @return \dgsoft\StructType\DgRoomStay
     */
    public function setRoomStayCandidateRPH($roomStayCandidateRPH = null)
    {
        // validation for constraint: string
        if (!is_null($roomStayCandidateRPH) && !is_string($roomStayCandidateRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomStayCandidateRPH)), __LINE__);
        }
        $this->RoomStayCandidateRPH = $roomStayCandidateRPH;
        return $this;
    }
    /**
     * Get MoreDataEchoToken value
     * @return string|null
     */
    public function getMoreDataEchoToken()
    {
        return $this->MoreDataEchoToken;
    }
    /**
     * Set MoreDataEchoToken value
     * @param string $moreDataEchoToken
     * @return \dgsoft\StructType\DgRoomStay
     */
    public function setMoreDataEchoToken($moreDataEchoToken = null)
    {
        // validation for constraint: string
        if (!is_null($moreDataEchoToken) && !is_string($moreDataEchoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moreDataEchoToken)), __LINE__);
        }
        $this->MoreDataEchoToken = $moreDataEchoToken;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \dgsoft\StructType\DgRoomStay
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \dgsoft\StructType\DgRoomStay
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get AvailableIndicator value
     * @return bool|null
     */
    public function getAvailableIndicator()
    {
        return $this->AvailableIndicator;
    }
    /**
     * Set AvailableIndicator value
     * @param bool $availableIndicator
     * @return \dgsoft\StructType\DgRoomStay
     */
    public function setAvailableIndicator($availableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableIndicator) && !is_bool($availableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availableIndicator)), __LINE__);
        }
        $this->AvailableIndicator = $availableIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRoomStay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
