<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomRates StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRoomRates extends AbstractStructBase
{
    /**
     * The TotalAmountSpecified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TotalAmountSpecified;
    /**
     * The IsGuarantee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsGuarantee;
    /**
     * The IsDeposit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDeposit;
    /**
     * The RoomRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRoomRate[]
     */
    public $RoomRate;
    /**
     * The TotalAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $TotalAmount;
    /**
     * The Notes1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes1;
    /**
     * The Notes2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes2;
    /**
     * The Notes3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes3;
    /**
     * The MoreRatesExistInd
     * @var bool
     */
    public $MoreRatesExistInd;
    /**
     * Constructor method for RoomRates
     * @uses DgRoomRates::setTotalAmountSpecified()
     * @uses DgRoomRates::setIsGuarantee()
     * @uses DgRoomRates::setIsDeposit()
     * @uses DgRoomRates::setRoomRate()
     * @uses DgRoomRates::setTotalAmount()
     * @uses DgRoomRates::setNotes1()
     * @uses DgRoomRates::setNotes2()
     * @uses DgRoomRates::setNotes3()
     * @uses DgRoomRates::setMoreRatesExistInd()
     * @param bool $totalAmountSpecified
     * @param bool $isGuarantee
     * @param bool $isDeposit
     * @param \dgsoft\StructType\DgRoomRate[] $roomRate
     * @param float $totalAmount
     * @param string $notes1
     * @param string $notes2
     * @param string $notes3
     * @param bool $moreRatesExistInd
     */
    public function __construct($totalAmountSpecified = null, $isGuarantee = null, $isDeposit = null, array $roomRate = array(), $totalAmount = null, $notes1 = null, $notes2 = null, $notes3 = null, $moreRatesExistInd = null)
    {
        $this
            ->setTotalAmountSpecified($totalAmountSpecified)
            ->setIsGuarantee($isGuarantee)
            ->setIsDeposit($isDeposit)
            ->setRoomRate($roomRate)
            ->setTotalAmount($totalAmount)
            ->setNotes1($notes1)
            ->setNotes2($notes2)
            ->setNotes3($notes3)
            ->setMoreRatesExistInd($moreRatesExistInd);
    }
    /**
     * Get TotalAmountSpecified value
     * @return bool
     */
    public function getTotalAmountSpecified()
    {
        return $this->TotalAmountSpecified;
    }
    /**
     * Set TotalAmountSpecified value
     * @param bool $totalAmountSpecified
     * @return \dgsoft\StructType\DgRoomRates
     */
    public function setTotalAmountSpecified($totalAmountSpecified = null)
    {
        // validation for constraint: boolean
        if (!is_null($totalAmountSpecified) && !is_bool($totalAmountSpecified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($totalAmountSpecified)), __LINE__);
        }
        $this->TotalAmountSpecified = $totalAmountSpecified;
        return $this;
    }
    /**
     * Get IsGuarantee value
     * @return bool
     */
    public function getIsGuarantee()
    {
        return $this->IsGuarantee;
    }
    /**
     * Set IsGuarantee value
     * @param bool $isGuarantee
     * @return \dgsoft\StructType\DgRoomRates
     */
    public function setIsGuarantee($isGuarantee = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGuarantee) && !is_bool($isGuarantee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isGuarantee)), __LINE__);
        }
        $this->IsGuarantee = $isGuarantee;
        return $this;
    }
    /**
     * Get IsDeposit value
     * @return bool
     */
    public function getIsDeposit()
    {
        return $this->IsDeposit;
    }
    /**
     * Set IsDeposit value
     * @param bool $isDeposit
     * @return \dgsoft\StructType\DgRoomRates
     */
    public function setIsDeposit($isDeposit = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeposit) && !is_bool($isDeposit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDeposit)), __LINE__);
        }
        $this->IsDeposit = $isDeposit;
        return $this;
    }
    /**
     * Get RoomRate value
     * @return \dgsoft\StructType\DgRoomRate[]|null
     */
    public function getRoomRate()
    {
        return $this->RoomRate;
    }
    /**
     * Set RoomRate value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRoomRate[] $roomRate
     * @return \dgsoft\StructType\DgRoomRates
     */
    public function setRoomRate(array $roomRate = array())
    {
        foreach ($roomRate as $roomRatesRoomRateItem) {
            // validation for constraint: itemType
            if (!$roomRatesRoomRateItem instanceof \dgsoft\StructType\DgRoomRate) {
                throw new \InvalidArgumentException(sprintf('The RoomRate property can only contain items of \dgsoft\StructType\DgRoomRate, "%s" given', is_object($roomRatesRoomRateItem) ? get_class($roomRatesRoomRateItem) : gettype($roomRatesRoomRateItem)), __LINE__);
            }
        }
        $this->RoomRate = $roomRate;
        return $this;
    }
    /**
     * Add item to RoomRate value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRoomRate $item
     * @return \dgsoft\StructType\DgRoomRates
     */
    public function addToRoomRate(\dgsoft\StructType\DgRoomRate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgRoomRate) {
            throw new \InvalidArgumentException(sprintf('The RoomRate property can only contain items of \dgsoft\StructType\DgRoomRate, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoomRate[] = $item;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param float $totalAmount
     * @return \dgsoft\StructType\DgRoomRates
     */
    public function setTotalAmount($totalAmount = null)
    {
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get Notes1 value
     * @return string|null
     */
    public function getNotes1()
    {
        return $this->Notes1;
    }
    /**
     * Set Notes1 value
     * @param string $notes1
     * @return \dgsoft\StructType\DgRoomRates
     */
    public function setNotes1($notes1 = null)
    {
        // validation for constraint: string
        if (!is_null($notes1) && !is_string($notes1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes1)), __LINE__);
        }
        $this->Notes1 = $notes1;
        return $this;
    }
    /**
     * Get Notes2 value
     * @return string|null
     */
    public function getNotes2()
    {
        return $this->Notes2;
    }
    /**
     * Set Notes2 value
     * @param string $notes2
     * @return \dgsoft\StructType\DgRoomRates
     */
    public function setNotes2($notes2 = null)
    {
        // validation for constraint: string
        if (!is_null($notes2) && !is_string($notes2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes2)), __LINE__);
        }
        $this->Notes2 = $notes2;
        return $this;
    }
    /**
     * Get Notes3 value
     * @return string|null
     */
    public function getNotes3()
    {
        return $this->Notes3;
    }
    /**
     * Set Notes3 value
     * @param string $notes3
     * @return \dgsoft\StructType\DgRoomRates
     */
    public function setNotes3($notes3 = null)
    {
        // validation for constraint: string
        if (!is_null($notes3) && !is_string($notes3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes3)), __LINE__);
        }
        $this->Notes3 = $notes3;
        return $this;
    }
    /**
     * Get MoreRatesExistInd value
     * @return bool|null
     */
    public function getMoreRatesExistInd()
    {
        return $this->MoreRatesExistInd;
    }
    /**
     * Set MoreRatesExistInd value
     * @param bool $moreRatesExistInd
     * @return \dgsoft\StructType\DgRoomRates
     */
    public function setMoreRatesExistInd($moreRatesExistInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($moreRatesExistInd) && !is_bool($moreRatesExistInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($moreRatesExistInd)), __LINE__);
        }
        $this->MoreRatesExistInd = $moreRatesExistInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRoomRates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
