<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomRateType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRoomRateType extends AbstractStructBase
{
    /**
     * The Rates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfRateTypeRate
     */
    public $Rates;
    /**
     * The RoomRateDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgParagraphType[]
     */
    public $RoomRateDescription;
    /**
     * The Features
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfRoomRateTypeFeature
     */
    public $Features;
    /**
     * The Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTotalType
     */
    public $Total;
    /**
     * The Availability
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAvailability[]
     */
    public $Availability;
    /**
     * The BookingCode
     * @var string
     */
    public $BookingCode;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The RoomTypeCode
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The InvBlockCode
     * @var string
     */
    public $InvBlockCode;
    /**
     * The NumberOfUnits
     * @var int
     */
    public $NumberOfUnits;
    /**
     * The RatePlanType
     * @var string
     */
    public $RatePlanType;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The RatePlanID
     * @var string
     */
    public $RatePlanID;
    /**
     * The RatePlanQualifier
     * @var bool
     */
    public $RatePlanQualifier;
    /**
     * The RatePlanCategory
     * @var string
     */
    public $RatePlanCategory;
    /**
     * The AvailabilityStatus
     * @var string
     */
    public $AvailabilityStatus;
    /**
     * Constructor method for RoomRateType
     * @uses DgRoomRateType::setRates()
     * @uses DgRoomRateType::setRoomRateDescription()
     * @uses DgRoomRateType::setFeatures()
     * @uses DgRoomRateType::setTotal()
     * @uses DgRoomRateType::setAvailability()
     * @uses DgRoomRateType::setBookingCode()
     * @uses DgRoomRateType::setEffectiveDate()
     * @uses DgRoomRateType::setExpireDate()
     * @uses DgRoomRateType::setRoomTypeCode()
     * @uses DgRoomRateType::setInvBlockCode()
     * @uses DgRoomRateType::setNumberOfUnits()
     * @uses DgRoomRateType::setRatePlanType()
     * @uses DgRoomRateType::setRatePlanCode()
     * @uses DgRoomRateType::setRatePlanID()
     * @uses DgRoomRateType::setRatePlanQualifier()
     * @uses DgRoomRateType::setRatePlanCategory()
     * @uses DgRoomRateType::setAvailabilityStatus()
     * @param \dgsoft\ArrayType\DgArrayOfRateTypeRate $rates
     * @param \dgsoft\StructType\DgParagraphType[] $roomRateDescription
     * @param \dgsoft\ArrayType\DgArrayOfRoomRateTypeFeature $features
     * @param \dgsoft\StructType\DgTotalType $total
     * @param \dgsoft\StructType\DgAvailability[] $availability
     * @param string $bookingCode
     * @param string $effectiveDate
     * @param string $expireDate
     * @param string $roomTypeCode
     * @param string $invBlockCode
     * @param int $numberOfUnits
     * @param string $ratePlanType
     * @param string $ratePlanCode
     * @param string $ratePlanID
     * @param bool $ratePlanQualifier
     * @param string $ratePlanCategory
     * @param string $availabilityStatus
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfRateTypeRate $rates = null, array $roomRateDescription = array(), \dgsoft\ArrayType\DgArrayOfRoomRateTypeFeature $features = null, \dgsoft\StructType\DgTotalType $total = null, array $availability = array(), $bookingCode = null, $effectiveDate = null, $expireDate = null, $roomTypeCode = null, $invBlockCode = null, $numberOfUnits = null, $ratePlanType = null, $ratePlanCode = null, $ratePlanID = null, $ratePlanQualifier = null, $ratePlanCategory = null, $availabilityStatus = null)
    {
        $this
            ->setRates($rates)
            ->setRoomRateDescription($roomRateDescription)
            ->setFeatures($features)
            ->setTotal($total)
            ->setAvailability($availability)
            ->setBookingCode($bookingCode)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setRoomTypeCode($roomTypeCode)
            ->setInvBlockCode($invBlockCode)
            ->setNumberOfUnits($numberOfUnits)
            ->setRatePlanType($ratePlanType)
            ->setRatePlanCode($ratePlanCode)
            ->setRatePlanID($ratePlanID)
            ->setRatePlanQualifier($ratePlanQualifier)
            ->setRatePlanCategory($ratePlanCategory)
            ->setAvailabilityStatus($availabilityStatus);
    }
    /**
     * Get Rates value
     * @return \dgsoft\ArrayType\DgArrayOfRateTypeRate|null
     */
    public function getRates()
    {
        return $this->Rates;
    }
    /**
     * Set Rates value
     * @param \dgsoft\ArrayType\DgArrayOfRateTypeRate $rates
     * @return \dgsoft\StructType\DgRoomRateType
     */
    public function setRates(\dgsoft\ArrayType\DgArrayOfRateTypeRate $rates = null)
    {
        $this->Rates = $rates;
        return $this;
    }
    /**
     * Get RoomRateDescription value
     * @return \dgsoft\StructType\DgParagraphType[]|null
     */
    public function getRoomRateDescription()
    {
        return $this->RoomRateDescription;
    }
    /**
     * Set RoomRateDescription value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgParagraphType[] $roomRateDescription
     * @return \dgsoft\StructType\DgRoomRateType
     */
    public function setRoomRateDescription(array $roomRateDescription = array())
    {
        foreach ($roomRateDescription as $roomRateTypeRoomRateDescriptionItem) {
            // validation for constraint: itemType
            if (!$roomRateTypeRoomRateDescriptionItem instanceof \dgsoft\StructType\DgParagraphType) {
                throw new \InvalidArgumentException(sprintf('The RoomRateDescription property can only contain items of \dgsoft\StructType\DgParagraphType, "%s" given', is_object($roomRateTypeRoomRateDescriptionItem) ? get_class($roomRateTypeRoomRateDescriptionItem) : gettype($roomRateTypeRoomRateDescriptionItem)), __LINE__);
            }
        }
        $this->RoomRateDescription = $roomRateDescription;
        return $this;
    }
    /**
     * Add item to RoomRateDescription value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgParagraphType $item
     * @return \dgsoft\StructType\DgRoomRateType
     */
    public function addToRoomRateDescription(\dgsoft\StructType\DgParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgParagraphType) {
            throw new \InvalidArgumentException(sprintf('The RoomRateDescription property can only contain items of \dgsoft\StructType\DgParagraphType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoomRateDescription[] = $item;
        return $this;
    }
    /**
     * Get Features value
     * @return \dgsoft\ArrayType\DgArrayOfRoomRateTypeFeature|null
     */
    public function getFeatures()
    {
        return $this->Features;
    }
    /**
     * Set Features value
     * @param \dgsoft\ArrayType\DgArrayOfRoomRateTypeFeature $features
     * @return \dgsoft\StructType\DgRoomRateType
     */
    public function setFeatures(\dgsoft\ArrayType\DgArrayOfRoomRateTypeFeature $features = null)
    {
        $this->Features = $features;
        return $this;
    }
    /**
     * Get Total value
     * @return \dgsoft\StructType\DgTotalType|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \dgsoft\StructType\DgTotalType $total
     * @return \dgsoft\StructType\DgRoomRateType
     */
    public function setTotal(\dgsoft\StructType\DgTotalType $total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get Availability value
     * @return \dgsoft\StructType\DgAvailability[]|null
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * Set Availability value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAvailability[] $availability
     * @return \dgsoft\StructType\DgRoomRateType
     */
    public function setAvailability(array $availability = array())
    {
        foreach ($availability as $roomRateTypeAvailabilityItem) {
            // validation for constraint: itemType
            if (!$roomRateTypeAvailabilityItem instanceof \dgsoft\StructType\DgAvailability) {
                throw new \InvalidArgumentException(sprintf('The Availability property can only contain items of \dgsoft\StructType\DgAvailability, "%s" given', is_object($roomRateTypeAvailabilityItem) ? get_class($roomRateTypeAvailabilityItem) : gettype($roomRateTypeAvailabilityItem)), __LINE__);
            }
        }
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Add item to Availability value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAvailability $item
     * @return \dgsoft\StructType\DgRoomRateType
     */
    public function addToAvailability(\dgsoft\StructType\DgAvailability $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAvailability) {
            throw new \InvalidArgumentException(sprintf('The Availability property can only contain items of \dgsoft\StructType\DgAvailability, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Availability[] = $item;
        return $this;
    }
    /**
     * Get BookingCode value
     * @return string|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param string $bookingCode
     * @return \dgsoft\StructType\DgRoomRateType
     */
    public function setBookingCode($bookingCode = null)
    {
        // validation for constraint: string
        if (!is_null($bookingCode) && !is_string($bookingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingCode)), __LINE__);
        }
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \dgsoft\StructType\DgRoomRateType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \dgsoft\StructType\DgRoomRateType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \dgsoft\StructType\DgRoomRateType
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get InvBlockCode value
     * @return string|null
     */
    public function getInvBlockCode()
    {
        return $this->InvBlockCode;
    }
    /**
     * Set InvBlockCode value
     * @param string $invBlockCode
     * @return \dgsoft\StructType\DgRoomRateType
     */
    public function setInvBlockCode($invBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockCode) && !is_string($invBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invBlockCode)), __LINE__);
        }
        $this->InvBlockCode = $invBlockCode;
        return $this;
    }
    /**
     * Get NumberOfUnits value
     * @return int|null
     */
    public function getNumberOfUnits()
    {
        return $this->NumberOfUnits;
    }
    /**
     * Set NumberOfUnits value
     * @param int $numberOfUnits
     * @return \dgsoft\StructType\DgRoomRateType
     */
    public function setNumberOfUnits($numberOfUnits = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfUnits) && !is_numeric($numberOfUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfUnits)), __LINE__);
        }
        $this->NumberOfUnits = $numberOfUnits;
        return $this;
    }
    /**
     * Get RatePlanType value
     * @return string|null
     */
    public function getRatePlanType()
    {
        return $this->RatePlanType;
    }
    /**
     * Set RatePlanType value
     * @param string $ratePlanType
     * @return \dgsoft\StructType\DgRoomRateType
     */
    public function setRatePlanType($ratePlanType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanType) && !is_string($ratePlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanType)), __LINE__);
        }
        $this->RatePlanType = $ratePlanType;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \dgsoft\StructType\DgRoomRateType
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get RatePlanID value
     * @return string|null
     */
    public function getRatePlanID()
    {
        return $this->RatePlanID;
    }
    /**
     * Set RatePlanID value
     * @param string $ratePlanID
     * @return \dgsoft\StructType\DgRoomRateType
     */
    public function setRatePlanID($ratePlanID = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanID) && !is_string($ratePlanID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanID)), __LINE__);
        }
        $this->RatePlanID = $ratePlanID;
        return $this;
    }
    /**
     * Get RatePlanQualifier value
     * @return bool|null
     */
    public function getRatePlanQualifier()
    {
        return $this->RatePlanQualifier;
    }
    /**
     * Set RatePlanQualifier value
     * @param bool $ratePlanQualifier
     * @return \dgsoft\StructType\DgRoomRateType
     */
    public function setRatePlanQualifier($ratePlanQualifier = null)
    {
        // validation for constraint: boolean
        if (!is_null($ratePlanQualifier) && !is_bool($ratePlanQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($ratePlanQualifier)), __LINE__);
        }
        $this->RatePlanQualifier = $ratePlanQualifier;
        return $this;
    }
    /**
     * Get RatePlanCategory value
     * @return string|null
     */
    public function getRatePlanCategory()
    {
        return $this->RatePlanCategory;
    }
    /**
     * Set RatePlanCategory value
     * @param string $ratePlanCategory
     * @return \dgsoft\StructType\DgRoomRateType
     */
    public function setRatePlanCategory($ratePlanCategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCategory) && !is_string($ratePlanCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCategory)), __LINE__);
        }
        $this->RatePlanCategory = $ratePlanCategory;
        return $this;
    }
    /**
     * Get AvailabilityStatus value
     * @return string|null
     */
    public function getAvailabilityStatus()
    {
        return $this->AvailabilityStatus;
    }
    /**
     * Set AvailabilityStatus value
     * @uses \dgsoft\EnumType\DgRateIndicatorType::valueIsValid()
     * @uses \dgsoft\EnumType\DgRateIndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availabilityStatus
     * @return \dgsoft\StructType\DgRoomRateType
     */
    public function setAvailabilityStatus($availabilityStatus = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgRateIndicatorType::valueIsValid($availabilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $availabilityStatus, implode(', ', \dgsoft\EnumType\DgRateIndicatorType::getValidValues())), __LINE__);
        }
        $this->AvailabilityStatus = $availabilityStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRoomRateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
