<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResGuest StructType
 * @package Dg
 * @subpackage Structs
 */
class DgResGuest extends AbstractStructBase
{
    /**
     * The Profiles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfProfilesTypeProfileInfo
     */
    public $Profiles;
    /**
     * The SpecialRequests
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSpecialRequestTypeSpecialRequest
     */
    public $SpecialRequests;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfCommentTypeComment
     */
    public $Comments;
    /**
     * The ServiceRPHs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfServiceRPHsTypeServiceRPH
     */
    public $ServiceRPHs;
    /**
     * The ProfileRPHs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfResGuestsTypeResGuestProfileRPH
     */
    public $ProfileRPHs;
    /**
     * The ArrivalTransport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTransportInfoType
     */
    public $ArrivalTransport;
    /**
     * The DepartureTransport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTransportInfoType
     */
    public $DepartureTransport;
    /**
     * The GuestCounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgGuestCountType
     */
    public $GuestCounts;
    /**
     * The InHouseTimeSpan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDateTimeSpanType
     */
    public $InHouseTimeSpan;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The ResGuestRPH
     * @var string
     */
    public $ResGuestRPH;
    /**
     * The AgeQualifyingCode
     * @var string
     */
    public $AgeQualifyingCode;
    /**
     * The ArrivalTime
     * @var string
     */
    public $ArrivalTime;
    /**
     * The DepartureTime
     * @var string
     */
    public $DepartureTime;
    /**
     * The GroupEventCode
     * @var string
     */
    public $GroupEventCode;
    /**
     * The VIP
     * @var bool
     */
    public $VIP;
    /**
     * The PrimaryIndicator
     * @var bool
     */
    public $PrimaryIndicator;
    /**
     * Constructor method for ResGuest
     * @uses DgResGuest::setProfiles()
     * @uses DgResGuest::setSpecialRequests()
     * @uses DgResGuest::setComments()
     * @uses DgResGuest::setServiceRPHs()
     * @uses DgResGuest::setProfileRPHs()
     * @uses DgResGuest::setArrivalTransport()
     * @uses DgResGuest::setDepartureTransport()
     * @uses DgResGuest::setGuestCounts()
     * @uses DgResGuest::setInHouseTimeSpan()
     * @uses DgResGuest::setTPA_Extensions()
     * @uses DgResGuest::setResGuestRPH()
     * @uses DgResGuest::setAgeQualifyingCode()
     * @uses DgResGuest::setArrivalTime()
     * @uses DgResGuest::setDepartureTime()
     * @uses DgResGuest::setGroupEventCode()
     * @uses DgResGuest::setVIP()
     * @uses DgResGuest::setPrimaryIndicator()
     * @param \dgsoft\ArrayType\DgArrayOfProfilesTypeProfileInfo $profiles
     * @param \dgsoft\ArrayType\DgArrayOfSpecialRequestTypeSpecialRequest $specialRequests
     * @param \dgsoft\ArrayType\DgArrayOfCommentTypeComment $comments
     * @param \dgsoft\ArrayType\DgArrayOfServiceRPHsTypeServiceRPH $serviceRPHs
     * @param \dgsoft\ArrayType\DgArrayOfResGuestsTypeResGuestProfileRPH $profileRPHs
     * @param \dgsoft\StructType\DgTransportInfoType $arrivalTransport
     * @param \dgsoft\StructType\DgTransportInfoType $departureTransport
     * @param \dgsoft\StructType\DgGuestCountType $guestCounts
     * @param \dgsoft\StructType\DgDateTimeSpanType $inHouseTimeSpan
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param string $resGuestRPH
     * @param string $ageQualifyingCode
     * @param string $arrivalTime
     * @param string $departureTime
     * @param string $groupEventCode
     * @param bool $vIP
     * @param bool $primaryIndicator
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfProfilesTypeProfileInfo $profiles = null, \dgsoft\ArrayType\DgArrayOfSpecialRequestTypeSpecialRequest $specialRequests = null, \dgsoft\ArrayType\DgArrayOfCommentTypeComment $comments = null, \dgsoft\ArrayType\DgArrayOfServiceRPHsTypeServiceRPH $serviceRPHs = null, \dgsoft\ArrayType\DgArrayOfResGuestsTypeResGuestProfileRPH $profileRPHs = null, \dgsoft\StructType\DgTransportInfoType $arrivalTransport = null, \dgsoft\StructType\DgTransportInfoType $departureTransport = null, \dgsoft\StructType\DgGuestCountType $guestCounts = null, \dgsoft\StructType\DgDateTimeSpanType $inHouseTimeSpan = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $resGuestRPH = null, $ageQualifyingCode = null, $arrivalTime = null, $departureTime = null, $groupEventCode = null, $vIP = null, $primaryIndicator = null)
    {
        $this
            ->setProfiles($profiles)
            ->setSpecialRequests($specialRequests)
            ->setComments($comments)
            ->setServiceRPHs($serviceRPHs)
            ->setProfileRPHs($profileRPHs)
            ->setArrivalTransport($arrivalTransport)
            ->setDepartureTransport($departureTransport)
            ->setGuestCounts($guestCounts)
            ->setInHouseTimeSpan($inHouseTimeSpan)
            ->setTPA_Extensions($tPA_Extensions)
            ->setResGuestRPH($resGuestRPH)
            ->setAgeQualifyingCode($ageQualifyingCode)
            ->setArrivalTime($arrivalTime)
            ->setDepartureTime($departureTime)
            ->setGroupEventCode($groupEventCode)
            ->setVIP($vIP)
            ->setPrimaryIndicator($primaryIndicator);
    }
    /**
     * Get Profiles value
     * @return \dgsoft\ArrayType\DgArrayOfProfilesTypeProfileInfo|null
     */
    public function getProfiles()
    {
        return $this->Profiles;
    }
    /**
     * Set Profiles value
     * @param \dgsoft\ArrayType\DgArrayOfProfilesTypeProfileInfo $profiles
     * @return \dgsoft\StructType\DgResGuest
     */
    public function setProfiles(\dgsoft\ArrayType\DgArrayOfProfilesTypeProfileInfo $profiles = null)
    {
        $this->Profiles = $profiles;
        return $this;
    }
    /**
     * Get SpecialRequests value
     * @return \dgsoft\ArrayType\DgArrayOfSpecialRequestTypeSpecialRequest|null
     */
    public function getSpecialRequests()
    {
        return $this->SpecialRequests;
    }
    /**
     * Set SpecialRequests value
     * @param \dgsoft\ArrayType\DgArrayOfSpecialRequestTypeSpecialRequest $specialRequests
     * @return \dgsoft\StructType\DgResGuest
     */
    public function setSpecialRequests(\dgsoft\ArrayType\DgArrayOfSpecialRequestTypeSpecialRequest $specialRequests = null)
    {
        $this->SpecialRequests = $specialRequests;
        return $this;
    }
    /**
     * Get Comments value
     * @return \dgsoft\ArrayType\DgArrayOfCommentTypeComment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \dgsoft\ArrayType\DgArrayOfCommentTypeComment $comments
     * @return \dgsoft\StructType\DgResGuest
     */
    public function setComments(\dgsoft\ArrayType\DgArrayOfCommentTypeComment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get ServiceRPHs value
     * @return \dgsoft\ArrayType\DgArrayOfServiceRPHsTypeServiceRPH|null
     */
    public function getServiceRPHs()
    {
        return $this->ServiceRPHs;
    }
    /**
     * Set ServiceRPHs value
     * @param \dgsoft\ArrayType\DgArrayOfServiceRPHsTypeServiceRPH $serviceRPHs
     * @return \dgsoft\StructType\DgResGuest
     */
    public function setServiceRPHs(\dgsoft\ArrayType\DgArrayOfServiceRPHsTypeServiceRPH $serviceRPHs = null)
    {
        $this->ServiceRPHs = $serviceRPHs;
        return $this;
    }
    /**
     * Get ProfileRPHs value
     * @return \dgsoft\ArrayType\DgArrayOfResGuestsTypeResGuestProfileRPH|null
     */
    public function getProfileRPHs()
    {
        return $this->ProfileRPHs;
    }
    /**
     * Set ProfileRPHs value
     * @param \dgsoft\ArrayType\DgArrayOfResGuestsTypeResGuestProfileRPH $profileRPHs
     * @return \dgsoft\StructType\DgResGuest
     */
    public function setProfileRPHs(\dgsoft\ArrayType\DgArrayOfResGuestsTypeResGuestProfileRPH $profileRPHs = null)
    {
        $this->ProfileRPHs = $profileRPHs;
        return $this;
    }
    /**
     * Get ArrivalTransport value
     * @return \dgsoft\StructType\DgTransportInfoType|null
     */
    public function getArrivalTransport()
    {
        return $this->ArrivalTransport;
    }
    /**
     * Set ArrivalTransport value
     * @param \dgsoft\StructType\DgTransportInfoType $arrivalTransport
     * @return \dgsoft\StructType\DgResGuest
     */
    public function setArrivalTransport(\dgsoft\StructType\DgTransportInfoType $arrivalTransport = null)
    {
        $this->ArrivalTransport = $arrivalTransport;
        return $this;
    }
    /**
     * Get DepartureTransport value
     * @return \dgsoft\StructType\DgTransportInfoType|null
     */
    public function getDepartureTransport()
    {
        return $this->DepartureTransport;
    }
    /**
     * Set DepartureTransport value
     * @param \dgsoft\StructType\DgTransportInfoType $departureTransport
     * @return \dgsoft\StructType\DgResGuest
     */
    public function setDepartureTransport(\dgsoft\StructType\DgTransportInfoType $departureTransport = null)
    {
        $this->DepartureTransport = $departureTransport;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \dgsoft\StructType\DgGuestCountType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \dgsoft\StructType\DgGuestCountType $guestCounts
     * @return \dgsoft\StructType\DgResGuest
     */
    public function setGuestCounts(\dgsoft\StructType\DgGuestCountType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get InHouseTimeSpan value
     * @return \dgsoft\StructType\DgDateTimeSpanType|null
     */
    public function getInHouseTimeSpan()
    {
        return $this->InHouseTimeSpan;
    }
    /**
     * Set InHouseTimeSpan value
     * @param \dgsoft\StructType\DgDateTimeSpanType $inHouseTimeSpan
     * @return \dgsoft\StructType\DgResGuest
     */
    public function setInHouseTimeSpan(\dgsoft\StructType\DgDateTimeSpanType $inHouseTimeSpan = null)
    {
        $this->InHouseTimeSpan = $inHouseTimeSpan;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgResGuest
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ResGuestRPH value
     * @return string|null
     */
    public function getResGuestRPH()
    {
        return $this->ResGuestRPH;
    }
    /**
     * Set ResGuestRPH value
     * @param string $resGuestRPH
     * @return \dgsoft\StructType\DgResGuest
     */
    public function setResGuestRPH($resGuestRPH = null)
    {
        // validation for constraint: string
        if (!is_null($resGuestRPH) && !is_string($resGuestRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resGuestRPH)), __LINE__);
        }
        $this->ResGuestRPH = $resGuestRPH;
        return $this;
    }
    /**
     * Get AgeQualifyingCode value
     * @return string|null
     */
    public function getAgeQualifyingCode()
    {
        return $this->AgeQualifyingCode;
    }
    /**
     * Set AgeQualifyingCode value
     * @param string $ageQualifyingCode
     * @return \dgsoft\StructType\DgResGuest
     */
    public function setAgeQualifyingCode($ageQualifyingCode = null)
    {
        // validation for constraint: string
        if (!is_null($ageQualifyingCode) && !is_string($ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ageQualifyingCode)), __LINE__);
        }
        $this->AgeQualifyingCode = $ageQualifyingCode;
        return $this;
    }
    /**
     * Get ArrivalTime value
     * @return string|null
     */
    public function getArrivalTime()
    {
        return $this->ArrivalTime;
    }
    /**
     * Set ArrivalTime value
     * @param string $arrivalTime
     * @return \dgsoft\StructType\DgResGuest
     */
    public function setArrivalTime($arrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalTime) && !is_string($arrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalTime)), __LINE__);
        }
        $this->ArrivalTime = $arrivalTime;
        return $this;
    }
    /**
     * Get DepartureTime value
     * @return string|null
     */
    public function getDepartureTime()
    {
        return $this->DepartureTime;
    }
    /**
     * Set DepartureTime value
     * @param string $departureTime
     * @return \dgsoft\StructType\DgResGuest
     */
    public function setDepartureTime($departureTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureTime) && !is_string($departureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureTime)), __LINE__);
        }
        $this->DepartureTime = $departureTime;
        return $this;
    }
    /**
     * Get GroupEventCode value
     * @return string|null
     */
    public function getGroupEventCode()
    {
        return $this->GroupEventCode;
    }
    /**
     * Set GroupEventCode value
     * @param string $groupEventCode
     * @return \dgsoft\StructType\DgResGuest
     */
    public function setGroupEventCode($groupEventCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupEventCode) && !is_string($groupEventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupEventCode)), __LINE__);
        }
        $this->GroupEventCode = $groupEventCode;
        return $this;
    }
    /**
     * Get VIP value
     * @return bool|null
     */
    public function getVIP()
    {
        return $this->VIP;
    }
    /**
     * Set VIP value
     * @param bool $vIP
     * @return \dgsoft\StructType\DgResGuest
     */
    public function setVIP($vIP = null)
    {
        // validation for constraint: boolean
        if (!is_null($vIP) && !is_bool($vIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($vIP)), __LINE__);
        }
        $this->VIP = $vIP;
        return $this;
    }
    /**
     * Get PrimaryIndicator value
     * @return bool|null
     */
    public function getPrimaryIndicator()
    {
        return $this->PrimaryIndicator;
    }
    /**
     * Set PrimaryIndicator value
     * @param bool $primaryIndicator
     * @return \dgsoft\StructType\DgResGuest
     */
    public function setPrimaryIndicator($primaryIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($primaryIndicator) && !is_bool($primaryIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($primaryIndicator)), __LINE__);
        }
        $this->PrimaryIndicator = $primaryIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgResGuest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
