<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequiredParametersData StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRequiredParametersData extends AbstractStructBase
{
    /**
     * The RequiredParametersOnProcessDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfLCCRequiredParameter
     */
    public $RequiredParametersOnProcessDetails;
    /**
     * The LCCSupportedCardList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfLCCSupportedCard
     */
    public $LCCSupportedCardList;
    /**
     * The LCCBaggageFeeList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfLCCBaggageFee
     */
    public $LCCBaggageFeeList;
    /**
     * The OutwardLuggageOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfLCCBaggageFee
     */
    public $OutwardLuggageOptions;
    /**
     * The ReturnLuggageOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfLCCBaggageFee
     */
    public $ReturnLuggageOptions;
    /**
     * The LCCHandLuggageFeeList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfLCCBaggageFee
     */
    public $LCCHandLuggageFeeList;
    /**
     * The LCCOtherFeeList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfLCCOtherFee
     */
    public $LCCOtherFeeList;
    /**
     * The LCCCheckInOptionList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfLCCCheckInOption
     */
    public $LCCCheckInOptionList;
    /**
     * The LCCRuleLink
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LCCRuleLink;
    /**
     * The BaggageAllowanceNote
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BaggageAllowanceNote;
    /**
     * The SupplierName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SupplierName;
    /**
     * The SupplierCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SupplierCode;
    /**
     * The ItineraryIndex
     * @var int
     */
    public $ItineraryIndex;
    /**
     * Constructor method for RequiredParametersData
     * @uses DgRequiredParametersData::setRequiredParametersOnProcessDetails()
     * @uses DgRequiredParametersData::setLCCSupportedCardList()
     * @uses DgRequiredParametersData::setLCCBaggageFeeList()
     * @uses DgRequiredParametersData::setOutwardLuggageOptions()
     * @uses DgRequiredParametersData::setReturnLuggageOptions()
     * @uses DgRequiredParametersData::setLCCHandLuggageFeeList()
     * @uses DgRequiredParametersData::setLCCOtherFeeList()
     * @uses DgRequiredParametersData::setLCCCheckInOptionList()
     * @uses DgRequiredParametersData::setLCCRuleLink()
     * @uses DgRequiredParametersData::setBaggageAllowanceNote()
     * @uses DgRequiredParametersData::setSupplierName()
     * @uses DgRequiredParametersData::setSupplierCode()
     * @uses DgRequiredParametersData::setItineraryIndex()
     * @param \dgsoft\ArrayType\DgArrayOfLCCRequiredParameter $requiredParametersOnProcessDetails
     * @param \dgsoft\ArrayType\DgArrayOfLCCSupportedCard $lCCSupportedCardList
     * @param \dgsoft\ArrayType\DgArrayOfLCCBaggageFee $lCCBaggageFeeList
     * @param \dgsoft\ArrayType\DgArrayOfLCCBaggageFee $outwardLuggageOptions
     * @param \dgsoft\ArrayType\DgArrayOfLCCBaggageFee $returnLuggageOptions
     * @param \dgsoft\ArrayType\DgArrayOfLCCBaggageFee $lCCHandLuggageFeeList
     * @param \dgsoft\ArrayType\DgArrayOfLCCOtherFee $lCCOtherFeeList
     * @param \dgsoft\ArrayType\DgArrayOfLCCCheckInOption $lCCCheckInOptionList
     * @param string $lCCRuleLink
     * @param string $baggageAllowanceNote
     * @param string $supplierName
     * @param string $supplierCode
     * @param int $itineraryIndex
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfLCCRequiredParameter $requiredParametersOnProcessDetails = null, \dgsoft\ArrayType\DgArrayOfLCCSupportedCard $lCCSupportedCardList = null, \dgsoft\ArrayType\DgArrayOfLCCBaggageFee $lCCBaggageFeeList = null, \dgsoft\ArrayType\DgArrayOfLCCBaggageFee $outwardLuggageOptions = null, \dgsoft\ArrayType\DgArrayOfLCCBaggageFee $returnLuggageOptions = null, \dgsoft\ArrayType\DgArrayOfLCCBaggageFee $lCCHandLuggageFeeList = null, \dgsoft\ArrayType\DgArrayOfLCCOtherFee $lCCOtherFeeList = null, \dgsoft\ArrayType\DgArrayOfLCCCheckInOption $lCCCheckInOptionList = null, $lCCRuleLink = null, $baggageAllowanceNote = null, $supplierName = null, $supplierCode = null, $itineraryIndex = null)
    {
        $this
            ->setRequiredParametersOnProcessDetails($requiredParametersOnProcessDetails)
            ->setLCCSupportedCardList($lCCSupportedCardList)
            ->setLCCBaggageFeeList($lCCBaggageFeeList)
            ->setOutwardLuggageOptions($outwardLuggageOptions)
            ->setReturnLuggageOptions($returnLuggageOptions)
            ->setLCCHandLuggageFeeList($lCCHandLuggageFeeList)
            ->setLCCOtherFeeList($lCCOtherFeeList)
            ->setLCCCheckInOptionList($lCCCheckInOptionList)
            ->setLCCRuleLink($lCCRuleLink)
            ->setBaggageAllowanceNote($baggageAllowanceNote)
            ->setSupplierName($supplierName)
            ->setSupplierCode($supplierCode)
            ->setItineraryIndex($itineraryIndex);
    }
    /**
     * Get RequiredParametersOnProcessDetails value
     * @return \dgsoft\ArrayType\DgArrayOfLCCRequiredParameter|null
     */
    public function getRequiredParametersOnProcessDetails()
    {
        return $this->RequiredParametersOnProcessDetails;
    }
    /**
     * Set RequiredParametersOnProcessDetails value
     * @param \dgsoft\ArrayType\DgArrayOfLCCRequiredParameter $requiredParametersOnProcessDetails
     * @return \dgsoft\StructType\DgRequiredParametersData
     */
    public function setRequiredParametersOnProcessDetails(\dgsoft\ArrayType\DgArrayOfLCCRequiredParameter $requiredParametersOnProcessDetails = null)
    {
        $this->RequiredParametersOnProcessDetails = $requiredParametersOnProcessDetails;
        return $this;
    }
    /**
     * Get LCCSupportedCardList value
     * @return \dgsoft\ArrayType\DgArrayOfLCCSupportedCard|null
     */
    public function getLCCSupportedCardList()
    {
        return $this->LCCSupportedCardList;
    }
    /**
     * Set LCCSupportedCardList value
     * @param \dgsoft\ArrayType\DgArrayOfLCCSupportedCard $lCCSupportedCardList
     * @return \dgsoft\StructType\DgRequiredParametersData
     */
    public function setLCCSupportedCardList(\dgsoft\ArrayType\DgArrayOfLCCSupportedCard $lCCSupportedCardList = null)
    {
        $this->LCCSupportedCardList = $lCCSupportedCardList;
        return $this;
    }
    /**
     * Get LCCBaggageFeeList value
     * @return \dgsoft\ArrayType\DgArrayOfLCCBaggageFee|null
     */
    public function getLCCBaggageFeeList()
    {
        return $this->LCCBaggageFeeList;
    }
    /**
     * Set LCCBaggageFeeList value
     * @param \dgsoft\ArrayType\DgArrayOfLCCBaggageFee $lCCBaggageFeeList
     * @return \dgsoft\StructType\DgRequiredParametersData
     */
    public function setLCCBaggageFeeList(\dgsoft\ArrayType\DgArrayOfLCCBaggageFee $lCCBaggageFeeList = null)
    {
        $this->LCCBaggageFeeList = $lCCBaggageFeeList;
        return $this;
    }
    /**
     * Get OutwardLuggageOptions value
     * @return \dgsoft\ArrayType\DgArrayOfLCCBaggageFee|null
     */
    public function getOutwardLuggageOptions()
    {
        return $this->OutwardLuggageOptions;
    }
    /**
     * Set OutwardLuggageOptions value
     * @param \dgsoft\ArrayType\DgArrayOfLCCBaggageFee $outwardLuggageOptions
     * @return \dgsoft\StructType\DgRequiredParametersData
     */
    public function setOutwardLuggageOptions(\dgsoft\ArrayType\DgArrayOfLCCBaggageFee $outwardLuggageOptions = null)
    {
        $this->OutwardLuggageOptions = $outwardLuggageOptions;
        return $this;
    }
    /**
     * Get ReturnLuggageOptions value
     * @return \dgsoft\ArrayType\DgArrayOfLCCBaggageFee|null
     */
    public function getReturnLuggageOptions()
    {
        return $this->ReturnLuggageOptions;
    }
    /**
     * Set ReturnLuggageOptions value
     * @param \dgsoft\ArrayType\DgArrayOfLCCBaggageFee $returnLuggageOptions
     * @return \dgsoft\StructType\DgRequiredParametersData
     */
    public function setReturnLuggageOptions(\dgsoft\ArrayType\DgArrayOfLCCBaggageFee $returnLuggageOptions = null)
    {
        $this->ReturnLuggageOptions = $returnLuggageOptions;
        return $this;
    }
    /**
     * Get LCCHandLuggageFeeList value
     * @return \dgsoft\ArrayType\DgArrayOfLCCBaggageFee|null
     */
    public function getLCCHandLuggageFeeList()
    {
        return $this->LCCHandLuggageFeeList;
    }
    /**
     * Set LCCHandLuggageFeeList value
     * @param \dgsoft\ArrayType\DgArrayOfLCCBaggageFee $lCCHandLuggageFeeList
     * @return \dgsoft\StructType\DgRequiredParametersData
     */
    public function setLCCHandLuggageFeeList(\dgsoft\ArrayType\DgArrayOfLCCBaggageFee $lCCHandLuggageFeeList = null)
    {
        $this->LCCHandLuggageFeeList = $lCCHandLuggageFeeList;
        return $this;
    }
    /**
     * Get LCCOtherFeeList value
     * @return \dgsoft\ArrayType\DgArrayOfLCCOtherFee|null
     */
    public function getLCCOtherFeeList()
    {
        return $this->LCCOtherFeeList;
    }
    /**
     * Set LCCOtherFeeList value
     * @param \dgsoft\ArrayType\DgArrayOfLCCOtherFee $lCCOtherFeeList
     * @return \dgsoft\StructType\DgRequiredParametersData
     */
    public function setLCCOtherFeeList(\dgsoft\ArrayType\DgArrayOfLCCOtherFee $lCCOtherFeeList = null)
    {
        $this->LCCOtherFeeList = $lCCOtherFeeList;
        return $this;
    }
    /**
     * Get LCCCheckInOptionList value
     * @return \dgsoft\ArrayType\DgArrayOfLCCCheckInOption|null
     */
    public function getLCCCheckInOptionList()
    {
        return $this->LCCCheckInOptionList;
    }
    /**
     * Set LCCCheckInOptionList value
     * @param \dgsoft\ArrayType\DgArrayOfLCCCheckInOption $lCCCheckInOptionList
     * @return \dgsoft\StructType\DgRequiredParametersData
     */
    public function setLCCCheckInOptionList(\dgsoft\ArrayType\DgArrayOfLCCCheckInOption $lCCCheckInOptionList = null)
    {
        $this->LCCCheckInOptionList = $lCCCheckInOptionList;
        return $this;
    }
    /**
     * Get LCCRuleLink value
     * @return string|null
     */
    public function getLCCRuleLink()
    {
        return $this->LCCRuleLink;
    }
    /**
     * Set LCCRuleLink value
     * @param string $lCCRuleLink
     * @return \dgsoft\StructType\DgRequiredParametersData
     */
    public function setLCCRuleLink($lCCRuleLink = null)
    {
        // validation for constraint: string
        if (!is_null($lCCRuleLink) && !is_string($lCCRuleLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lCCRuleLink)), __LINE__);
        }
        $this->LCCRuleLink = $lCCRuleLink;
        return $this;
    }
    /**
     * Get BaggageAllowanceNote value
     * @return string|null
     */
    public function getBaggageAllowanceNote()
    {
        return $this->BaggageAllowanceNote;
    }
    /**
     * Set BaggageAllowanceNote value
     * @param string $baggageAllowanceNote
     * @return \dgsoft\StructType\DgRequiredParametersData
     */
    public function setBaggageAllowanceNote($baggageAllowanceNote = null)
    {
        // validation for constraint: string
        if (!is_null($baggageAllowanceNote) && !is_string($baggageAllowanceNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baggageAllowanceNote)), __LINE__);
        }
        $this->BaggageAllowanceNote = $baggageAllowanceNote;
        return $this;
    }
    /**
     * Get SupplierName value
     * @return string|null
     */
    public function getSupplierName()
    {
        return $this->SupplierName;
    }
    /**
     * Set SupplierName value
     * @param string $supplierName
     * @return \dgsoft\StructType\DgRequiredParametersData
     */
    public function setSupplierName($supplierName = null)
    {
        // validation for constraint: string
        if (!is_null($supplierName) && !is_string($supplierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($supplierName)), __LINE__);
        }
        $this->SupplierName = $supplierName;
        return $this;
    }
    /**
     * Get SupplierCode value
     * @return string|null
     */
    public function getSupplierCode()
    {
        return $this->SupplierCode;
    }
    /**
     * Set SupplierCode value
     * @param string $supplierCode
     * @return \dgsoft\StructType\DgRequiredParametersData
     */
    public function setSupplierCode($supplierCode = null)
    {
        // validation for constraint: string
        if (!is_null($supplierCode) && !is_string($supplierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($supplierCode)), __LINE__);
        }
        $this->SupplierCode = $supplierCode;
        return $this;
    }
    /**
     * Get ItineraryIndex value
     * @return int|null
     */
    public function getItineraryIndex()
    {
        return $this->ItineraryIndex;
    }
    /**
     * Set ItineraryIndex value
     * @param int $itineraryIndex
     * @return \dgsoft\StructType\DgRequiredParametersData
     */
    public function setItineraryIndex($itineraryIndex = null)
    {
        // validation for constraint: int
        if (!is_null($itineraryIndex) && !is_numeric($itineraryIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itineraryIndex)), __LINE__);
        }
        $this->ItineraryIndex = $itineraryIndex;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRequiredParametersData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
