<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Remark StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRemark extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The Operation
     * @var string
     */
    public $Operation;
    /**
     * Constructor method for Remark
     * @uses DgRemark::set_()
     * @uses DgRemark::setRPH()
     * @uses DgRemark::setOperation()
     * @param string $_
     * @param string $rPH
     * @param string $operation
     */
    public function __construct($_ = null, $rPH = null, $operation = null)
    {
        $this
            ->set_($_)
            ->setRPH($rPH)
            ->setOperation($operation);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \dgsoft\StructType\DgRemark
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \dgsoft\StructType\DgRemark
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \dgsoft\EnumType\DgActionType::valueIsValid()
     * @uses \dgsoft\EnumType\DgActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \dgsoft\StructType\DgRemark
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $operation, implode(', ', \dgsoft\EnumType\DgActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRemark
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
