<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatedMember StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRelatedMember extends AbstractStructBase
{
    /**
     * The MemberID
     * @var string
     */
    public $MemberID;
    /**
     * The GuestMemberID
     * @var string
     */
    public $GuestMemberID;
    /**
     * Constructor method for RelatedMember
     * @uses DgRelatedMember::setMemberID()
     * @uses DgRelatedMember::setGuestMemberID()
     * @param string $memberID
     * @param string $guestMemberID
     */
    public function __construct($memberID = null, $guestMemberID = null)
    {
        $this
            ->setMemberID($memberID)
            ->setGuestMemberID($guestMemberID);
    }
    /**
     * Get MemberID value
     * @return string|null
     */
    public function getMemberID()
    {
        return $this->MemberID;
    }
    /**
     * Set MemberID value
     * @param string $memberID
     * @return \dgsoft\StructType\DgRelatedMember
     */
    public function setMemberID($memberID = null)
    {
        // validation for constraint: string
        if (!is_null($memberID) && !is_string($memberID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($memberID)), __LINE__);
        }
        $this->MemberID = $memberID;
        return $this;
    }
    /**
     * Get GuestMemberID value
     * @return string|null
     */
    public function getGuestMemberID()
    {
        return $this->GuestMemberID;
    }
    /**
     * Set GuestMemberID value
     * @param string $guestMemberID
     * @return \dgsoft\StructType\DgRelatedMember
     */
    public function setGuestMemberID($guestMemberID = null)
    {
        // validation for constraint: string
        if (!is_null($guestMemberID) && !is_string($guestMemberID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guestMemberID)), __LINE__);
        }
        $this->GuestMemberID = $guestMemberID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRelatedMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
