<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadRequest StructType
 * @package Dg
 * @subpackage Structs
 */
class DgReadRequest extends AbstractStructBase
{
    /**
     * The BookingReferenceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUniqueID_Type
     */
    public $BookingReferenceID;
    /**
     * The Verification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVerificationType
     */
    public $Verification;
    /**
     * The HistoryRequestedInd
     * @var bool
     */
    public $HistoryRequestedInd;
    /**
     * Constructor method for ReadRequest
     * @uses DgReadRequest::setBookingReferenceID()
     * @uses DgReadRequest::setVerification()
     * @uses DgReadRequest::setHistoryRequestedInd()
     * @param \dgsoft\StructType\DgUniqueID_Type $bookingReferenceID
     * @param \dgsoft\StructType\DgVerificationType $verification
     * @param bool $historyRequestedInd
     */
    public function __construct(\dgsoft\StructType\DgUniqueID_Type $bookingReferenceID = null, \dgsoft\StructType\DgVerificationType $verification = null, $historyRequestedInd = null)
    {
        $this
            ->setBookingReferenceID($bookingReferenceID)
            ->setVerification($verification)
            ->setHistoryRequestedInd($historyRequestedInd);
    }
    /**
     * Get BookingReferenceID value
     * @return \dgsoft\StructType\DgUniqueID_Type|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @param \dgsoft\StructType\DgUniqueID_Type $bookingReferenceID
     * @return \dgsoft\StructType\DgReadRequest
     */
    public function setBookingReferenceID(\dgsoft\StructType\DgUniqueID_Type $bookingReferenceID = null)
    {
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Get Verification value
     * @return \dgsoft\StructType\DgVerificationType|null
     */
    public function getVerification()
    {
        return $this->Verification;
    }
    /**
     * Set Verification value
     * @param \dgsoft\StructType\DgVerificationType $verification
     * @return \dgsoft\StructType\DgReadRequest
     */
    public function setVerification(\dgsoft\StructType\DgVerificationType $verification = null)
    {
        $this->Verification = $verification;
        return $this;
    }
    /**
     * Get HistoryRequestedInd value
     * @return bool|null
     */
    public function getHistoryRequestedInd()
    {
        return $this->HistoryRequestedInd;
    }
    /**
     * Set HistoryRequestedInd value
     * @param bool $historyRequestedInd
     * @return \dgsoft\StructType\DgReadRequest
     */
    public function setHistoryRequestedInd($historyRequestedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($historyRequestedInd) && !is_bool($historyRequestedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($historyRequestedInd)), __LINE__);
        }
        $this->HistoryRequestedInd = $historyRequestedInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgReadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
