<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateRange StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRateRange extends AbstractStructBase
{
    /**
     * The MinRate
     * @var float
     */
    public $MinRate;
    /**
     * The MaxRate
     * @var float
     */
    public $MaxRate;
    /**
     * The FixedRate
     * @var float
     */
    public $FixedRate;
    /**
     * The RateTimeUnit
     * @var string
     */
    public $RateTimeUnit;
    /**
     * The InfoSource
     * @var string
     */
    public $InfoSource;
    /**
     * The TaxRate
     * @var float
     */
    public $TaxRate;
    /**
     * The RateInfoNotAvailableInd
     * @var bool
     */
    public $RateInfoNotAvailableInd;
    /**
     * The RoomStayCandidateRPH
     * @var string
     */
    public $RoomStayCandidateRPH;
    /**
     * The RateMode
     * @var string
     */
    public $RateMode;
    /**
     * Constructor method for RateRange
     * @uses DgRateRange::setMinRate()
     * @uses DgRateRange::setMaxRate()
     * @uses DgRateRange::setFixedRate()
     * @uses DgRateRange::setRateTimeUnit()
     * @uses DgRateRange::setInfoSource()
     * @uses DgRateRange::setTaxRate()
     * @uses DgRateRange::setRateInfoNotAvailableInd()
     * @uses DgRateRange::setRoomStayCandidateRPH()
     * @uses DgRateRange::setRateMode()
     * @param float $minRate
     * @param float $maxRate
     * @param float $fixedRate
     * @param string $rateTimeUnit
     * @param string $infoSource
     * @param float $taxRate
     * @param bool $rateInfoNotAvailableInd
     * @param string $roomStayCandidateRPH
     * @param string $rateMode
     */
    public function __construct($minRate = null, $maxRate = null, $fixedRate = null, $rateTimeUnit = null, $infoSource = null, $taxRate = null, $rateInfoNotAvailableInd = null, $roomStayCandidateRPH = null, $rateMode = null)
    {
        $this
            ->setMinRate($minRate)
            ->setMaxRate($maxRate)
            ->setFixedRate($fixedRate)
            ->setRateTimeUnit($rateTimeUnit)
            ->setInfoSource($infoSource)
            ->setTaxRate($taxRate)
            ->setRateInfoNotAvailableInd($rateInfoNotAvailableInd)
            ->setRoomStayCandidateRPH($roomStayCandidateRPH)
            ->setRateMode($rateMode);
    }
    /**
     * Get MinRate value
     * @return float|null
     */
    public function getMinRate()
    {
        return $this->MinRate;
    }
    /**
     * Set MinRate value
     * @param float $minRate
     * @return \dgsoft\StructType\DgRateRange
     */
    public function setMinRate($minRate = null)
    {
        $this->MinRate = $minRate;
        return $this;
    }
    /**
     * Get MaxRate value
     * @return float|null
     */
    public function getMaxRate()
    {
        return $this->MaxRate;
    }
    /**
     * Set MaxRate value
     * @param float $maxRate
     * @return \dgsoft\StructType\DgRateRange
     */
    public function setMaxRate($maxRate = null)
    {
        $this->MaxRate = $maxRate;
        return $this;
    }
    /**
     * Get FixedRate value
     * @return float|null
     */
    public function getFixedRate()
    {
        return $this->FixedRate;
    }
    /**
     * Set FixedRate value
     * @param float $fixedRate
     * @return \dgsoft\StructType\DgRateRange
     */
    public function setFixedRate($fixedRate = null)
    {
        $this->FixedRate = $fixedRate;
        return $this;
    }
    /**
     * Get RateTimeUnit value
     * @return string|null
     */
    public function getRateTimeUnit()
    {
        return $this->RateTimeUnit;
    }
    /**
     * Set RateTimeUnit value
     * @uses \dgsoft\EnumType\DgTimeUnitType::valueIsValid()
     * @uses \dgsoft\EnumType\DgTimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rateTimeUnit
     * @return \dgsoft\StructType\DgRateRange
     */
    public function setRateTimeUnit($rateTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgTimeUnitType::valueIsValid($rateTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rateTimeUnit, implode(', ', \dgsoft\EnumType\DgTimeUnitType::getValidValues())), __LINE__);
        }
        $this->RateTimeUnit = $rateTimeUnit;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \dgsoft\StructType\DgRateRange
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get TaxRate value
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->TaxRate;
    }
    /**
     * Set TaxRate value
     * @param float $taxRate
     * @return \dgsoft\StructType\DgRateRange
     */
    public function setTaxRate($taxRate = null)
    {
        $this->TaxRate = $taxRate;
        return $this;
    }
    /**
     * Get RateInfoNotAvailableInd value
     * @return bool|null
     */
    public function getRateInfoNotAvailableInd()
    {
        return $this->RateInfoNotAvailableInd;
    }
    /**
     * Set RateInfoNotAvailableInd value
     * @param bool $rateInfoNotAvailableInd
     * @return \dgsoft\StructType\DgRateRange
     */
    public function setRateInfoNotAvailableInd($rateInfoNotAvailableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($rateInfoNotAvailableInd) && !is_bool($rateInfoNotAvailableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($rateInfoNotAvailableInd)), __LINE__);
        }
        $this->RateInfoNotAvailableInd = $rateInfoNotAvailableInd;
        return $this;
    }
    /**
     * Get RoomStayCandidateRPH value
     * @return string|null
     */
    public function getRoomStayCandidateRPH()
    {
        return $this->RoomStayCandidateRPH;
    }
    /**
     * Set RoomStayCandidateRPH value
     * @param string $roomStayCandidateRPH
     * @return \dgsoft\StructType\DgRateRange
     */
    public function setRoomStayCandidateRPH($roomStayCandidateRPH = null)
    {
        // validation for constraint: string
        if (!is_null($roomStayCandidateRPH) && !is_string($roomStayCandidateRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomStayCandidateRPH)), __LINE__);
        }
        $this->RoomStayCandidateRPH = $roomStayCandidateRPH;
        return $this;
    }
    /**
     * Get RateMode value
     * @return string|null
     */
    public function getRateMode()
    {
        return $this->RateMode;
    }
    /**
     * Set RateMode value
     * @param string $rateMode
     * @return \dgsoft\StructType\DgRateRange
     */
    public function setRateMode($rateMode = null)
    {
        // validation for constraint: string
        if (!is_null($rateMode) && !is_string($rateMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateMode)), __LINE__);
        }
        $this->RateMode = $rateMode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRateRange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
