<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateQualifierType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRateQualifierType extends AbstractStructBase
{
    /**
     * The PromoDesc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PromoDesc;
    /**
     * The RateComments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfRateQualifierTypeRateComment
     */
    public $RateComments;
    /**
     * The TravelPurpose
     * @var string
     */
    public $TravelPurpose;
    /**
     * The RateCategory
     * @var string
     */
    public $RateCategory;
    /**
     * The CorpDiscountNmbr
     * @var string
     */
    public $CorpDiscountNmbr;
    /**
     * The RateQualifier
     * @var string
     */
    public $RateQualifier;
    /**
     * The RatePeriod
     * @var string
     */
    public $RatePeriod;
    /**
     * The GuaranteedInd
     * @var bool
     */
    public $GuaranteedInd;
    /**
     * The ArriveByFlight
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $ArriveByFlight;
    /**
     * The RateAuthorizationCode
     * @var string
     */
    public $RateAuthorizationCode;
    /**
     * The VendorRateID
     * @var string
     */
    public $VendorRateID;
    /**
     * Constructor method for RateQualifierType
     * @uses DgRateQualifierType::setPromoDesc()
     * @uses DgRateQualifierType::setRateComments()
     * @uses DgRateQualifierType::setTravelPurpose()
     * @uses DgRateQualifierType::setRateCategory()
     * @uses DgRateQualifierType::setCorpDiscountNmbr()
     * @uses DgRateQualifierType::setRateQualifier()
     * @uses DgRateQualifierType::setRatePeriod()
     * @uses DgRateQualifierType::setGuaranteedInd()
     * @uses DgRateQualifierType::setArriveByFlight()
     * @uses DgRateQualifierType::setRateAuthorizationCode()
     * @uses DgRateQualifierType::setVendorRateID()
     * @param string $promoDesc
     * @param \dgsoft\ArrayType\DgArrayOfRateQualifierTypeRateComment $rateComments
     * @param string $travelPurpose
     * @param string $rateCategory
     * @param string $corpDiscountNmbr
     * @param string $rateQualifier
     * @param string $ratePeriod
     * @param bool $guaranteedInd
     * @param bool $arriveByFlight
     * @param string $rateAuthorizationCode
     * @param string $vendorRateID
     */
    public function __construct($promoDesc = null, \dgsoft\ArrayType\DgArrayOfRateQualifierTypeRateComment $rateComments = null, $travelPurpose = null, $rateCategory = null, $corpDiscountNmbr = null, $rateQualifier = null, $ratePeriod = null, $guaranteedInd = null, $arriveByFlight = false, $rateAuthorizationCode = null, $vendorRateID = null)
    {
        $this
            ->setPromoDesc($promoDesc)
            ->setRateComments($rateComments)
            ->setTravelPurpose($travelPurpose)
            ->setRateCategory($rateCategory)
            ->setCorpDiscountNmbr($corpDiscountNmbr)
            ->setRateQualifier($rateQualifier)
            ->setRatePeriod($ratePeriod)
            ->setGuaranteedInd($guaranteedInd)
            ->setArriveByFlight($arriveByFlight)
            ->setRateAuthorizationCode($rateAuthorizationCode)
            ->setVendorRateID($vendorRateID);
    }
    /**
     * Get PromoDesc value
     * @return string|null
     */
    public function getPromoDesc()
    {
        return $this->PromoDesc;
    }
    /**
     * Set PromoDesc value
     * @param string $promoDesc
     * @return \dgsoft\StructType\DgRateQualifierType
     */
    public function setPromoDesc($promoDesc = null)
    {
        // validation for constraint: string
        if (!is_null($promoDesc) && !is_string($promoDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($promoDesc)), __LINE__);
        }
        $this->PromoDesc = $promoDesc;
        return $this;
    }
    /**
     * Get RateComments value
     * @return \dgsoft\ArrayType\DgArrayOfRateQualifierTypeRateComment|null
     */
    public function getRateComments()
    {
        return $this->RateComments;
    }
    /**
     * Set RateComments value
     * @param \dgsoft\ArrayType\DgArrayOfRateQualifierTypeRateComment $rateComments
     * @return \dgsoft\StructType\DgRateQualifierType
     */
    public function setRateComments(\dgsoft\ArrayType\DgArrayOfRateQualifierTypeRateComment $rateComments = null)
    {
        $this->RateComments = $rateComments;
        return $this;
    }
    /**
     * Get TravelPurpose value
     * @return string|null
     */
    public function getTravelPurpose()
    {
        return $this->TravelPurpose;
    }
    /**
     * Set TravelPurpose value
     * @param string $travelPurpose
     * @return \dgsoft\StructType\DgRateQualifierType
     */
    public function setTravelPurpose($travelPurpose = null)
    {
        // validation for constraint: string
        if (!is_null($travelPurpose) && !is_string($travelPurpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelPurpose)), __LINE__);
        }
        $this->TravelPurpose = $travelPurpose;
        return $this;
    }
    /**
     * Get RateCategory value
     * @return string|null
     */
    public function getRateCategory()
    {
        return $this->RateCategory;
    }
    /**
     * Set RateCategory value
     * @param string $rateCategory
     * @return \dgsoft\StructType\DgRateQualifierType
     */
    public function setRateCategory($rateCategory = null)
    {
        // validation for constraint: string
        if (!is_null($rateCategory) && !is_string($rateCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateCategory)), __LINE__);
        }
        $this->RateCategory = $rateCategory;
        return $this;
    }
    /**
     * Get CorpDiscountNmbr value
     * @return string|null
     */
    public function getCorpDiscountNmbr()
    {
        return $this->CorpDiscountNmbr;
    }
    /**
     * Set CorpDiscountNmbr value
     * @param string $corpDiscountNmbr
     * @return \dgsoft\StructType\DgRateQualifierType
     */
    public function setCorpDiscountNmbr($corpDiscountNmbr = null)
    {
        // validation for constraint: string
        if (!is_null($corpDiscountNmbr) && !is_string($corpDiscountNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($corpDiscountNmbr)), __LINE__);
        }
        $this->CorpDiscountNmbr = $corpDiscountNmbr;
        return $this;
    }
    /**
     * Get RateQualifier value
     * @return string|null
     */
    public function getRateQualifier()
    {
        return $this->RateQualifier;
    }
    /**
     * Set RateQualifier value
     * @param string $rateQualifier
     * @return \dgsoft\StructType\DgRateQualifierType
     */
    public function setRateQualifier($rateQualifier = null)
    {
        // validation for constraint: string
        if (!is_null($rateQualifier) && !is_string($rateQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateQualifier)), __LINE__);
        }
        $this->RateQualifier = $rateQualifier;
        return $this;
    }
    /**
     * Get RatePeriod value
     * @return string|null
     */
    public function getRatePeriod()
    {
        return $this->RatePeriod;
    }
    /**
     * Set RatePeriod value
     * @uses \dgsoft\EnumType\DgRateQualifierTypeRatePeriod::valueIsValid()
     * @uses \dgsoft\EnumType\DgRateQualifierTypeRatePeriod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ratePeriod
     * @return \dgsoft\StructType\DgRateQualifierType
     */
    public function setRatePeriod($ratePeriod = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgRateQualifierTypeRatePeriod::valueIsValid($ratePeriod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ratePeriod, implode(', ', \dgsoft\EnumType\DgRateQualifierTypeRatePeriod::getValidValues())), __LINE__);
        }
        $this->RatePeriod = $ratePeriod;
        return $this;
    }
    /**
     * Get GuaranteedInd value
     * @return bool|null
     */
    public function getGuaranteedInd()
    {
        return $this->GuaranteedInd;
    }
    /**
     * Set GuaranteedInd value
     * @param bool $guaranteedInd
     * @return \dgsoft\StructType\DgRateQualifierType
     */
    public function setGuaranteedInd($guaranteedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($guaranteedInd) && !is_bool($guaranteedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($guaranteedInd)), __LINE__);
        }
        $this->GuaranteedInd = $guaranteedInd;
        return $this;
    }
    /**
     * Get ArriveByFlight value
     * @return bool|null
     */
    public function getArriveByFlight()
    {
        return $this->ArriveByFlight;
    }
    /**
     * Set ArriveByFlight value
     * @param bool $arriveByFlight
     * @return \dgsoft\StructType\DgRateQualifierType
     */
    public function setArriveByFlight($arriveByFlight = false)
    {
        // validation for constraint: boolean
        if (!is_null($arriveByFlight) && !is_bool($arriveByFlight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($arriveByFlight)), __LINE__);
        }
        $this->ArriveByFlight = $arriveByFlight;
        return $this;
    }
    /**
     * Get RateAuthorizationCode value
     * @return string|null
     */
    public function getRateAuthorizationCode()
    {
        return $this->RateAuthorizationCode;
    }
    /**
     * Set RateAuthorizationCode value
     * @param string $rateAuthorizationCode
     * @return \dgsoft\StructType\DgRateQualifierType
     */
    public function setRateAuthorizationCode($rateAuthorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($rateAuthorizationCode) && !is_string($rateAuthorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateAuthorizationCode)), __LINE__);
        }
        $this->RateAuthorizationCode = $rateAuthorizationCode;
        return $this;
    }
    /**
     * Get VendorRateID value
     * @return string|null
     */
    public function getVendorRateID()
    {
        return $this->VendorRateID;
    }
    /**
     * Set VendorRateID value
     * @param string $vendorRateID
     * @return \dgsoft\StructType\DgRateQualifierType
     */
    public function setVendorRateID($vendorRateID = null)
    {
        // validation for constraint: string
        if (!is_null($vendorRateID) && !is_string($vendorRateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendorRateID)), __LINE__);
        }
        $this->VendorRateID = $vendorRateID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRateQualifierType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
