<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rate StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRate extends DgAmountType
{
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The RateMode
     * @var string
     */
    public $RateMode;
    /**
     * The CachedIndicator
     * @var bool
     */
    public $CachedIndicator;
    /**
     * The RateSource
     * @var string
     */
    public $RateSource;
    /**
     * The RateTypeCode
     * @var string
     */
    public $RateTypeCode;
    /**
     * The RoomPricingType
     * @var string
     */
    public $RoomPricingType;
    /**
     * Constructor method for Rate
     * @uses DgRate::setTPA_Extensions()
     * @uses DgRate::setDuration()
     * @uses DgRate::setRateMode()
     * @uses DgRate::setCachedIndicator()
     * @uses DgRate::setRateSource()
     * @uses DgRate::setRateTypeCode()
     * @uses DgRate::setRoomPricingType()
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param string $duration
     * @param string $rateMode
     * @param bool $cachedIndicator
     * @param string $rateSource
     * @param string $rateTypeCode
     * @param string $roomPricingType
     */
    public function __construct(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $duration = null, $rateMode = null, $cachedIndicator = null, $rateSource = null, $rateTypeCode = null, $roomPricingType = null)
    {
        $this
            ->setTPA_Extensions($tPA_Extensions)
            ->setDuration($duration)
            ->setRateMode($rateMode)
            ->setCachedIndicator($cachedIndicator)
            ->setRateSource($rateSource)
            ->setRateTypeCode($rateTypeCode)
            ->setRoomPricingType($roomPricingType);
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgRate
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \dgsoft\StructType\DgRate
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get RateMode value
     * @return string|null
     */
    public function getRateMode()
    {
        return $this->RateMode;
    }
    /**
     * Set RateMode value
     * @param string $rateMode
     * @return \dgsoft\StructType\DgRate
     */
    public function setRateMode($rateMode = null)
    {
        // validation for constraint: string
        if (!is_null($rateMode) && !is_string($rateMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateMode)), __LINE__);
        }
        $this->RateMode = $rateMode;
        return $this;
    }
    /**
     * Get CachedIndicator value
     * @return bool|null
     */
    public function getCachedIndicator()
    {
        return $this->CachedIndicator;
    }
    /**
     * Set CachedIndicator value
     * @param bool $cachedIndicator
     * @return \dgsoft\StructType\DgRate
     */
    public function setCachedIndicator($cachedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($cachedIndicator) && !is_bool($cachedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($cachedIndicator)), __LINE__);
        }
        $this->CachedIndicator = $cachedIndicator;
        return $this;
    }
    /**
     * Get RateSource value
     * @return string|null
     */
    public function getRateSource()
    {
        return $this->RateSource;
    }
    /**
     * Set RateSource value
     * @param string $rateSource
     * @return \dgsoft\StructType\DgRate
     */
    public function setRateSource($rateSource = null)
    {
        // validation for constraint: string
        if (!is_null($rateSource) && !is_string($rateSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateSource)), __LINE__);
        }
        $this->RateSource = $rateSource;
        return $this;
    }
    /**
     * Get RateTypeCode value
     * @return string|null
     */
    public function getRateTypeCode()
    {
        return $this->RateTypeCode;
    }
    /**
     * Set RateTypeCode value
     * @param string $rateTypeCode
     * @return \dgsoft\StructType\DgRate
     */
    public function setRateTypeCode($rateTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($rateTypeCode) && !is_string($rateTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateTypeCode)), __LINE__);
        }
        $this->RateTypeCode = $rateTypeCode;
        return $this;
    }
    /**
     * Get RoomPricingType value
     * @return string|null
     */
    public function getRoomPricingType()
    {
        return $this->RoomPricingType;
    }
    /**
     * Set RoomPricingType value
     * @uses \dgsoft\EnumType\DgPricingType::valueIsValid()
     * @uses \dgsoft\EnumType\DgPricingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roomPricingType
     * @return \dgsoft\StructType\DgRate
     */
    public function setRoomPricingType($roomPricingType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgPricingType::valueIsValid($roomPricingType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $roomPricingType, implode(', ', \dgsoft\EnumType\DgPricingType::getValidValues())), __LINE__);
        }
        $this->RoomPricingType = $roomPricingType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
