<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueueSetting StructType
 * @package Dg
 * @subpackage Structs
 */
class DgQueueSetting extends AbstractStructBase
{
    /**
     * The RailProviderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RailProviderType;
    /**
     * The HotelProviderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HotelProviderType;
    /**
     * The CarProviderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CarProviderType;
    /**
     * The FlightProviderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FlightProviderType;
    /**
     * The DefaultQue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgQueSetting
     */
    public $DefaultQue;
    /**
     * The CancellationQue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgQueSetting
     */
    public $CancellationQue;
    /**
     * The PendingApproval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgQueSetting
     */
    public $PendingApproval;
    /**
     * The ApprovedApproval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgQueSetting
     */
    public $ApprovedApproval;
    /**
     * The DeclinedApproval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgQueSetting
     */
    public $DeclinedApproval;
    /**
     * The TicketedQue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgQueSetting
     */
    public $TicketedQue;
    /**
     * Constructor method for QueueSetting
     * @uses DgQueueSetting::setRailProviderType()
     * @uses DgQueueSetting::setHotelProviderType()
     * @uses DgQueueSetting::setCarProviderType()
     * @uses DgQueueSetting::setFlightProviderType()
     * @uses DgQueueSetting::setDefaultQue()
     * @uses DgQueueSetting::setCancellationQue()
     * @uses DgQueueSetting::setPendingApproval()
     * @uses DgQueueSetting::setApprovedApproval()
     * @uses DgQueueSetting::setDeclinedApproval()
     * @uses DgQueueSetting::setTicketedQue()
     * @param string $railProviderType
     * @param string $hotelProviderType
     * @param string $carProviderType
     * @param string $flightProviderType
     * @param \dgsoft\StructType\DgQueSetting $defaultQue
     * @param \dgsoft\StructType\DgQueSetting $cancellationQue
     * @param \dgsoft\StructType\DgQueSetting $pendingApproval
     * @param \dgsoft\StructType\DgQueSetting $approvedApproval
     * @param \dgsoft\StructType\DgQueSetting $declinedApproval
     * @param \dgsoft\StructType\DgQueSetting $ticketedQue
     */
    public function __construct($railProviderType = null, $hotelProviderType = null, $carProviderType = null, $flightProviderType = null, \dgsoft\StructType\DgQueSetting $defaultQue = null, \dgsoft\StructType\DgQueSetting $cancellationQue = null, \dgsoft\StructType\DgQueSetting $pendingApproval = null, \dgsoft\StructType\DgQueSetting $approvedApproval = null, \dgsoft\StructType\DgQueSetting $declinedApproval = null, \dgsoft\StructType\DgQueSetting $ticketedQue = null)
    {
        $this
            ->setRailProviderType($railProviderType)
            ->setHotelProviderType($hotelProviderType)
            ->setCarProviderType($carProviderType)
            ->setFlightProviderType($flightProviderType)
            ->setDefaultQue($defaultQue)
            ->setCancellationQue($cancellationQue)
            ->setPendingApproval($pendingApproval)
            ->setApprovedApproval($approvedApproval)
            ->setDeclinedApproval($declinedApproval)
            ->setTicketedQue($ticketedQue);
    }
    /**
     * Get RailProviderType value
     * @return string
     */
    public function getRailProviderType()
    {
        return $this->RailProviderType;
    }
    /**
     * Set RailProviderType value
     * @uses \dgsoft\EnumType\DgRailProviderTypeEnum::valueIsValid()
     * @uses \dgsoft\EnumType\DgRailProviderTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $railProviderType
     * @return \dgsoft\StructType\DgQueueSetting
     */
    public function setRailProviderType($railProviderType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgRailProviderTypeEnum::valueIsValid($railProviderType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $railProviderType, implode(', ', \dgsoft\EnumType\DgRailProviderTypeEnum::getValidValues())), __LINE__);
        }
        $this->RailProviderType = $railProviderType;
        return $this;
    }
    /**
     * Get HotelProviderType value
     * @return string
     */
    public function getHotelProviderType()
    {
        return $this->HotelProviderType;
    }
    /**
     * Set HotelProviderType value
     * @uses \dgsoft\EnumType\DgHotelProviderTypeEnum::valueIsValid()
     * @uses \dgsoft\EnumType\DgHotelProviderTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hotelProviderType
     * @return \dgsoft\StructType\DgQueueSetting
     */
    public function setHotelProviderType($hotelProviderType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgHotelProviderTypeEnum::valueIsValid($hotelProviderType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $hotelProviderType, implode(', ', \dgsoft\EnumType\DgHotelProviderTypeEnum::getValidValues())), __LINE__);
        }
        $this->HotelProviderType = $hotelProviderType;
        return $this;
    }
    /**
     * Get CarProviderType value
     * @return string
     */
    public function getCarProviderType()
    {
        return $this->CarProviderType;
    }
    /**
     * Set CarProviderType value
     * @uses \dgsoft\EnumType\DgCarProviderTypeEnum::valueIsValid()
     * @uses \dgsoft\EnumType\DgCarProviderTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $carProviderType
     * @return \dgsoft\StructType\DgQueueSetting
     */
    public function setCarProviderType($carProviderType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgCarProviderTypeEnum::valueIsValid($carProviderType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $carProviderType, implode(', ', \dgsoft\EnumType\DgCarProviderTypeEnum::getValidValues())), __LINE__);
        }
        $this->CarProviderType = $carProviderType;
        return $this;
    }
    /**
     * Get FlightProviderType value
     * @return string|null
     */
    public function getFlightProviderType()
    {
        return $this->FlightProviderType;
    }
    /**
     * Set FlightProviderType value
     * @param string $flightProviderType
     * @return \dgsoft\StructType\DgQueueSetting
     */
    public function setFlightProviderType($flightProviderType = null)
    {
        // validation for constraint: string
        if (!is_null($flightProviderType) && !is_string($flightProviderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightProviderType)), __LINE__);
        }
        $this->FlightProviderType = $flightProviderType;
        return $this;
    }
    /**
     * Get DefaultQue value
     * @return \dgsoft\StructType\DgQueSetting|null
     */
    public function getDefaultQue()
    {
        return $this->DefaultQue;
    }
    /**
     * Set DefaultQue value
     * @param \dgsoft\StructType\DgQueSetting $defaultQue
     * @return \dgsoft\StructType\DgQueueSetting
     */
    public function setDefaultQue(\dgsoft\StructType\DgQueSetting $defaultQue = null)
    {
        $this->DefaultQue = $defaultQue;
        return $this;
    }
    /**
     * Get CancellationQue value
     * @return \dgsoft\StructType\DgQueSetting|null
     */
    public function getCancellationQue()
    {
        return $this->CancellationQue;
    }
    /**
     * Set CancellationQue value
     * @param \dgsoft\StructType\DgQueSetting $cancellationQue
     * @return \dgsoft\StructType\DgQueueSetting
     */
    public function setCancellationQue(\dgsoft\StructType\DgQueSetting $cancellationQue = null)
    {
        $this->CancellationQue = $cancellationQue;
        return $this;
    }
    /**
     * Get PendingApproval value
     * @return \dgsoft\StructType\DgQueSetting|null
     */
    public function getPendingApproval()
    {
        return $this->PendingApproval;
    }
    /**
     * Set PendingApproval value
     * @param \dgsoft\StructType\DgQueSetting $pendingApproval
     * @return \dgsoft\StructType\DgQueueSetting
     */
    public function setPendingApproval(\dgsoft\StructType\DgQueSetting $pendingApproval = null)
    {
        $this->PendingApproval = $pendingApproval;
        return $this;
    }
    /**
     * Get ApprovedApproval value
     * @return \dgsoft\StructType\DgQueSetting|null
     */
    public function getApprovedApproval()
    {
        return $this->ApprovedApproval;
    }
    /**
     * Set ApprovedApproval value
     * @param \dgsoft\StructType\DgQueSetting $approvedApproval
     * @return \dgsoft\StructType\DgQueueSetting
     */
    public function setApprovedApproval(\dgsoft\StructType\DgQueSetting $approvedApproval = null)
    {
        $this->ApprovedApproval = $approvedApproval;
        return $this;
    }
    /**
     * Get DeclinedApproval value
     * @return \dgsoft\StructType\DgQueSetting|null
     */
    public function getDeclinedApproval()
    {
        return $this->DeclinedApproval;
    }
    /**
     * Set DeclinedApproval value
     * @param \dgsoft\StructType\DgQueSetting $declinedApproval
     * @return \dgsoft\StructType\DgQueueSetting
     */
    public function setDeclinedApproval(\dgsoft\StructType\DgQueSetting $declinedApproval = null)
    {
        $this->DeclinedApproval = $declinedApproval;
        return $this;
    }
    /**
     * Get TicketedQue value
     * @return \dgsoft\StructType\DgQueSetting|null
     */
    public function getTicketedQue()
    {
        return $this->TicketedQue;
    }
    /**
     * Set TicketedQue value
     * @param \dgsoft\StructType\DgQueSetting $ticketedQue
     * @return \dgsoft\StructType\DgQueueSetting
     */
    public function setTicketedQue(\dgsoft\StructType\DgQueSetting $ticketedQue = null)
    {
        $this->TicketedQue = $ticketedQue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgQueueSetting
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
