<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueueInfo StructType
 * @package Dg
 * @subpackage Structs
 */
class DgQueueInfo extends AbstractStructBase
{
    /**
     * The Queue
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgQueue[]
     */
    public $Queue;
    /**
     * The FirstItemOnlyInd
     * @var bool
     */
    public $FirstItemOnlyInd;
    /**
     * The RemoveFromQueueInd
     * @var bool
     */
    public $RemoveFromQueueInd;
    /**
     * The FullDataInd
     * @var bool
     */
    public $FullDataInd;
    /**
     * The StartDate
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * @var string
     */
    public $EndDate;
    /**
     * Constructor method for QueueInfo
     * @uses DgQueueInfo::setQueue()
     * @uses DgQueueInfo::setFirstItemOnlyInd()
     * @uses DgQueueInfo::setRemoveFromQueueInd()
     * @uses DgQueueInfo::setFullDataInd()
     * @uses DgQueueInfo::setStartDate()
     * @uses DgQueueInfo::setEndDate()
     * @param \dgsoft\StructType\DgQueue[] $queue
     * @param bool $firstItemOnlyInd
     * @param bool $removeFromQueueInd
     * @param bool $fullDataInd
     * @param string $startDate
     * @param string $endDate
     */
    public function __construct(array $queue = array(), $firstItemOnlyInd = null, $removeFromQueueInd = null, $fullDataInd = null, $startDate = null, $endDate = null)
    {
        $this
            ->setQueue($queue)
            ->setFirstItemOnlyInd($firstItemOnlyInd)
            ->setRemoveFromQueueInd($removeFromQueueInd)
            ->setFullDataInd($fullDataInd)
            ->setStartDate($startDate)
            ->setEndDate($endDate);
    }
    /**
     * Get Queue value
     * @return \dgsoft\StructType\DgQueue[]|null
     */
    public function getQueue()
    {
        return $this->Queue;
    }
    /**
     * Set Queue value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgQueue[] $queue
     * @return \dgsoft\StructType\DgQueueInfo
     */
    public function setQueue(array $queue = array())
    {
        foreach ($queue as $queueInfoQueueItem) {
            // validation for constraint: itemType
            if (!$queueInfoQueueItem instanceof \dgsoft\StructType\DgQueue) {
                throw new \InvalidArgumentException(sprintf('The Queue property can only contain items of \dgsoft\StructType\DgQueue, "%s" given', is_object($queueInfoQueueItem) ? get_class($queueInfoQueueItem) : gettype($queueInfoQueueItem)), __LINE__);
            }
        }
        $this->Queue = $queue;
        return $this;
    }
    /**
     * Add item to Queue value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgQueue $item
     * @return \dgsoft\StructType\DgQueueInfo
     */
    public function addToQueue(\dgsoft\StructType\DgQueue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgQueue) {
            throw new \InvalidArgumentException(sprintf('The Queue property can only contain items of \dgsoft\StructType\DgQueue, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Queue[] = $item;
        return $this;
    }
    /**
     * Get FirstItemOnlyInd value
     * @return bool|null
     */
    public function getFirstItemOnlyInd()
    {
        return $this->FirstItemOnlyInd;
    }
    /**
     * Set FirstItemOnlyInd value
     * @param bool $firstItemOnlyInd
     * @return \dgsoft\StructType\DgQueueInfo
     */
    public function setFirstItemOnlyInd($firstItemOnlyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($firstItemOnlyInd) && !is_bool($firstItemOnlyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($firstItemOnlyInd)), __LINE__);
        }
        $this->FirstItemOnlyInd = $firstItemOnlyInd;
        return $this;
    }
    /**
     * Get RemoveFromQueueInd value
     * @return bool|null
     */
    public function getRemoveFromQueueInd()
    {
        return $this->RemoveFromQueueInd;
    }
    /**
     * Set RemoveFromQueueInd value
     * @param bool $removeFromQueueInd
     * @return \dgsoft\StructType\DgQueueInfo
     */
    public function setRemoveFromQueueInd($removeFromQueueInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($removeFromQueueInd) && !is_bool($removeFromQueueInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($removeFromQueueInd)), __LINE__);
        }
        $this->RemoveFromQueueInd = $removeFromQueueInd;
        return $this;
    }
    /**
     * Get FullDataInd value
     * @return bool|null
     */
    public function getFullDataInd()
    {
        return $this->FullDataInd;
    }
    /**
     * Set FullDataInd value
     * @param bool $fullDataInd
     * @return \dgsoft\StructType\DgQueueInfo
     */
    public function setFullDataInd($fullDataInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($fullDataInd) && !is_bool($fullDataInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fullDataInd)), __LINE__);
        }
        $this->FullDataInd = $fullDataInd;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \dgsoft\StructType\DgQueueInfo
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \dgsoft\StructType\DgQueueInfo
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgQueueInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
