<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueSetting StructType
 * @package Dg
 * @subpackage Structs
 */
class DgQueSetting extends AbstractStructBase
{
    /**
     * The QueNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $QueNo;
    /**
     * The QueCategoryNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $QueCategoryNo;
    /**
     * The OfficeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OfficeID;
    /**
     * Constructor method for QueSetting
     * @uses DgQueSetting::setQueNo()
     * @uses DgQueSetting::setQueCategoryNo()
     * @uses DgQueSetting::setOfficeID()
     * @param int $queNo
     * @param int $queCategoryNo
     * @param string $officeID
     */
    public function __construct($queNo = null, $queCategoryNo = null, $officeID = null)
    {
        $this
            ->setQueNo($queNo)
            ->setQueCategoryNo($queCategoryNo)
            ->setOfficeID($officeID);
    }
    /**
     * Get QueNo value
     * @return int
     */
    public function getQueNo()
    {
        return $this->QueNo;
    }
    /**
     * Set QueNo value
     * @param int $queNo
     * @return \dgsoft\StructType\DgQueSetting
     */
    public function setQueNo($queNo = null)
    {
        // validation for constraint: int
        if (!is_null($queNo) && !is_numeric($queNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($queNo)), __LINE__);
        }
        $this->QueNo = $queNo;
        return $this;
    }
    /**
     * Get QueCategoryNo value
     * @return int
     */
    public function getQueCategoryNo()
    {
        return $this->QueCategoryNo;
    }
    /**
     * Set QueCategoryNo value
     * @param int $queCategoryNo
     * @return \dgsoft\StructType\DgQueSetting
     */
    public function setQueCategoryNo($queCategoryNo = null)
    {
        // validation for constraint: int
        if (!is_null($queCategoryNo) && !is_numeric($queCategoryNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($queCategoryNo)), __LINE__);
        }
        $this->QueCategoryNo = $queCategoryNo;
        return $this;
    }
    /**
     * Get OfficeID value
     * @return string|null
     */
    public function getOfficeID()
    {
        return $this->OfficeID;
    }
    /**
     * Set OfficeID value
     * @param string $officeID
     * @return \dgsoft\StructType\DgQueSetting
     */
    public function setOfficeID($officeID = null)
    {
        // validation for constraint: string
        if (!is_null($officeID) && !is_string($officeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($officeID)), __LINE__);
        }
        $this->OfficeID = $officeID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgQueSetting
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
