<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfileType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgProfileType extends AbstractStructBase
{
    /**
     * The Accesses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAccessesType
     */
    public $Accesses;
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCustomerType
     */
    public $Customer;
    /**
     * The PrefCollections
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPreferencesType
     */
    public $PrefCollections;
    /**
     * The CompanyInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyInfoType
     */
    public $CompanyInfo;
    /**
     * The Affiliations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAffiliationsType
     */
    public $Affiliations;
    /**
     * The Agreements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAgreementsType
     */
    public $Agreements;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfCommentTypeComment
     */
    public $Comments;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The ShareAllSynchInd
     * Meta informations extracted from the WSDL
     * - default: No
     * @var string
     */
    public $ShareAllSynchInd;
    /**
     * The ShareAllMarketInd
     * Meta informations extracted from the WSDL
     * - default: No
     * @var string
     */
    public $ShareAllMarketInd;
    /**
     * The ProfileType
     * @var string
     */
    public $ProfileType;
    /**
     * The CreateDateTime
     * @var string
     */
    public $CreateDateTime;
    /**
     * The CreatorID
     * @var string
     */
    public $CreatorID;
    /**
     * The LastModifyDateTime
     * @var string
     */
    public $LastModifyDateTime;
    /**
     * The LastModifierID
     * @var string
     */
    public $LastModifierID;
    /**
     * The PurgeDate
     * @var string
     */
    public $PurgeDate;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for ProfileType
     * @uses DgProfileType::setAccesses()
     * @uses DgProfileType::setCustomer()
     * @uses DgProfileType::setPrefCollections()
     * @uses DgProfileType::setCompanyInfo()
     * @uses DgProfileType::setAffiliations()
     * @uses DgProfileType::setAgreements()
     * @uses DgProfileType::setComments()
     * @uses DgProfileType::setTPA_Extensions()
     * @uses DgProfileType::setShareAllSynchInd()
     * @uses DgProfileType::setShareAllMarketInd()
     * @uses DgProfileType::setProfileType()
     * @uses DgProfileType::setCreateDateTime()
     * @uses DgProfileType::setCreatorID()
     * @uses DgProfileType::setLastModifyDateTime()
     * @uses DgProfileType::setLastModifierID()
     * @uses DgProfileType::setPurgeDate()
     * @uses DgProfileType::setRPH()
     * @param \dgsoft\StructType\DgAccessesType $accesses
     * @param \dgsoft\StructType\DgCustomerType $customer
     * @param \dgsoft\StructType\DgPreferencesType $prefCollections
     * @param \dgsoft\StructType\DgCompanyInfoType $companyInfo
     * @param \dgsoft\StructType\DgAffiliationsType $affiliations
     * @param \dgsoft\StructType\DgAgreementsType $agreements
     * @param \dgsoft\ArrayType\DgArrayOfCommentTypeComment $comments
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param string $shareAllSynchInd
     * @param string $shareAllMarketInd
     * @param string $profileType
     * @param string $createDateTime
     * @param string $creatorID
     * @param string $lastModifyDateTime
     * @param string $lastModifierID
     * @param string $purgeDate
     * @param string $rPH
     */
    public function __construct(\dgsoft\StructType\DgAccessesType $accesses = null, \dgsoft\StructType\DgCustomerType $customer = null, \dgsoft\StructType\DgPreferencesType $prefCollections = null, \dgsoft\StructType\DgCompanyInfoType $companyInfo = null, \dgsoft\StructType\DgAffiliationsType $affiliations = null, \dgsoft\StructType\DgAgreementsType $agreements = null, \dgsoft\ArrayType\DgArrayOfCommentTypeComment $comments = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $shareAllSynchInd = 'No', $shareAllMarketInd = 'No', $profileType = null, $createDateTime = null, $creatorID = null, $lastModifyDateTime = null, $lastModifierID = null, $purgeDate = null, $rPH = null)
    {
        $this
            ->setAccesses($accesses)
            ->setCustomer($customer)
            ->setPrefCollections($prefCollections)
            ->setCompanyInfo($companyInfo)
            ->setAffiliations($affiliations)
            ->setAgreements($agreements)
            ->setComments($comments)
            ->setTPA_Extensions($tPA_Extensions)
            ->setShareAllSynchInd($shareAllSynchInd)
            ->setShareAllMarketInd($shareAllMarketInd)
            ->setProfileType($profileType)
            ->setCreateDateTime($createDateTime)
            ->setCreatorID($creatorID)
            ->setLastModifyDateTime($lastModifyDateTime)
            ->setLastModifierID($lastModifierID)
            ->setPurgeDate($purgeDate)
            ->setRPH($rPH);
    }
    /**
     * Get Accesses value
     * @return \dgsoft\StructType\DgAccessesType|null
     */
    public function getAccesses()
    {
        return $this->Accesses;
    }
    /**
     * Set Accesses value
     * @param \dgsoft\StructType\DgAccessesType $accesses
     * @return \dgsoft\StructType\DgProfileType
     */
    public function setAccesses(\dgsoft\StructType\DgAccessesType $accesses = null)
    {
        $this->Accesses = $accesses;
        return $this;
    }
    /**
     * Get Customer value
     * @return \dgsoft\StructType\DgCustomerType|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \dgsoft\StructType\DgCustomerType $customer
     * @return \dgsoft\StructType\DgProfileType
     */
    public function setCustomer(\dgsoft\StructType\DgCustomerType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get PrefCollections value
     * @return \dgsoft\StructType\DgPreferencesType|null
     */
    public function getPrefCollections()
    {
        return $this->PrefCollections;
    }
    /**
     * Set PrefCollections value
     * @param \dgsoft\StructType\DgPreferencesType $prefCollections
     * @return \dgsoft\StructType\DgProfileType
     */
    public function setPrefCollections(\dgsoft\StructType\DgPreferencesType $prefCollections = null)
    {
        $this->PrefCollections = $prefCollections;
        return $this;
    }
    /**
     * Get CompanyInfo value
     * @return \dgsoft\StructType\DgCompanyInfoType|null
     */
    public function getCompanyInfo()
    {
        return $this->CompanyInfo;
    }
    /**
     * Set CompanyInfo value
     * @param \dgsoft\StructType\DgCompanyInfoType $companyInfo
     * @return \dgsoft\StructType\DgProfileType
     */
    public function setCompanyInfo(\dgsoft\StructType\DgCompanyInfoType $companyInfo = null)
    {
        $this->CompanyInfo = $companyInfo;
        return $this;
    }
    /**
     * Get Affiliations value
     * @return \dgsoft\StructType\DgAffiliationsType|null
     */
    public function getAffiliations()
    {
        return $this->Affiliations;
    }
    /**
     * Set Affiliations value
     * @param \dgsoft\StructType\DgAffiliationsType $affiliations
     * @return \dgsoft\StructType\DgProfileType
     */
    public function setAffiliations(\dgsoft\StructType\DgAffiliationsType $affiliations = null)
    {
        $this->Affiliations = $affiliations;
        return $this;
    }
    /**
     * Get Agreements value
     * @return \dgsoft\StructType\DgAgreementsType|null
     */
    public function getAgreements()
    {
        return $this->Agreements;
    }
    /**
     * Set Agreements value
     * @param \dgsoft\StructType\DgAgreementsType $agreements
     * @return \dgsoft\StructType\DgProfileType
     */
    public function setAgreements(\dgsoft\StructType\DgAgreementsType $agreements = null)
    {
        $this->Agreements = $agreements;
        return $this;
    }
    /**
     * Get Comments value
     * @return \dgsoft\ArrayType\DgArrayOfCommentTypeComment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \dgsoft\ArrayType\DgArrayOfCommentTypeComment $comments
     * @return \dgsoft\StructType\DgProfileType
     */
    public function setComments(\dgsoft\ArrayType\DgArrayOfCommentTypeComment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgProfileType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ShareAllSynchInd value
     * @return string|null
     */
    public function getShareAllSynchInd()
    {
        return $this->ShareAllSynchInd;
    }
    /**
     * Set ShareAllSynchInd value
     * @uses \dgsoft\EnumType\DgYesNoType::valueIsValid()
     * @uses \dgsoft\EnumType\DgYesNoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shareAllSynchInd
     * @return \dgsoft\StructType\DgProfileType
     */
    public function setShareAllSynchInd($shareAllSynchInd = 'No')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgYesNoType::valueIsValid($shareAllSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $shareAllSynchInd, implode(', ', \dgsoft\EnumType\DgYesNoType::getValidValues())), __LINE__);
        }
        $this->ShareAllSynchInd = $shareAllSynchInd;
        return $this;
    }
    /**
     * Get ShareAllMarketInd value
     * @return string|null
     */
    public function getShareAllMarketInd()
    {
        return $this->ShareAllMarketInd;
    }
    /**
     * Set ShareAllMarketInd value
     * @uses \dgsoft\EnumType\DgYesNoType::valueIsValid()
     * @uses \dgsoft\EnumType\DgYesNoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shareAllMarketInd
     * @return \dgsoft\StructType\DgProfileType
     */
    public function setShareAllMarketInd($shareAllMarketInd = 'No')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgYesNoType::valueIsValid($shareAllMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $shareAllMarketInd, implode(', ', \dgsoft\EnumType\DgYesNoType::getValidValues())), __LINE__);
        }
        $this->ShareAllMarketInd = $shareAllMarketInd;
        return $this;
    }
    /**
     * Get ProfileType value
     * @return string|null
     */
    public function getProfileType()
    {
        return $this->ProfileType;
    }
    /**
     * Set ProfileType value
     * @param string $profileType
     * @return \dgsoft\StructType\DgProfileType
     */
    public function setProfileType($profileType = null)
    {
        // validation for constraint: string
        if (!is_null($profileType) && !is_string($profileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profileType)), __LINE__);
        }
        $this->ProfileType = $profileType;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \dgsoft\StructType\DgProfileType
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Get CreatorID value
     * @return string|null
     */
    public function getCreatorID()
    {
        return $this->CreatorID;
    }
    /**
     * Set CreatorID value
     * @param string $creatorID
     * @return \dgsoft\StructType\DgProfileType
     */
    public function setCreatorID($creatorID = null)
    {
        // validation for constraint: string
        if (!is_null($creatorID) && !is_string($creatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creatorID)), __LINE__);
        }
        $this->CreatorID = $creatorID;
        return $this;
    }
    /**
     * Get LastModifyDateTime value
     * @return string|null
     */
    public function getLastModifyDateTime()
    {
        return $this->LastModifyDateTime;
    }
    /**
     * Set LastModifyDateTime value
     * @param string $lastModifyDateTime
     * @return \dgsoft\StructType\DgProfileType
     */
    public function setLastModifyDateTime($lastModifyDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifyDateTime) && !is_string($lastModifyDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastModifyDateTime)), __LINE__);
        }
        $this->LastModifyDateTime = $lastModifyDateTime;
        return $this;
    }
    /**
     * Get LastModifierID value
     * @return string|null
     */
    public function getLastModifierID()
    {
        return $this->LastModifierID;
    }
    /**
     * Set LastModifierID value
     * @param string $lastModifierID
     * @return \dgsoft\StructType\DgProfileType
     */
    public function setLastModifierID($lastModifierID = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifierID) && !is_string($lastModifierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastModifierID)), __LINE__);
        }
        $this->LastModifierID = $lastModifierID;
        return $this;
    }
    /**
     * Get PurgeDate value
     * @return string|null
     */
    public function getPurgeDate()
    {
        return $this->PurgeDate;
    }
    /**
     * Set PurgeDate value
     * @param string $purgeDate
     * @return \dgsoft\StructType\DgProfileType
     */
    public function setPurgeDate($purgeDate = null)
    {
        // validation for constraint: string
        if (!is_null($purgeDate) && !is_string($purgeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($purgeDate)), __LINE__);
        }
        $this->PurgeDate = $purgeDate;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \dgsoft\StructType\DgProfileType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgProfileType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
