<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingUnit StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPricingUnit extends AbstractStructBase
{
    /**
     * The FareComponent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFareComponent[]
     */
    public $FareComponent;
    /**
     * The UnitNumber
     * @var int
     */
    public $UnitNumber;
    /**
     * Constructor method for PricingUnit
     * @uses DgPricingUnit::setFareComponent()
     * @uses DgPricingUnit::setUnitNumber()
     * @param \dgsoft\StructType\DgFareComponent[] $fareComponent
     * @param int $unitNumber
     */
    public function __construct(array $fareComponent = array(), $unitNumber = null)
    {
        $this
            ->setFareComponent($fareComponent)
            ->setUnitNumber($unitNumber);
    }
    /**
     * Get FareComponent value
     * @return \dgsoft\StructType\DgFareComponent[]|null
     */
    public function getFareComponent()
    {
        return $this->FareComponent;
    }
    /**
     * Set FareComponent value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareComponent[] $fareComponent
     * @return \dgsoft\StructType\DgPricingUnit
     */
    public function setFareComponent(array $fareComponent = array())
    {
        foreach ($fareComponent as $pricingUnitFareComponentItem) {
            // validation for constraint: itemType
            if (!$pricingUnitFareComponentItem instanceof \dgsoft\StructType\DgFareComponent) {
                throw new \InvalidArgumentException(sprintf('The FareComponent property can only contain items of \dgsoft\StructType\DgFareComponent, "%s" given', is_object($pricingUnitFareComponentItem) ? get_class($pricingUnitFareComponentItem) : gettype($pricingUnitFareComponentItem)), __LINE__);
            }
        }
        $this->FareComponent = $fareComponent;
        return $this;
    }
    /**
     * Add item to FareComponent value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareComponent $item
     * @return \dgsoft\StructType\DgPricingUnit
     */
    public function addToFareComponent(\dgsoft\StructType\DgFareComponent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFareComponent) {
            throw new \InvalidArgumentException(sprintf('The FareComponent property can only contain items of \dgsoft\StructType\DgFareComponent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FareComponent[] = $item;
        return $this;
    }
    /**
     * Get UnitNumber value
     * @return int|null
     */
    public function getUnitNumber()
    {
        return $this->UnitNumber;
    }
    /**
     * Set UnitNumber value
     * @param int $unitNumber
     * @return \dgsoft\StructType\DgPricingUnit
     */
    public function setUnitNumber($unitNumber = null)
    {
        // validation for constraint: int
        if (!is_null($unitNumber) && !is_numeric($unitNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unitNumber)), __LINE__);
        }
        $this->UnitNumber = $unitNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPricingUnit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
