<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingOverview StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPricingOverview extends AbstractStructBase
{
    /**
     * The PricingIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPricingIndicator[]
     */
    public $PricingIndicator;
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAccount[]
     */
    public $Account;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFreeTextType[]
     */
    public $Comment;
    /**
     * The StatisticalCode
     * @var string
     */
    public $StatisticalCode;
    /**
     * The ValidatingAirlineCode
     * @var string
     */
    public $ValidatingAirlineCode;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The PriceType
     * @var string
     */
    public $PriceType;
    /**
     * The NUC_Rate
     * @var float
     */
    public $NUC_Rate;
    /**
     * The ExchangeRate
     * @var float
     */
    public $ExchangeRate;
    /**
     * Constructor method for PricingOverview
     * @uses DgPricingOverview::setPricingIndicator()
     * @uses DgPricingOverview::setAccount()
     * @uses DgPricingOverview::setComment()
     * @uses DgPricingOverview::setStatisticalCode()
     * @uses DgPricingOverview::setValidatingAirlineCode()
     * @uses DgPricingOverview::setDepartureDate()
     * @uses DgPricingOverview::setPriceType()
     * @uses DgPricingOverview::setNUC_Rate()
     * @uses DgPricingOverview::setExchangeRate()
     * @param \dgsoft\StructType\DgPricingIndicator[] $pricingIndicator
     * @param \dgsoft\StructType\DgAccount[] $account
     * @param \dgsoft\StructType\DgFreeTextType[] $comment
     * @param string $statisticalCode
     * @param string $validatingAirlineCode
     * @param string $departureDate
     * @param string $priceType
     * @param float $nUC_Rate
     * @param float $exchangeRate
     */
    public function __construct(array $pricingIndicator = array(), array $account = array(), array $comment = array(), $statisticalCode = null, $validatingAirlineCode = null, $departureDate = null, $priceType = null, $nUC_Rate = null, $exchangeRate = null)
    {
        $this
            ->setPricingIndicator($pricingIndicator)
            ->setAccount($account)
            ->setComment($comment)
            ->setStatisticalCode($statisticalCode)
            ->setValidatingAirlineCode($validatingAirlineCode)
            ->setDepartureDate($departureDate)
            ->setPriceType($priceType)
            ->setNUC_Rate($nUC_Rate)
            ->setExchangeRate($exchangeRate);
    }
    /**
     * Get PricingIndicator value
     * @return \dgsoft\StructType\DgPricingIndicator[]|null
     */
    public function getPricingIndicator()
    {
        return $this->PricingIndicator;
    }
    /**
     * Set PricingIndicator value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPricingIndicator[] $pricingIndicator
     * @return \dgsoft\StructType\DgPricingOverview
     */
    public function setPricingIndicator(array $pricingIndicator = array())
    {
        foreach ($pricingIndicator as $pricingOverviewPricingIndicatorItem) {
            // validation for constraint: itemType
            if (!$pricingOverviewPricingIndicatorItem instanceof \dgsoft\StructType\DgPricingIndicator) {
                throw new \InvalidArgumentException(sprintf('The PricingIndicator property can only contain items of \dgsoft\StructType\DgPricingIndicator, "%s" given', is_object($pricingOverviewPricingIndicatorItem) ? get_class($pricingOverviewPricingIndicatorItem) : gettype($pricingOverviewPricingIndicatorItem)), __LINE__);
            }
        }
        $this->PricingIndicator = $pricingIndicator;
        return $this;
    }
    /**
     * Add item to PricingIndicator value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPricingIndicator $item
     * @return \dgsoft\StructType\DgPricingOverview
     */
    public function addToPricingIndicator(\dgsoft\StructType\DgPricingIndicator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPricingIndicator) {
            throw new \InvalidArgumentException(sprintf('The PricingIndicator property can only contain items of \dgsoft\StructType\DgPricingIndicator, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PricingIndicator[] = $item;
        return $this;
    }
    /**
     * Get Account value
     * @return \dgsoft\StructType\DgAccount[]|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAccount[] $account
     * @return \dgsoft\StructType\DgPricingOverview
     */
    public function setAccount(array $account = array())
    {
        foreach ($account as $pricingOverviewAccountItem) {
            // validation for constraint: itemType
            if (!$pricingOverviewAccountItem instanceof \dgsoft\StructType\DgAccount) {
                throw new \InvalidArgumentException(sprintf('The Account property can only contain items of \dgsoft\StructType\DgAccount, "%s" given', is_object($pricingOverviewAccountItem) ? get_class($pricingOverviewAccountItem) : gettype($pricingOverviewAccountItem)), __LINE__);
            }
        }
        $this->Account = $account;
        return $this;
    }
    /**
     * Add item to Account value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAccount $item
     * @return \dgsoft\StructType\DgPricingOverview
     */
    public function addToAccount(\dgsoft\StructType\DgAccount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAccount) {
            throw new \InvalidArgumentException(sprintf('The Account property can only contain items of \dgsoft\StructType\DgAccount, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Account[] = $item;
        return $this;
    }
    /**
     * Get Comment value
     * @return \dgsoft\StructType\DgFreeTextType[]|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFreeTextType[] $comment
     * @return \dgsoft\StructType\DgPricingOverview
     */
    public function setComment(array $comment = array())
    {
        foreach ($comment as $pricingOverviewCommentItem) {
            // validation for constraint: itemType
            if (!$pricingOverviewCommentItem instanceof \dgsoft\StructType\DgFreeTextType) {
                throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of \dgsoft\StructType\DgFreeTextType, "%s" given', is_object($pricingOverviewCommentItem) ? get_class($pricingOverviewCommentItem) : gettype($pricingOverviewCommentItem)), __LINE__);
            }
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Add item to Comment value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFreeTextType $item
     * @return \dgsoft\StructType\DgPricingOverview
     */
    public function addToComment(\dgsoft\StructType\DgFreeTextType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFreeTextType) {
            throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of \dgsoft\StructType\DgFreeTextType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Comment[] = $item;
        return $this;
    }
    /**
     * Get StatisticalCode value
     * @return string|null
     */
    public function getStatisticalCode()
    {
        return $this->StatisticalCode;
    }
    /**
     * Set StatisticalCode value
     * @param string $statisticalCode
     * @return \dgsoft\StructType\DgPricingOverview
     */
    public function setStatisticalCode($statisticalCode = null)
    {
        // validation for constraint: string
        if (!is_null($statisticalCode) && !is_string($statisticalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statisticalCode)), __LINE__);
        }
        $this->StatisticalCode = $statisticalCode;
        return $this;
    }
    /**
     * Get ValidatingAirlineCode value
     * @return string|null
     */
    public function getValidatingAirlineCode()
    {
        return $this->ValidatingAirlineCode;
    }
    /**
     * Set ValidatingAirlineCode value
     * @param string $validatingAirlineCode
     * @return \dgsoft\StructType\DgPricingOverview
     */
    public function setValidatingAirlineCode($validatingAirlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($validatingAirlineCode) && !is_string($validatingAirlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validatingAirlineCode)), __LINE__);
        }
        $this->ValidatingAirlineCode = $validatingAirlineCode;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \dgsoft\StructType\DgPricingOverview
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get PriceType value
     * @return string|null
     */
    public function getPriceType()
    {
        return $this->PriceType;
    }
    /**
     * Set PriceType value
     * @param string $priceType
     * @return \dgsoft\StructType\DgPricingOverview
     */
    public function setPriceType($priceType = null)
    {
        // validation for constraint: string
        if (!is_null($priceType) && !is_string($priceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priceType)), __LINE__);
        }
        $this->PriceType = $priceType;
        return $this;
    }
    /**
     * Get NUC_Rate value
     * @return float|null
     */
    public function getNUC_Rate()
    {
        return $this->NUC_Rate;
    }
    /**
     * Set NUC_Rate value
     * @param float $nUC_Rate
     * @return \dgsoft\StructType\DgPricingOverview
     */
    public function setNUC_Rate($nUC_Rate = null)
    {
        $this->NUC_Rate = $nUC_Rate;
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \dgsoft\StructType\DgPricingOverview
     */
    public function setExchangeRate($exchangeRate = null)
    {
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPricingOverview
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
