<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricedItineraryType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPricedItineraryType extends AbstractStructBase
{
    /**
     * The AirItinerary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAirItineraryType
     */
    public $AirItinerary;
    /**
     * The AirItineraryPricingInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAirItineraryPricingInfoType
     */
    public $AirItineraryPricingInfo;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFreeTextType[]
     */
    public $Notes;
    /**
     * The TicketingInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTicketingInfo
     */
    public $TicketingInfo;
    /**
     * The IsOneWayCombinable
     * @var bool
     */
    public $IsOneWayCombinable;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The ProviderType
     * @var string
     */
    public $ProviderType;
    /**
     * The SequenceNumber
     * @var int
     */
    public $SequenceNumber;
    /**
     * Constructor method for PricedItineraryType
     * @uses DgPricedItineraryType::setAirItinerary()
     * @uses DgPricedItineraryType::setAirItineraryPricingInfo()
     * @uses DgPricedItineraryType::setNotes()
     * @uses DgPricedItineraryType::setTicketingInfo()
     * @uses DgPricedItineraryType::setIsOneWayCombinable()
     * @uses DgPricedItineraryType::setCurrency()
     * @uses DgPricedItineraryType::setProviderType()
     * @uses DgPricedItineraryType::setSequenceNumber()
     * @param \dgsoft\StructType\DgAirItineraryType $airItinerary
     * @param \dgsoft\StructType\DgAirItineraryPricingInfoType $airItineraryPricingInfo
     * @param \dgsoft\StructType\DgFreeTextType[] $notes
     * @param \dgsoft\StructType\DgTicketingInfo $ticketingInfo
     * @param bool $isOneWayCombinable
     * @param string $currency
     * @param string $providerType
     * @param int $sequenceNumber
     */
    public function __construct(\dgsoft\StructType\DgAirItineraryType $airItinerary = null, \dgsoft\StructType\DgAirItineraryPricingInfoType $airItineraryPricingInfo = null, array $notes = array(), \dgsoft\StructType\DgTicketingInfo $ticketingInfo = null, $isOneWayCombinable = null, $currency = null, $providerType = null, $sequenceNumber = null)
    {
        $this
            ->setAirItinerary($airItinerary)
            ->setAirItineraryPricingInfo($airItineraryPricingInfo)
            ->setNotes($notes)
            ->setTicketingInfo($ticketingInfo)
            ->setIsOneWayCombinable($isOneWayCombinable)
            ->setCurrency($currency)
            ->setProviderType($providerType)
            ->setSequenceNumber($sequenceNumber);
    }
    /**
     * Get AirItinerary value
     * @return \dgsoft\StructType\DgAirItineraryType|null
     */
    public function getAirItinerary()
    {
        return $this->AirItinerary;
    }
    /**
     * Set AirItinerary value
     * @param \dgsoft\StructType\DgAirItineraryType $airItinerary
     * @return \dgsoft\StructType\DgPricedItineraryType
     */
    public function setAirItinerary(\dgsoft\StructType\DgAirItineraryType $airItinerary = null)
    {
        $this->AirItinerary = $airItinerary;
        return $this;
    }
    /**
     * Get AirItineraryPricingInfo value
     * @return \dgsoft\StructType\DgAirItineraryPricingInfoType|null
     */
    public function getAirItineraryPricingInfo()
    {
        return $this->AirItineraryPricingInfo;
    }
    /**
     * Set AirItineraryPricingInfo value
     * @param \dgsoft\StructType\DgAirItineraryPricingInfoType $airItineraryPricingInfo
     * @return \dgsoft\StructType\DgPricedItineraryType
     */
    public function setAirItineraryPricingInfo(\dgsoft\StructType\DgAirItineraryPricingInfoType $airItineraryPricingInfo = null)
    {
        $this->AirItineraryPricingInfo = $airItineraryPricingInfo;
        return $this;
    }
    /**
     * Get Notes value
     * @return \dgsoft\StructType\DgFreeTextType[]|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFreeTextType[] $notes
     * @return \dgsoft\StructType\DgPricedItineraryType
     */
    public function setNotes(array $notes = array())
    {
        foreach ($notes as $pricedItineraryTypeNotesItem) {
            // validation for constraint: itemType
            if (!$pricedItineraryTypeNotesItem instanceof \dgsoft\StructType\DgFreeTextType) {
                throw new \InvalidArgumentException(sprintf('The Notes property can only contain items of \dgsoft\StructType\DgFreeTextType, "%s" given', is_object($pricedItineraryTypeNotesItem) ? get_class($pricedItineraryTypeNotesItem) : gettype($pricedItineraryTypeNotesItem)), __LINE__);
            }
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Add item to Notes value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFreeTextType $item
     * @return \dgsoft\StructType\DgPricedItineraryType
     */
    public function addToNotes(\dgsoft\StructType\DgFreeTextType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFreeTextType) {
            throw new \InvalidArgumentException(sprintf('The Notes property can only contain items of \dgsoft\StructType\DgFreeTextType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Notes[] = $item;
        return $this;
    }
    /**
     * Get TicketingInfo value
     * @return \dgsoft\StructType\DgTicketingInfo|null
     */
    public function getTicketingInfo()
    {
        return $this->TicketingInfo;
    }
    /**
     * Set TicketingInfo value
     * @param \dgsoft\StructType\DgTicketingInfo $ticketingInfo
     * @return \dgsoft\StructType\DgPricedItineraryType
     */
    public function setTicketingInfo(\dgsoft\StructType\DgTicketingInfo $ticketingInfo = null)
    {
        $this->TicketingInfo = $ticketingInfo;
        return $this;
    }
    /**
     * Get IsOneWayCombinable value
     * @return bool|null
     */
    public function getIsOneWayCombinable()
    {
        return $this->IsOneWayCombinable;
    }
    /**
     * Set IsOneWayCombinable value
     * @param bool $isOneWayCombinable
     * @return \dgsoft\StructType\DgPricedItineraryType
     */
    public function setIsOneWayCombinable($isOneWayCombinable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOneWayCombinable) && !is_bool($isOneWayCombinable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isOneWayCombinable)), __LINE__);
        }
        $this->IsOneWayCombinable = $isOneWayCombinable;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \dgsoft\StructType\DgPricedItineraryType
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get ProviderType value
     * @return string|null
     */
    public function getProviderType()
    {
        return $this->ProviderType;
    }
    /**
     * Set ProviderType value
     * @param string $providerType
     * @return \dgsoft\StructType\DgPricedItineraryType
     */
    public function setProviderType($providerType = null)
    {
        // validation for constraint: string
        if (!is_null($providerType) && !is_string($providerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($providerType)), __LINE__);
        }
        $this->ProviderType = $providerType;
        return $this;
    }
    /**
     * Get SequenceNumber value
     * @return int|null
     */
    public function getSequenceNumber()
    {
        return $this->SequenceNumber;
    }
    /**
     * Set SequenceNumber value
     * @param int $sequenceNumber
     * @return \dgsoft\StructType\DgPricedItineraryType
     */
    public function setSequenceNumber($sequenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNumber) && !is_numeric($sequenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNumber)), __LINE__);
        }
        $this->SequenceNumber = $sequenceNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPricedItineraryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
