<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricedItinerary StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPricedItinerary extends DgPricedItineraryType
{
    /**
     * The OriginDestinationRefNumber
     * @var int
     */
    public $OriginDestinationRefNumber;
    /**
     * Constructor method for PricedItinerary
     * @uses DgPricedItinerary::setOriginDestinationRefNumber()
     * @param int $originDestinationRefNumber
     */
    public function __construct($originDestinationRefNumber = null)
    {
        $this
            ->setOriginDestinationRefNumber($originDestinationRefNumber);
    }
    /**
     * Get OriginDestinationRefNumber value
     * @return int|null
     */
    public function getOriginDestinationRefNumber()
    {
        return $this->OriginDestinationRefNumber;
    }
    /**
     * Set OriginDestinationRefNumber value
     * @param int $originDestinationRefNumber
     * @return \dgsoft\StructType\DgPricedItinerary
     */
    public function setOriginDestinationRefNumber($originDestinationRefNumber = null)
    {
        // validation for constraint: int
        if (!is_null($originDestinationRefNumber) && !is_numeric($originDestinationRefNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($originDestinationRefNumber)), __LINE__);
        }
        $this->OriginDestinationRefNumber = $originDestinationRefNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPricedItinerary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
