<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricedItinerariesType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPricedItinerariesType extends AbstractStructBase
{
    /**
     * The PricedItinerary
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPricedItinerary[]
     */
    public $PricedItinerary;
    /**
     * The PricedItineraryForOWC
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPricedItineraryForOWC[]
     */
    public $PricedItineraryForOWC;
    /**
     * The MyProperty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MyProperty;
    /**
     * The FreeBaggages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfFreeBaggageLegendItem
     */
    public $FreeBaggages;
    /**
     * The ConnectedOperatingAirlines
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfConnectedOperatingAirline
     */
    public $ConnectedOperatingAirlines;
    /**
     * Constructor method for PricedItinerariesType
     * @uses DgPricedItinerariesType::setPricedItinerary()
     * @uses DgPricedItinerariesType::setPricedItineraryForOWC()
     * @uses DgPricedItinerariesType::setMyProperty()
     * @uses DgPricedItinerariesType::setFreeBaggages()
     * @uses DgPricedItinerariesType::setConnectedOperatingAirlines()
     * @param \dgsoft\StructType\DgPricedItinerary[] $pricedItinerary
     * @param \dgsoft\StructType\DgPricedItineraryForOWC[] $pricedItineraryForOWC
     * @param string $myProperty
     * @param \dgsoft\ArrayType\DgArrayOfFreeBaggageLegendItem $freeBaggages
     * @param \dgsoft\ArrayType\DgArrayOfConnectedOperatingAirline $connectedOperatingAirlines
     */
    public function __construct(array $pricedItinerary = array(), array $pricedItineraryForOWC = array(), $myProperty = null, \dgsoft\ArrayType\DgArrayOfFreeBaggageLegendItem $freeBaggages = null, \dgsoft\ArrayType\DgArrayOfConnectedOperatingAirline $connectedOperatingAirlines = null)
    {
        $this
            ->setPricedItinerary($pricedItinerary)
            ->setPricedItineraryForOWC($pricedItineraryForOWC)
            ->setMyProperty($myProperty)
            ->setFreeBaggages($freeBaggages)
            ->setConnectedOperatingAirlines($connectedOperatingAirlines);
    }
    /**
     * Get PricedItinerary value
     * @return \dgsoft\StructType\DgPricedItinerary[]|null
     */
    public function getPricedItinerary()
    {
        return $this->PricedItinerary;
    }
    /**
     * Set PricedItinerary value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPricedItinerary[] $pricedItinerary
     * @return \dgsoft\StructType\DgPricedItinerariesType
     */
    public function setPricedItinerary(array $pricedItinerary = array())
    {
        foreach ($pricedItinerary as $pricedItinerariesTypePricedItineraryItem) {
            // validation for constraint: itemType
            if (!$pricedItinerariesTypePricedItineraryItem instanceof \dgsoft\StructType\DgPricedItinerary) {
                throw new \InvalidArgumentException(sprintf('The PricedItinerary property can only contain items of \dgsoft\StructType\DgPricedItinerary, "%s" given', is_object($pricedItinerariesTypePricedItineraryItem) ? get_class($pricedItinerariesTypePricedItineraryItem) : gettype($pricedItinerariesTypePricedItineraryItem)), __LINE__);
            }
        }
        $this->PricedItinerary = $pricedItinerary;
        return $this;
    }
    /**
     * Add item to PricedItinerary value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPricedItinerary $item
     * @return \dgsoft\StructType\DgPricedItinerariesType
     */
    public function addToPricedItinerary(\dgsoft\StructType\DgPricedItinerary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPricedItinerary) {
            throw new \InvalidArgumentException(sprintf('The PricedItinerary property can only contain items of \dgsoft\StructType\DgPricedItinerary, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PricedItinerary[] = $item;
        return $this;
    }
    /**
     * Get PricedItineraryForOWC value
     * @return \dgsoft\StructType\DgPricedItineraryForOWC[]|null
     */
    public function getPricedItineraryForOWC()
    {
        return $this->PricedItineraryForOWC;
    }
    /**
     * Set PricedItineraryForOWC value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPricedItineraryForOWC[] $pricedItineraryForOWC
     * @return \dgsoft\StructType\DgPricedItinerariesType
     */
    public function setPricedItineraryForOWC(array $pricedItineraryForOWC = array())
    {
        foreach ($pricedItineraryForOWC as $pricedItinerariesTypePricedItineraryForOWCItem) {
            // validation for constraint: itemType
            if (!$pricedItinerariesTypePricedItineraryForOWCItem instanceof \dgsoft\StructType\DgPricedItineraryForOWC) {
                throw new \InvalidArgumentException(sprintf('The PricedItineraryForOWC property can only contain items of \dgsoft\StructType\DgPricedItineraryForOWC, "%s" given', is_object($pricedItinerariesTypePricedItineraryForOWCItem) ? get_class($pricedItinerariesTypePricedItineraryForOWCItem) : gettype($pricedItinerariesTypePricedItineraryForOWCItem)), __LINE__);
            }
        }
        $this->PricedItineraryForOWC = $pricedItineraryForOWC;
        return $this;
    }
    /**
     * Add item to PricedItineraryForOWC value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPricedItineraryForOWC $item
     * @return \dgsoft\StructType\DgPricedItinerariesType
     */
    public function addToPricedItineraryForOWC(\dgsoft\StructType\DgPricedItineraryForOWC $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPricedItineraryForOWC) {
            throw new \InvalidArgumentException(sprintf('The PricedItineraryForOWC property can only contain items of \dgsoft\StructType\DgPricedItineraryForOWC, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PricedItineraryForOWC[] = $item;
        return $this;
    }
    /**
     * Get MyProperty value
     * @return string|null
     */
    public function getMyProperty()
    {
        return $this->MyProperty;
    }
    /**
     * Set MyProperty value
     * @param string $myProperty
     * @return \dgsoft\StructType\DgPricedItinerariesType
     */
    public function setMyProperty($myProperty = null)
    {
        // validation for constraint: string
        if (!is_null($myProperty) && !is_string($myProperty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($myProperty)), __LINE__);
        }
        $this->MyProperty = $myProperty;
        return $this;
    }
    /**
     * Get FreeBaggages value
     * @return \dgsoft\ArrayType\DgArrayOfFreeBaggageLegendItem|null
     */
    public function getFreeBaggages()
    {
        return $this->FreeBaggages;
    }
    /**
     * Set FreeBaggages value
     * @param \dgsoft\ArrayType\DgArrayOfFreeBaggageLegendItem $freeBaggages
     * @return \dgsoft\StructType\DgPricedItinerariesType
     */
    public function setFreeBaggages(\dgsoft\ArrayType\DgArrayOfFreeBaggageLegendItem $freeBaggages = null)
    {
        $this->FreeBaggages = $freeBaggages;
        return $this;
    }
    /**
     * Get ConnectedOperatingAirlines value
     * @return \dgsoft\ArrayType\DgArrayOfConnectedOperatingAirline|null
     */
    public function getConnectedOperatingAirlines()
    {
        return $this->ConnectedOperatingAirlines;
    }
    /**
     * Set ConnectedOperatingAirlines value
     * @param \dgsoft\ArrayType\DgArrayOfConnectedOperatingAirline $connectedOperatingAirlines
     * @return \dgsoft\StructType\DgPricedItinerariesType
     */
    public function setConnectedOperatingAirlines(\dgsoft\ArrayType\DgArrayOfConnectedOperatingAirline $connectedOperatingAirlines = null)
    {
        $this->ConnectedOperatingAirlines = $connectedOperatingAirlines;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPricedItinerariesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
