<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceInfo StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPriceInfo extends DgBookingPriceInfoType
{
    /**
     * The PricingPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPricingPref[]
     */
    public $PricingPref;
    /**
     * The ParticipationLevel
     * @var string
     */
    public $ParticipationLevel;
    /**
     * Constructor method for PriceInfo
     * @uses DgPriceInfo::setPricingPref()
     * @uses DgPriceInfo::setParticipationLevel()
     * @param \dgsoft\StructType\DgPricingPref[] $pricingPref
     * @param string $participationLevel
     */
    public function __construct(array $pricingPref = array(), $participationLevel = null)
    {
        $this
            ->setPricingPref($pricingPref)
            ->setParticipationLevel($participationLevel);
    }
    /**
     * Get PricingPref value
     * @return \dgsoft\StructType\DgPricingPref[]|null
     */
    public function getPricingPref()
    {
        return $this->PricingPref;
    }
    /**
     * Set PricingPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPricingPref[] $pricingPref
     * @return \dgsoft\StructType\DgPriceInfo
     */
    public function setPricingPref(array $pricingPref = array())
    {
        foreach ($pricingPref as $priceInfoPricingPrefItem) {
            // validation for constraint: itemType
            if (!$priceInfoPricingPrefItem instanceof \dgsoft\StructType\DgPricingPref) {
                throw new \InvalidArgumentException(sprintf('The PricingPref property can only contain items of \dgsoft\StructType\DgPricingPref, "%s" given', is_object($priceInfoPricingPrefItem) ? get_class($priceInfoPricingPrefItem) : gettype($priceInfoPricingPrefItem)), __LINE__);
            }
        }
        $this->PricingPref = $pricingPref;
        return $this;
    }
    /**
     * Add item to PricingPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPricingPref $item
     * @return \dgsoft\StructType\DgPriceInfo
     */
    public function addToPricingPref(\dgsoft\StructType\DgPricingPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPricingPref) {
            throw new \InvalidArgumentException(sprintf('The PricingPref property can only contain items of \dgsoft\StructType\DgPricingPref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PricingPref[] = $item;
        return $this;
    }
    /**
     * Get ParticipationLevel value
     * @return string|null
     */
    public function getParticipationLevel()
    {
        return $this->ParticipationLevel;
    }
    /**
     * Set ParticipationLevel value
     * @param string $participationLevel
     * @return \dgsoft\StructType\DgPriceInfo
     */
    public function setParticipationLevel($participationLevel = null)
    {
        // validation for constraint: string
        if (!is_null($participationLevel) && !is_string($participationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($participationLevel)), __LINE__);
        }
        $this->ParticipationLevel = $participationLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPriceInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
