<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreferencesType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPreferencesType extends AbstractStructBase
{
    /**
     * The PrefCollection
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPrefCollection[]
     */
    public $PrefCollection;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * Constructor method for PreferencesType
     * @uses DgPreferencesType::setPrefCollection()
     * @uses DgPreferencesType::setShareSynchInd()
     * @uses DgPreferencesType::setShareMarketInd()
     * @param \dgsoft\StructType\DgPrefCollection[] $prefCollection
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     */
    public function __construct(array $prefCollection = array(), $shareSynchInd = null, $shareMarketInd = null)
    {
        $this
            ->setPrefCollection($prefCollection)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd);
    }
    /**
     * Get PrefCollection value
     * @return \dgsoft\StructType\DgPrefCollection[]|null
     */
    public function getPrefCollection()
    {
        return $this->PrefCollection;
    }
    /**
     * Set PrefCollection value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPrefCollection[] $prefCollection
     * @return \dgsoft\StructType\DgPreferencesType
     */
    public function setPrefCollection(array $prefCollection = array())
    {
        foreach ($prefCollection as $preferencesTypePrefCollectionItem) {
            // validation for constraint: itemType
            if (!$preferencesTypePrefCollectionItem instanceof \dgsoft\StructType\DgPrefCollection) {
                throw new \InvalidArgumentException(sprintf('The PrefCollection property can only contain items of \dgsoft\StructType\DgPrefCollection, "%s" given', is_object($preferencesTypePrefCollectionItem) ? get_class($preferencesTypePrefCollectionItem) : gettype($preferencesTypePrefCollectionItem)), __LINE__);
            }
        }
        $this->PrefCollection = $prefCollection;
        return $this;
    }
    /**
     * Add item to PrefCollection value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPrefCollection $item
     * @return \dgsoft\StructType\DgPreferencesType
     */
    public function addToPrefCollection(\dgsoft\StructType\DgPrefCollection $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPrefCollection) {
            throw new \InvalidArgumentException(sprintf('The PrefCollection property can only contain items of \dgsoft\StructType\DgPrefCollection, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PrefCollection[] = $item;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \dgsoft\StructType\DgPreferencesType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \dgsoft\StructType\DgPreferencesType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPreferencesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
