<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrefCollection StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPrefCollection extends AbstractStructBase
{
    /**
     * The CommonPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCommonPrefType[]
     */
    public $CommonPref;
    /**
     * The VehicleRentalPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleProfileRentalPrefType[]
     */
    public $VehicleRentalPref;
    /**
     * The AirlinePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAirlinePrefType[]
     */
    public $AirlinePref;
    /**
     * The HotelPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgHotelPrefType[]
     */
    public $HotelPref;
    /**
     * The OtherSrvcPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOtherSrvcPrefType[]
     */
    public $OtherSrvcPref;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The TravelPurpose
     * @var string
     */
    public $TravelPurpose;
    /**
     * Constructor method for PrefCollection
     * @uses DgPrefCollection::setCommonPref()
     * @uses DgPrefCollection::setVehicleRentalPref()
     * @uses DgPrefCollection::setAirlinePref()
     * @uses DgPrefCollection::setHotelPref()
     * @uses DgPrefCollection::setOtherSrvcPref()
     * @uses DgPrefCollection::setTPA_Extensions()
     * @uses DgPrefCollection::setShareSynchInd()
     * @uses DgPrefCollection::setShareMarketInd()
     * @uses DgPrefCollection::setTravelPurpose()
     * @param \dgsoft\StructType\DgCommonPrefType[] $commonPref
     * @param \dgsoft\StructType\DgVehicleProfileRentalPrefType[] $vehicleRentalPref
     * @param \dgsoft\StructType\DgAirlinePrefType[] $airlinePref
     * @param \dgsoft\StructType\DgHotelPrefType[] $hotelPref
     * @param \dgsoft\StructType\DgOtherSrvcPrefType[] $otherSrvcPref
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $travelPurpose
     */
    public function __construct(array $commonPref = array(), array $vehicleRentalPref = array(), array $airlinePref = array(), array $hotelPref = array(), array $otherSrvcPref = array(), \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $shareSynchInd = null, $shareMarketInd = null, $travelPurpose = null)
    {
        $this
            ->setCommonPref($commonPref)
            ->setVehicleRentalPref($vehicleRentalPref)
            ->setAirlinePref($airlinePref)
            ->setHotelPref($hotelPref)
            ->setOtherSrvcPref($otherSrvcPref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setTravelPurpose($travelPurpose);
    }
    /**
     * Get CommonPref value
     * @return \dgsoft\StructType\DgCommonPrefType[]|null
     */
    public function getCommonPref()
    {
        return $this->CommonPref;
    }
    /**
     * Set CommonPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCommonPrefType[] $commonPref
     * @return \dgsoft\StructType\DgPrefCollection
     */
    public function setCommonPref(array $commonPref = array())
    {
        foreach ($commonPref as $prefCollectionCommonPrefItem) {
            // validation for constraint: itemType
            if (!$prefCollectionCommonPrefItem instanceof \dgsoft\StructType\DgCommonPrefType) {
                throw new \InvalidArgumentException(sprintf('The CommonPref property can only contain items of \dgsoft\StructType\DgCommonPrefType, "%s" given', is_object($prefCollectionCommonPrefItem) ? get_class($prefCollectionCommonPrefItem) : gettype($prefCollectionCommonPrefItem)), __LINE__);
            }
        }
        $this->CommonPref = $commonPref;
        return $this;
    }
    /**
     * Add item to CommonPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCommonPrefType $item
     * @return \dgsoft\StructType\DgPrefCollection
     */
    public function addToCommonPref(\dgsoft\StructType\DgCommonPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCommonPrefType) {
            throw new \InvalidArgumentException(sprintf('The CommonPref property can only contain items of \dgsoft\StructType\DgCommonPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CommonPref[] = $item;
        return $this;
    }
    /**
     * Get VehicleRentalPref value
     * @return \dgsoft\StructType\DgVehicleProfileRentalPrefType[]|null
     */
    public function getVehicleRentalPref()
    {
        return $this->VehicleRentalPref;
    }
    /**
     * Set VehicleRentalPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleProfileRentalPrefType[] $vehicleRentalPref
     * @return \dgsoft\StructType\DgPrefCollection
     */
    public function setVehicleRentalPref(array $vehicleRentalPref = array())
    {
        foreach ($vehicleRentalPref as $prefCollectionVehicleRentalPrefItem) {
            // validation for constraint: itemType
            if (!$prefCollectionVehicleRentalPrefItem instanceof \dgsoft\StructType\DgVehicleProfileRentalPrefType) {
                throw new \InvalidArgumentException(sprintf('The VehicleRentalPref property can only contain items of \dgsoft\StructType\DgVehicleProfileRentalPrefType, "%s" given', is_object($prefCollectionVehicleRentalPrefItem) ? get_class($prefCollectionVehicleRentalPrefItem) : gettype($prefCollectionVehicleRentalPrefItem)), __LINE__);
            }
        }
        $this->VehicleRentalPref = $vehicleRentalPref;
        return $this;
    }
    /**
     * Add item to VehicleRentalPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVehicleProfileRentalPrefType $item
     * @return \dgsoft\StructType\DgPrefCollection
     */
    public function addToVehicleRentalPref(\dgsoft\StructType\DgVehicleProfileRentalPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVehicleProfileRentalPrefType) {
            throw new \InvalidArgumentException(sprintf('The VehicleRentalPref property can only contain items of \dgsoft\StructType\DgVehicleProfileRentalPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehicleRentalPref[] = $item;
        return $this;
    }
    /**
     * Get AirlinePref value
     * @return \dgsoft\StructType\DgAirlinePrefType[]|null
     */
    public function getAirlinePref()
    {
        return $this->AirlinePref;
    }
    /**
     * Set AirlinePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAirlinePrefType[] $airlinePref
     * @return \dgsoft\StructType\DgPrefCollection
     */
    public function setAirlinePref(array $airlinePref = array())
    {
        foreach ($airlinePref as $prefCollectionAirlinePrefItem) {
            // validation for constraint: itemType
            if (!$prefCollectionAirlinePrefItem instanceof \dgsoft\StructType\DgAirlinePrefType) {
                throw new \InvalidArgumentException(sprintf('The AirlinePref property can only contain items of \dgsoft\StructType\DgAirlinePrefType, "%s" given', is_object($prefCollectionAirlinePrefItem) ? get_class($prefCollectionAirlinePrefItem) : gettype($prefCollectionAirlinePrefItem)), __LINE__);
            }
        }
        $this->AirlinePref = $airlinePref;
        return $this;
    }
    /**
     * Add item to AirlinePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAirlinePrefType $item
     * @return \dgsoft\StructType\DgPrefCollection
     */
    public function addToAirlinePref(\dgsoft\StructType\DgAirlinePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAirlinePrefType) {
            throw new \InvalidArgumentException(sprintf('The AirlinePref property can only contain items of \dgsoft\StructType\DgAirlinePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AirlinePref[] = $item;
        return $this;
    }
    /**
     * Get HotelPref value
     * @return \dgsoft\StructType\DgHotelPrefType[]|null
     */
    public function getHotelPref()
    {
        return $this->HotelPref;
    }
    /**
     * Set HotelPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgHotelPrefType[] $hotelPref
     * @return \dgsoft\StructType\DgPrefCollection
     */
    public function setHotelPref(array $hotelPref = array())
    {
        foreach ($hotelPref as $prefCollectionHotelPrefItem) {
            // validation for constraint: itemType
            if (!$prefCollectionHotelPrefItem instanceof \dgsoft\StructType\DgHotelPrefType) {
                throw new \InvalidArgumentException(sprintf('The HotelPref property can only contain items of \dgsoft\StructType\DgHotelPrefType, "%s" given', is_object($prefCollectionHotelPrefItem) ? get_class($prefCollectionHotelPrefItem) : gettype($prefCollectionHotelPrefItem)), __LINE__);
            }
        }
        $this->HotelPref = $hotelPref;
        return $this;
    }
    /**
     * Add item to HotelPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgHotelPrefType $item
     * @return \dgsoft\StructType\DgPrefCollection
     */
    public function addToHotelPref(\dgsoft\StructType\DgHotelPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgHotelPrefType) {
            throw new \InvalidArgumentException(sprintf('The HotelPref property can only contain items of \dgsoft\StructType\DgHotelPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->HotelPref[] = $item;
        return $this;
    }
    /**
     * Get OtherSrvcPref value
     * @return \dgsoft\StructType\DgOtherSrvcPrefType[]|null
     */
    public function getOtherSrvcPref()
    {
        return $this->OtherSrvcPref;
    }
    /**
     * Set OtherSrvcPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOtherSrvcPrefType[] $otherSrvcPref
     * @return \dgsoft\StructType\DgPrefCollection
     */
    public function setOtherSrvcPref(array $otherSrvcPref = array())
    {
        foreach ($otherSrvcPref as $prefCollectionOtherSrvcPrefItem) {
            // validation for constraint: itemType
            if (!$prefCollectionOtherSrvcPrefItem instanceof \dgsoft\StructType\DgOtherSrvcPrefType) {
                throw new \InvalidArgumentException(sprintf('The OtherSrvcPref property can only contain items of \dgsoft\StructType\DgOtherSrvcPrefType, "%s" given', is_object($prefCollectionOtherSrvcPrefItem) ? get_class($prefCollectionOtherSrvcPrefItem) : gettype($prefCollectionOtherSrvcPrefItem)), __LINE__);
            }
        }
        $this->OtherSrvcPref = $otherSrvcPref;
        return $this;
    }
    /**
     * Add item to OtherSrvcPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOtherSrvcPrefType $item
     * @return \dgsoft\StructType\DgPrefCollection
     */
    public function addToOtherSrvcPref(\dgsoft\StructType\DgOtherSrvcPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgOtherSrvcPrefType) {
            throw new \InvalidArgumentException(sprintf('The OtherSrvcPref property can only contain items of \dgsoft\StructType\DgOtherSrvcPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OtherSrvcPref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgPrefCollection
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \dgsoft\StructType\DgPrefCollection
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \dgsoft\StructType\DgPrefCollection
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get TravelPurpose value
     * @return string|null
     */
    public function getTravelPurpose()
    {
        return $this->TravelPurpose;
    }
    /**
     * Set TravelPurpose value
     * @param string $travelPurpose
     * @return \dgsoft\StructType\DgPrefCollection
     */
    public function setTravelPurpose($travelPurpose = null)
    {
        // validation for constraint: string
        if (!is_null($travelPurpose) && !is_string($travelPurpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelPurpose)), __LINE__);
        }
        $this->TravelPurpose = $travelPurpose;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPrefCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
