<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PkgReadRequest StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPkgReadRequest extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPersonNameType
     */
    public $Name;
    /**
     * The ArrivalLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLocationType
     */
    public $ArrivalLocation;
    /**
     * The DepartureLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLocationType
     */
    public $DepartureLocation;
    /**
     * The TravelCode
     * @var string
     */
    public $TravelCode;
    /**
     * The TourCode
     * @var string
     */
    public $TourCode;
    /**
     * The PackageID
     * @var string
     */
    public $PackageID;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * Constructor method for PkgReadRequest
     * @uses DgPkgReadRequest::setName()
     * @uses DgPkgReadRequest::setArrivalLocation()
     * @uses DgPkgReadRequest::setDepartureLocation()
     * @uses DgPkgReadRequest::setTravelCode()
     * @uses DgPkgReadRequest::setTourCode()
     * @uses DgPkgReadRequest::setPackageID()
     * @uses DgPkgReadRequest::setStart()
     * @uses DgPkgReadRequest::setDuration()
     * @uses DgPkgReadRequest::setEnd()
     * @param \dgsoft\StructType\DgPersonNameType $name
     * @param \dgsoft\StructType\DgLocationType $arrivalLocation
     * @param \dgsoft\StructType\DgLocationType $departureLocation
     * @param string $travelCode
     * @param string $tourCode
     * @param string $packageID
     * @param string $start
     * @param string $duration
     * @param string $end
     */
    public function __construct(\dgsoft\StructType\DgPersonNameType $name = null, \dgsoft\StructType\DgLocationType $arrivalLocation = null, \dgsoft\StructType\DgLocationType $departureLocation = null, $travelCode = null, $tourCode = null, $packageID = null, $start = null, $duration = null, $end = null)
    {
        $this
            ->setName($name)
            ->setArrivalLocation($arrivalLocation)
            ->setDepartureLocation($departureLocation)
            ->setTravelCode($travelCode)
            ->setTourCode($tourCode)
            ->setPackageID($packageID)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end);
    }
    /**
     * Get Name value
     * @return \dgsoft\StructType\DgPersonNameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \dgsoft\StructType\DgPersonNameType $name
     * @return \dgsoft\StructType\DgPkgReadRequest
     */
    public function setName(\dgsoft\StructType\DgPersonNameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ArrivalLocation value
     * @return \dgsoft\StructType\DgLocationType|null
     */
    public function getArrivalLocation()
    {
        return $this->ArrivalLocation;
    }
    /**
     * Set ArrivalLocation value
     * @param \dgsoft\StructType\DgLocationType $arrivalLocation
     * @return \dgsoft\StructType\DgPkgReadRequest
     */
    public function setArrivalLocation(\dgsoft\StructType\DgLocationType $arrivalLocation = null)
    {
        $this->ArrivalLocation = $arrivalLocation;
        return $this;
    }
    /**
     * Get DepartureLocation value
     * @return \dgsoft\StructType\DgLocationType|null
     */
    public function getDepartureLocation()
    {
        return $this->DepartureLocation;
    }
    /**
     * Set DepartureLocation value
     * @param \dgsoft\StructType\DgLocationType $departureLocation
     * @return \dgsoft\StructType\DgPkgReadRequest
     */
    public function setDepartureLocation(\dgsoft\StructType\DgLocationType $departureLocation = null)
    {
        $this->DepartureLocation = $departureLocation;
        return $this;
    }
    /**
     * Get TravelCode value
     * @return string|null
     */
    public function getTravelCode()
    {
        return $this->TravelCode;
    }
    /**
     * Set TravelCode value
     * @param string $travelCode
     * @return \dgsoft\StructType\DgPkgReadRequest
     */
    public function setTravelCode($travelCode = null)
    {
        // validation for constraint: string
        if (!is_null($travelCode) && !is_string($travelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelCode)), __LINE__);
        }
        $this->TravelCode = $travelCode;
        return $this;
    }
    /**
     * Get TourCode value
     * @return string|null
     */
    public function getTourCode()
    {
        return $this->TourCode;
    }
    /**
     * Set TourCode value
     * @param string $tourCode
     * @return \dgsoft\StructType\DgPkgReadRequest
     */
    public function setTourCode($tourCode = null)
    {
        // validation for constraint: string
        if (!is_null($tourCode) && !is_string($tourCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tourCode)), __LINE__);
        }
        $this->TourCode = $tourCode;
        return $this;
    }
    /**
     * Get PackageID value
     * @return string|null
     */
    public function getPackageID()
    {
        return $this->PackageID;
    }
    /**
     * Set PackageID value
     * @param string $packageID
     * @return \dgsoft\StructType\DgPkgReadRequest
     */
    public function setPackageID($packageID = null)
    {
        // validation for constraint: string
        if (!is_null($packageID) && !is_string($packageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packageID)), __LINE__);
        }
        $this->PackageID = $packageID;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \dgsoft\StructType\DgPkgReadRequest
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \dgsoft\StructType\DgPkgReadRequest
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \dgsoft\StructType\DgPkgReadRequest
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPkgReadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
