<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Person StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPerson extends DgEntity
{
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BirthDate;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The SecondaryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SecondaryName;
    /**
     * The SecondarySurnameName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SecondarySurnameName;
    /**
     * The SurName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SurName;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The GenderCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GenderCode;
    /**
     * The Education
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Education;
    /**
     * The Occupation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Occupation;
    /**
     * The MaritalStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MaritalStatus;
    /**
     * The CitizenShip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CitizenShip;
    /**
     * The MotherMaidenName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MotherMaidenName;
    /**
     * The LanguageSpoken
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LanguageSpoken;
    /**
     * The BirthCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BirthCountry;
    /**
     * The BirthCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BirthCity;
    /**
     * Constructor method for Person
     * @uses DgPerson::setBirthDate()
     * @uses DgPerson::setFirstName()
     * @uses DgPerson::setSecondaryName()
     * @uses DgPerson::setSecondarySurnameName()
     * @uses DgPerson::setSurName()
     * @uses DgPerson::setTitle()
     * @uses DgPerson::setGenderCode()
     * @uses DgPerson::setEducation()
     * @uses DgPerson::setOccupation()
     * @uses DgPerson::setMaritalStatus()
     * @uses DgPerson::setCitizenShip()
     * @uses DgPerson::setMotherMaidenName()
     * @uses DgPerson::setLanguageSpoken()
     * @uses DgPerson::setBirthCountry()
     * @uses DgPerson::setBirthCity()
     * @param string $birthDate
     * @param string $firstName
     * @param string $secondaryName
     * @param string $secondarySurnameName
     * @param string $surName
     * @param string $title
     * @param string $genderCode
     * @param string $education
     * @param string $occupation
     * @param string $maritalStatus
     * @param string $citizenShip
     * @param string $motherMaidenName
     * @param string $languageSpoken
     * @param string $birthCountry
     * @param string $birthCity
     */
    public function __construct($birthDate = null, $firstName = null, $secondaryName = null, $secondarySurnameName = null, $surName = null, $title = null, $genderCode = null, $education = null, $occupation = null, $maritalStatus = null, $citizenShip = null, $motherMaidenName = null, $languageSpoken = null, $birthCountry = null, $birthCity = null)
    {
        $this
            ->setBirthDate($birthDate)
            ->setFirstName($firstName)
            ->setSecondaryName($secondaryName)
            ->setSecondarySurnameName($secondarySurnameName)
            ->setSurName($surName)
            ->setTitle($title)
            ->setGenderCode($genderCode)
            ->setEducation($education)
            ->setOccupation($occupation)
            ->setMaritalStatus($maritalStatus)
            ->setCitizenShip($citizenShip)
            ->setMotherMaidenName($motherMaidenName)
            ->setLanguageSpoken($languageSpoken)
            ->setBirthCountry($birthCountry)
            ->setBirthCity($birthCity);
    }
    /**
     * Get BirthDate value
     * @return string
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \dgsoft\StructType\DgPerson
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \dgsoft\StructType\DgPerson
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get SecondaryName value
     * @return string|null
     */
    public function getSecondaryName()
    {
        return $this->SecondaryName;
    }
    /**
     * Set SecondaryName value
     * @param string $secondaryName
     * @return \dgsoft\StructType\DgPerson
     */
    public function setSecondaryName($secondaryName = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryName) && !is_string($secondaryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondaryName)), __LINE__);
        }
        $this->SecondaryName = $secondaryName;
        return $this;
    }
    /**
     * Get SecondarySurnameName value
     * @return string|null
     */
    public function getSecondarySurnameName()
    {
        return $this->SecondarySurnameName;
    }
    /**
     * Set SecondarySurnameName value
     * @param string $secondarySurnameName
     * @return \dgsoft\StructType\DgPerson
     */
    public function setSecondarySurnameName($secondarySurnameName = null)
    {
        // validation for constraint: string
        if (!is_null($secondarySurnameName) && !is_string($secondarySurnameName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondarySurnameName)), __LINE__);
        }
        $this->SecondarySurnameName = $secondarySurnameName;
        return $this;
    }
    /**
     * Get SurName value
     * @return string|null
     */
    public function getSurName()
    {
        return $this->SurName;
    }
    /**
     * Set SurName value
     * @param string $surName
     * @return \dgsoft\StructType\DgPerson
     */
    public function setSurName($surName = null)
    {
        // validation for constraint: string
        if (!is_null($surName) && !is_string($surName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surName)), __LINE__);
        }
        $this->SurName = $surName;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \dgsoft\StructType\DgPerson
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get GenderCode value
     * @return string|null
     */
    public function getGenderCode()
    {
        return $this->GenderCode;
    }
    /**
     * Set GenderCode value
     * @param string $genderCode
     * @return \dgsoft\StructType\DgPerson
     */
    public function setGenderCode($genderCode = null)
    {
        // validation for constraint: string
        if (!is_null($genderCode) && !is_string($genderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($genderCode)), __LINE__);
        }
        $this->GenderCode = $genderCode;
        return $this;
    }
    /**
     * Get Education value
     * @return string|null
     */
    public function getEducation()
    {
        return $this->Education;
    }
    /**
     * Set Education value
     * @param string $education
     * @return \dgsoft\StructType\DgPerson
     */
    public function setEducation($education = null)
    {
        // validation for constraint: string
        if (!is_null($education) && !is_string($education)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($education)), __LINE__);
        }
        $this->Education = $education;
        return $this;
    }
    /**
     * Get Occupation value
     * @return string|null
     */
    public function getOccupation()
    {
        return $this->Occupation;
    }
    /**
     * Set Occupation value
     * @param string $occupation
     * @return \dgsoft\StructType\DgPerson
     */
    public function setOccupation($occupation = null)
    {
        // validation for constraint: string
        if (!is_null($occupation) && !is_string($occupation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($occupation)), __LINE__);
        }
        $this->Occupation = $occupation;
        return $this;
    }
    /**
     * Get MaritalStatus value
     * @return string|null
     */
    public function getMaritalStatus()
    {
        return $this->MaritalStatus;
    }
    /**
     * Set MaritalStatus value
     * @param string $maritalStatus
     * @return \dgsoft\StructType\DgPerson
     */
    public function setMaritalStatus($maritalStatus = null)
    {
        // validation for constraint: string
        if (!is_null($maritalStatus) && !is_string($maritalStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maritalStatus)), __LINE__);
        }
        $this->MaritalStatus = $maritalStatus;
        return $this;
    }
    /**
     * Get CitizenShip value
     * @return string|null
     */
    public function getCitizenShip()
    {
        return $this->CitizenShip;
    }
    /**
     * Set CitizenShip value
     * @param string $citizenShip
     * @return \dgsoft\StructType\DgPerson
     */
    public function setCitizenShip($citizenShip = null)
    {
        // validation for constraint: string
        if (!is_null($citizenShip) && !is_string($citizenShip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($citizenShip)), __LINE__);
        }
        $this->CitizenShip = $citizenShip;
        return $this;
    }
    /**
     * Get MotherMaidenName value
     * @return string|null
     */
    public function getMotherMaidenName()
    {
        return $this->MotherMaidenName;
    }
    /**
     * Set MotherMaidenName value
     * @param string $motherMaidenName
     * @return \dgsoft\StructType\DgPerson
     */
    public function setMotherMaidenName($motherMaidenName = null)
    {
        // validation for constraint: string
        if (!is_null($motherMaidenName) && !is_string($motherMaidenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($motherMaidenName)), __LINE__);
        }
        $this->MotherMaidenName = $motherMaidenName;
        return $this;
    }
    /**
     * Get LanguageSpoken value
     * @return string|null
     */
    public function getLanguageSpoken()
    {
        return $this->LanguageSpoken;
    }
    /**
     * Set LanguageSpoken value
     * @param string $languageSpoken
     * @return \dgsoft\StructType\DgPerson
     */
    public function setLanguageSpoken($languageSpoken = null)
    {
        // validation for constraint: string
        if (!is_null($languageSpoken) && !is_string($languageSpoken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($languageSpoken)), __LINE__);
        }
        $this->LanguageSpoken = $languageSpoken;
        return $this;
    }
    /**
     * Get BirthCountry value
     * @return string|null
     */
    public function getBirthCountry()
    {
        return $this->BirthCountry;
    }
    /**
     * Set BirthCountry value
     * @param string $birthCountry
     * @return \dgsoft\StructType\DgPerson
     */
    public function setBirthCountry($birthCountry = null)
    {
        // validation for constraint: string
        if (!is_null($birthCountry) && !is_string($birthCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthCountry)), __LINE__);
        }
        $this->BirthCountry = $birthCountry;
        return $this;
    }
    /**
     * Get BirthCity value
     * @return string|null
     */
    public function getBirthCity()
    {
        return $this->BirthCity;
    }
    /**
     * Set BirthCity value
     * @param string $birthCity
     * @return \dgsoft\StructType\DgPerson
     */
    public function setBirthCity($birthCity = null)
    {
        // validation for constraint: string
        if (!is_null($birthCity) && !is_string($birthCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthCity)), __LINE__);
        }
        $this->BirthCity = $birthCity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPerson
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
