<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Penalty StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPenalty extends AbstractStructBase
{
    /**
     * The PenaltyType
     * @var string
     */
    public $PenaltyType;
    /**
     * The DepartureStatus
     * @var string
     */
    public $DepartureStatus;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The Percent
     * @var float
     */
    public $Percent;
    /**
     * Constructor method for Penalty
     * @uses DgPenalty::setPenaltyType()
     * @uses DgPenalty::setDepartureStatus()
     * @uses DgPenalty::setAmount()
     * @uses DgPenalty::setPercent()
     * @param string $penaltyType
     * @param string $departureStatus
     * @param float $amount
     * @param float $percent
     */
    public function __construct($penaltyType = null, $departureStatus = null, $amount = null, $percent = null)
    {
        $this
            ->setPenaltyType($penaltyType)
            ->setDepartureStatus($departureStatus)
            ->setAmount($amount)
            ->setPercent($percent);
    }
    /**
     * Get PenaltyType value
     * @return string|null
     */
    public function getPenaltyType()
    {
        return $this->PenaltyType;
    }
    /**
     * Set PenaltyType value
     * @param string $penaltyType
     * @return \dgsoft\StructType\DgPenalty
     */
    public function setPenaltyType($penaltyType = null)
    {
        // validation for constraint: string
        if (!is_null($penaltyType) && !is_string($penaltyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penaltyType)), __LINE__);
        }
        $this->PenaltyType = $penaltyType;
        return $this;
    }
    /**
     * Get DepartureStatus value
     * @return string|null
     */
    public function getDepartureStatus()
    {
        return $this->DepartureStatus;
    }
    /**
     * Set DepartureStatus value
     * @param string $departureStatus
     * @return \dgsoft\StructType\DgPenalty
     */
    public function setDepartureStatus($departureStatus = null)
    {
        // validation for constraint: string
        if (!is_null($departureStatus) && !is_string($departureStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureStatus)), __LINE__);
        }
        $this->DepartureStatus = $departureStatus;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \dgsoft\StructType\DgPenalty
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \dgsoft\StructType\DgPenalty
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPenalty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
