<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentCardType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPaymentCardType extends AbstractStructBase
{
    /**
     * The CardHolderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardHolderName;
    /**
     * The CardIssuerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCardIssuerName
     */
    public $CardIssuerName;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAddressType
     */
    public $Address;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The CardType
     * @var string
     */
    public $CardType;
    /**
     * The SecurityNumber
     * @var string
     */
    public $SecurityNumber;
    /**
     * The CardCode
     * @var string
     */
    public $CardCode;
    /**
     * The CardNumber
     * @var string
     */
    public $CardNumber;
    /**
     * The SeriesCode
     * @var string
     */
    public $SeriesCode;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The MaskedCardNumber
     * @var string
     */
    public $MaskedCardNumber;
    /**
     * The CardHolderRPH
     * @var string
     */
    public $CardHolderRPH;
    /**
     * The ExtendPaymentIndicator
     * @var bool
     */
    public $ExtendPaymentIndicator;
    /**
     * Constructor method for PaymentCardType
     * @uses DgPaymentCardType::setCardHolderName()
     * @uses DgPaymentCardType::setCardIssuerName()
     * @uses DgPaymentCardType::setAddress()
     * @uses DgPaymentCardType::setShareSynchInd()
     * @uses DgPaymentCardType::setShareMarketInd()
     * @uses DgPaymentCardType::setCardType()
     * @uses DgPaymentCardType::setSecurityNumber()
     * @uses DgPaymentCardType::setCardCode()
     * @uses DgPaymentCardType::setCardNumber()
     * @uses DgPaymentCardType::setSeriesCode()
     * @uses DgPaymentCardType::setEffectiveDate()
     * @uses DgPaymentCardType::setExpireDate()
     * @uses DgPaymentCardType::setMaskedCardNumber()
     * @uses DgPaymentCardType::setCardHolderRPH()
     * @uses DgPaymentCardType::setExtendPaymentIndicator()
     * @param string $cardHolderName
     * @param \dgsoft\StructType\DgCardIssuerName $cardIssuerName
     * @param \dgsoft\StructType\DgAddressType $address
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $cardType
     * @param string $securityNumber
     * @param string $cardCode
     * @param string $cardNumber
     * @param string $seriesCode
     * @param string $effectiveDate
     * @param string $expireDate
     * @param string $maskedCardNumber
     * @param string $cardHolderRPH
     * @param bool $extendPaymentIndicator
     */
    public function __construct($cardHolderName = null, \dgsoft\StructType\DgCardIssuerName $cardIssuerName = null, \dgsoft\StructType\DgAddressType $address = null, $shareSynchInd = null, $shareMarketInd = null, $cardType = null, $securityNumber = null, $cardCode = null, $cardNumber = null, $seriesCode = null, $effectiveDate = null, $expireDate = null, $maskedCardNumber = null, $cardHolderRPH = null, $extendPaymentIndicator = null)
    {
        $this
            ->setCardHolderName($cardHolderName)
            ->setCardIssuerName($cardIssuerName)
            ->setAddress($address)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setCardType($cardType)
            ->setSecurityNumber($securityNumber)
            ->setCardCode($cardCode)
            ->setCardNumber($cardNumber)
            ->setSeriesCode($seriesCode)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setMaskedCardNumber($maskedCardNumber)
            ->setCardHolderRPH($cardHolderRPH)
            ->setExtendPaymentIndicator($extendPaymentIndicator);
    }
    /**
     * Get CardHolderName value
     * @return string|null
     */
    public function getCardHolderName()
    {
        return $this->CardHolderName;
    }
    /**
     * Set CardHolderName value
     * @param string $cardHolderName
     * @return \dgsoft\StructType\DgPaymentCardType
     */
    public function setCardHolderName($cardHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolderName) && !is_string($cardHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardHolderName)), __LINE__);
        }
        $this->CardHolderName = $cardHolderName;
        return $this;
    }
    /**
     * Get CardIssuerName value
     * @return \dgsoft\StructType\DgCardIssuerName|null
     */
    public function getCardIssuerName()
    {
        return $this->CardIssuerName;
    }
    /**
     * Set CardIssuerName value
     * @param \dgsoft\StructType\DgCardIssuerName $cardIssuerName
     * @return \dgsoft\StructType\DgPaymentCardType
     */
    public function setCardIssuerName(\dgsoft\StructType\DgCardIssuerName $cardIssuerName = null)
    {
        $this->CardIssuerName = $cardIssuerName;
        return $this;
    }
    /**
     * Get Address value
     * @return \dgsoft\StructType\DgAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \dgsoft\StructType\DgAddressType $address
     * @return \dgsoft\StructType\DgPaymentCardType
     */
    public function setAddress(\dgsoft\StructType\DgAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \dgsoft\StructType\DgPaymentCardType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \dgsoft\StructType\DgPaymentCardType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get CardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->CardType;
    }
    /**
     * Set CardType value
     * @param string $cardType
     * @return \dgsoft\StructType\DgPaymentCardType
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardType)), __LINE__);
        }
        $this->CardType = $cardType;
        return $this;
    }
    /**
     * Get SecurityNumber value
     * @return string|null
     */
    public function getSecurityNumber()
    {
        return $this->SecurityNumber;
    }
    /**
     * Set SecurityNumber value
     * @param string $securityNumber
     * @return \dgsoft\StructType\DgPaymentCardType
     */
    public function setSecurityNumber($securityNumber = null)
    {
        // validation for constraint: string
        if (!is_null($securityNumber) && !is_string($securityNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($securityNumber)), __LINE__);
        }
        $this->SecurityNumber = $securityNumber;
        return $this;
    }
    /**
     * Get CardCode value
     * @return string|null
     */
    public function getCardCode()
    {
        return $this->CardCode;
    }
    /**
     * Set CardCode value
     * @param string $cardCode
     * @return \dgsoft\StructType\DgPaymentCardType
     */
    public function setCardCode($cardCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardCode) && !is_string($cardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardCode)), __LINE__);
        }
        $this->CardCode = $cardCode;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \dgsoft\StructType\DgPaymentCardType
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get SeriesCode value
     * @return string|null
     */
    public function getSeriesCode()
    {
        return $this->SeriesCode;
    }
    /**
     * Set SeriesCode value
     * @param string $seriesCode
     * @return \dgsoft\StructType\DgPaymentCardType
     */
    public function setSeriesCode($seriesCode = null)
    {
        // validation for constraint: string
        if (!is_null($seriesCode) && !is_string($seriesCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seriesCode)), __LINE__);
        }
        $this->SeriesCode = $seriesCode;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \dgsoft\StructType\DgPaymentCardType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \dgsoft\StructType\DgPaymentCardType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get MaskedCardNumber value
     * @return string|null
     */
    public function getMaskedCardNumber()
    {
        return $this->MaskedCardNumber;
    }
    /**
     * Set MaskedCardNumber value
     * @param string $maskedCardNumber
     * @return \dgsoft\StructType\DgPaymentCardType
     */
    public function setMaskedCardNumber($maskedCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($maskedCardNumber) && !is_string($maskedCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maskedCardNumber)), __LINE__);
        }
        $this->MaskedCardNumber = $maskedCardNumber;
        return $this;
    }
    /**
     * Get CardHolderRPH value
     * @return string|null
     */
    public function getCardHolderRPH()
    {
        return $this->CardHolderRPH;
    }
    /**
     * Set CardHolderRPH value
     * @param string $cardHolderRPH
     * @return \dgsoft\StructType\DgPaymentCardType
     */
    public function setCardHolderRPH($cardHolderRPH = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolderRPH) && !is_string($cardHolderRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardHolderRPH)), __LINE__);
        }
        $this->CardHolderRPH = $cardHolderRPH;
        return $this;
    }
    /**
     * Get ExtendPaymentIndicator value
     * @return bool|null
     */
    public function getExtendPaymentIndicator()
    {
        return $this->ExtendPaymentIndicator;
    }
    /**
     * Set ExtendPaymentIndicator value
     * @param bool $extendPaymentIndicator
     * @return \dgsoft\StructType\DgPaymentCardType
     */
    public function setExtendPaymentIndicator($extendPaymentIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($extendPaymentIndicator) && !is_bool($extendPaymentIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($extendPaymentIndicator)), __LINE__);
        }
        $this->ExtendPaymentIndicator = $extendPaymentIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPaymentCardType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
