<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerTypeQuantityType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPassengerTypeQuantityType extends AbstractStructBase
{
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Quantity;
    /**
     * The Age
     * @var int
     */
    public $Age;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The AlternativeCode1
     * @var string
     */
    public $AlternativeCode1;
    /**
     * The AlternativeCode2
     * @var string
     */
    public $AlternativeCode2;
    /**
     * The CodeContext
     * @var string
     */
    public $CodeContext;
    /**
     * The URI
     * @var string
     */
    public $URI;
    /**
     * Constructor method for PassengerTypeQuantityType
     * @uses DgPassengerTypeQuantityType::setQuantity()
     * @uses DgPassengerTypeQuantityType::setAge()
     * @uses DgPassengerTypeQuantityType::setCode()
     * @uses DgPassengerTypeQuantityType::setAlternativeCode1()
     * @uses DgPassengerTypeQuantityType::setAlternativeCode2()
     * @uses DgPassengerTypeQuantityType::setCodeContext()
     * @uses DgPassengerTypeQuantityType::setURI()
     * @param int $quantity
     * @param int $age
     * @param string $code
     * @param string $alternativeCode1
     * @param string $alternativeCode2
     * @param string $codeContext
     * @param string $uRI
     */
    public function __construct($quantity = null, $age = null, $code = null, $alternativeCode1 = null, $alternativeCode2 = null, $codeContext = null, $uRI = null)
    {
        $this
            ->setQuantity($quantity)
            ->setAge($age)
            ->setCode($code)
            ->setAlternativeCode1($alternativeCode1)
            ->setAlternativeCode2($alternativeCode2)
            ->setCodeContext($codeContext)
            ->setURI($uRI);
    }
    /**
     * Get Quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \dgsoft\StructType\DgPassengerTypeQuantityType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \dgsoft\StructType\DgPassengerTypeQuantityType
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !is_numeric($age)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($age)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \dgsoft\StructType\DgPassengerTypeQuantityType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get AlternativeCode1 value
     * @return string|null
     */
    public function getAlternativeCode1()
    {
        return $this->AlternativeCode1;
    }
    /**
     * Set AlternativeCode1 value
     * @param string $alternativeCode1
     * @return \dgsoft\StructType\DgPassengerTypeQuantityType
     */
    public function setAlternativeCode1($alternativeCode1 = null)
    {
        // validation for constraint: string
        if (!is_null($alternativeCode1) && !is_string($alternativeCode1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alternativeCode1)), __LINE__);
        }
        $this->AlternativeCode1 = $alternativeCode1;
        return $this;
    }
    /**
     * Get AlternativeCode2 value
     * @return string|null
     */
    public function getAlternativeCode2()
    {
        return $this->AlternativeCode2;
    }
    /**
     * Set AlternativeCode2 value
     * @param string $alternativeCode2
     * @return \dgsoft\StructType\DgPassengerTypeQuantityType
     */
    public function setAlternativeCode2($alternativeCode2 = null)
    {
        // validation for constraint: string
        if (!is_null($alternativeCode2) && !is_string($alternativeCode2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alternativeCode2)), __LINE__);
        }
        $this->AlternativeCode2 = $alternativeCode2;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \dgsoft\StructType\DgPassengerTypeQuantityType
     */
    public function setCodeContext($codeContext = null)
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeContext)), __LINE__);
        }
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Get URI value
     * @return string|null
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param string $uRI
     * @return \dgsoft\StructType\DgPassengerTypeQuantityType
     */
    public function setURI($uRI = null)
    {
        // validation for constraint: string
        if (!is_null($uRI) && !is_string($uRI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRI)), __LINE__);
        }
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPassengerTypeQuantityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
