<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerSpecialRequest StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPassengerSpecialRequest extends DgDBBaseEntity
{
    /**
     * The PassengerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $PassengerID;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for PassengerSpecialRequest
     * @uses DgPassengerSpecialRequest::setPassengerID()
     * @uses DgPassengerSpecialRequest::setType()
     * @uses DgPassengerSpecialRequest::setStatus()
     * @param string $passengerID
     * @param string $type
     * @param string $status
     */
    public function __construct($passengerID = null, $type = null, $status = null)
    {
        $this
            ->setPassengerID($passengerID)
            ->setType($type)
            ->setStatus($status);
    }
    /**
     * Get PassengerID value
     * @return string
     */
    public function getPassengerID()
    {
        return $this->PassengerID;
    }
    /**
     * Set PassengerID value
     * @param string $passengerID
     * @return \dgsoft\StructType\DgPassengerSpecialRequest
     */
    public function setPassengerID($passengerID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($passengerID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $passengerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($passengerID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($passengerID) && !is_string($passengerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passengerID)), __LINE__);
        }
        $this->PassengerID = $passengerID;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \dgsoft\StructType\DgPassengerSpecialRequest
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \dgsoft\StructType\DgPassengerSpecialRequest
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPassengerSpecialRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
