<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerFlyerCard StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPassengerFlyerCard extends DgDBBaseEntity
{
    /**
     * The PassengerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $PassengerID;
    /**
     * The AirlineCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AirlineCode;
    /**
     * The CardName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardName;
    /**
     * The CardNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTDESValue
     */
    public $CardNumber;
    /**
     * Constructor method for PassengerFlyerCard
     * @uses DgPassengerFlyerCard::setPassengerID()
     * @uses DgPassengerFlyerCard::setAirlineCode()
     * @uses DgPassengerFlyerCard::setCardName()
     * @uses DgPassengerFlyerCard::setCardNumber()
     * @param string $passengerID
     * @param string $airlineCode
     * @param string $cardName
     * @param \dgsoft\StructType\DgTDESValue $cardNumber
     */
    public function __construct($passengerID = null, $airlineCode = null, $cardName = null, \dgsoft\StructType\DgTDESValue $cardNumber = null)
    {
        $this
            ->setPassengerID($passengerID)
            ->setAirlineCode($airlineCode)
            ->setCardName($cardName)
            ->setCardNumber($cardNumber);
    }
    /**
     * Get PassengerID value
     * @return string
     */
    public function getPassengerID()
    {
        return $this->PassengerID;
    }
    /**
     * Set PassengerID value
     * @param string $passengerID
     * @return \dgsoft\StructType\DgPassengerFlyerCard
     */
    public function setPassengerID($passengerID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($passengerID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $passengerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($passengerID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($passengerID) && !is_string($passengerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passengerID)), __LINE__);
        }
        $this->PassengerID = $passengerID;
        return $this;
    }
    /**
     * Get AirlineCode value
     * @return string|null
     */
    public function getAirlineCode()
    {
        return $this->AirlineCode;
    }
    /**
     * Set AirlineCode value
     * @param string $airlineCode
     * @return \dgsoft\StructType\DgPassengerFlyerCard
     */
    public function setAirlineCode($airlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($airlineCode) && !is_string($airlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airlineCode)), __LINE__);
        }
        $this->AirlineCode = $airlineCode;
        return $this;
    }
    /**
     * Get CardName value
     * @return string|null
     */
    public function getCardName()
    {
        return $this->CardName;
    }
    /**
     * Set CardName value
     * @param string $cardName
     * @return \dgsoft\StructType\DgPassengerFlyerCard
     */
    public function setCardName($cardName = null)
    {
        // validation for constraint: string
        if (!is_null($cardName) && !is_string($cardName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardName)), __LINE__);
        }
        $this->CardName = $cardName;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return \dgsoft\StructType\DgTDESValue|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param \dgsoft\StructType\DgTDESValue $cardNumber
     * @return \dgsoft\StructType\DgPassengerFlyerCard
     */
    public function setCardNumber(\dgsoft\StructType\DgTDESValue $cardNumber = null)
    {
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPassengerFlyerCard
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
