<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PNRRemarkInfo StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPNRRemarkInfo extends AbstractStructBase
{
    /**
     * The RemarkType
     * @var string
     */
    public $RemarkType;
    /**
     * The RemarkCategory
     * @var string
     */
    public $RemarkCategory;
    /**
     * The Note
     * @var string
     */
    public $Note;
    /**
     * The PassengerOrderId
     * @var int
     */
    public $PassengerOrderId;
    /**
     * The SegmentsOrderId
     * @var string
     */
    public $SegmentsOrderId;
    /**
     * Constructor method for PNRRemarkInfo
     * @uses DgPNRRemarkInfo::setRemarkType()
     * @uses DgPNRRemarkInfo::setRemarkCategory()
     * @uses DgPNRRemarkInfo::setNote()
     * @uses DgPNRRemarkInfo::setPassengerOrderId()
     * @uses DgPNRRemarkInfo::setSegmentsOrderId()
     * @param string $remarkType
     * @param string $remarkCategory
     * @param string $note
     * @param int $passengerOrderId
     * @param string $segmentsOrderId
     */
    public function __construct($remarkType = null, $remarkCategory = null, $note = null, $passengerOrderId = null, $segmentsOrderId = null)
    {
        $this
            ->setRemarkType($remarkType)
            ->setRemarkCategory($remarkCategory)
            ->setNote($note)
            ->setPassengerOrderId($passengerOrderId)
            ->setSegmentsOrderId($segmentsOrderId);
    }
    /**
     * Get RemarkType value
     * @return string|null
     */
    public function getRemarkType()
    {
        return $this->RemarkType;
    }
    /**
     * Set RemarkType value
     * @param string $remarkType
     * @return \dgsoft\StructType\DgPNRRemarkInfo
     */
    public function setRemarkType($remarkType = null)
    {
        // validation for constraint: string
        if (!is_null($remarkType) && !is_string($remarkType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remarkType)), __LINE__);
        }
        $this->RemarkType = $remarkType;
        return $this;
    }
    /**
     * Get RemarkCategory value
     * @return string|null
     */
    public function getRemarkCategory()
    {
        return $this->RemarkCategory;
    }
    /**
     * Set RemarkCategory value
     * @param string $remarkCategory
     * @return \dgsoft\StructType\DgPNRRemarkInfo
     */
    public function setRemarkCategory($remarkCategory = null)
    {
        // validation for constraint: string
        if (!is_null($remarkCategory) && !is_string($remarkCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remarkCategory)), __LINE__);
        }
        $this->RemarkCategory = $remarkCategory;
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return \dgsoft\StructType\DgPNRRemarkInfo
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Get PassengerOrderId value
     * @return int|null
     */
    public function getPassengerOrderId()
    {
        return $this->PassengerOrderId;
    }
    /**
     * Set PassengerOrderId value
     * @param int $passengerOrderId
     * @return \dgsoft\StructType\DgPNRRemarkInfo
     */
    public function setPassengerOrderId($passengerOrderId = null)
    {
        // validation for constraint: int
        if (!is_null($passengerOrderId) && !is_numeric($passengerOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($passengerOrderId)), __LINE__);
        }
        $this->PassengerOrderId = $passengerOrderId;
        return $this;
    }
    /**
     * Get SegmentsOrderId value
     * @return string|null
     */
    public function getSegmentsOrderId()
    {
        return $this->SegmentsOrderId;
    }
    /**
     * Set SegmentsOrderId value
     * @param string $segmentsOrderId
     * @return \dgsoft\StructType\DgPNRRemarkInfo
     */
    public function setSegmentsOrderId($segmentsOrderId = null)
    {
        // validation for constraint: string
        if (!is_null($segmentsOrderId) && !is_string($segmentsOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($segmentsOrderId)), __LINE__);
        }
        $this->SegmentsOrderId = $segmentsOrderId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPNRRemarkInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
