<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PNRListType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPNRListType extends AbstractStructBase
{
    /**
     * The PNRListItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPNRListItemType[]
     */
    public $PNRListItem;
    /**
     * Constructor method for PNRListType
     * @uses DgPNRListType::setPNRListItem()
     * @param \dgsoft\StructType\DgPNRListItemType[] $pNRListItem
     */
    public function __construct(array $pNRListItem = array())
    {
        $this
            ->setPNRListItem($pNRListItem);
    }
    /**
     * Get PNRListItem value
     * @return \dgsoft\StructType\DgPNRListItemType[]|null
     */
    public function getPNRListItem()
    {
        return $this->PNRListItem;
    }
    /**
     * Set PNRListItem value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPNRListItemType[] $pNRListItem
     * @return \dgsoft\StructType\DgPNRListType
     */
    public function setPNRListItem(array $pNRListItem = array())
    {
        foreach ($pNRListItem as $pNRListTypePNRListItemItem) {
            // validation for constraint: itemType
            if (!$pNRListTypePNRListItemItem instanceof \dgsoft\StructType\DgPNRListItemType) {
                throw new \InvalidArgumentException(sprintf('The PNRListItem property can only contain items of \dgsoft\StructType\DgPNRListItemType, "%s" given', is_object($pNRListTypePNRListItemItem) ? get_class($pNRListTypePNRListItemItem) : gettype($pNRListTypePNRListItemItem)), __LINE__);
            }
        }
        $this->PNRListItem = $pNRListItem;
        return $this;
    }
    /**
     * Add item to PNRListItem value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPNRListItemType $item
     * @return \dgsoft\StructType\DgPNRListType
     */
    public function addToPNRListItem(\dgsoft\StructType\DgPNRListItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPNRListItemType) {
            throw new \InvalidArgumentException(sprintf('The PNRListItem property can only contain items of \dgsoft\StructType\DgPNRListItemType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PNRListItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPNRListType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
