<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PNRListItemType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPNRListItemType extends AbstractStructBase
{
    /**
     * The PNRNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PNRNo;
    /**
     * The SurName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SurName;
    /**
     * The FlightNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FlightNumber;
    /**
     * The Carrier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Carrier;
    /**
     * The From
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $From;
    /**
     * The To
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $To;
    /**
     * Constructor method for PNRListItemType
     * @uses DgPNRListItemType::setPNRNo()
     * @uses DgPNRListItemType::setSurName()
     * @uses DgPNRListItemType::setFlightNumber()
     * @uses DgPNRListItemType::setCarrier()
     * @uses DgPNRListItemType::setFrom()
     * @uses DgPNRListItemType::setTo()
     * @param string $pNRNo
     * @param string $surName
     * @param string $flightNumber
     * @param string $carrier
     * @param string $from
     * @param string $to
     */
    public function __construct($pNRNo = null, $surName = null, $flightNumber = null, $carrier = null, $from = null, $to = null)
    {
        $this
            ->setPNRNo($pNRNo)
            ->setSurName($surName)
            ->setFlightNumber($flightNumber)
            ->setCarrier($carrier)
            ->setFrom($from)
            ->setTo($to);
    }
    /**
     * Get PNRNo value
     * @return string|null
     */
    public function getPNRNo()
    {
        return $this->PNRNo;
    }
    /**
     * Set PNRNo value
     * @param string $pNRNo
     * @return \dgsoft\StructType\DgPNRListItemType
     */
    public function setPNRNo($pNRNo = null)
    {
        // validation for constraint: string
        if (!is_null($pNRNo) && !is_string($pNRNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pNRNo)), __LINE__);
        }
        $this->PNRNo = $pNRNo;
        return $this;
    }
    /**
     * Get SurName value
     * @return string|null
     */
    public function getSurName()
    {
        return $this->SurName;
    }
    /**
     * Set SurName value
     * @param string $surName
     * @return \dgsoft\StructType\DgPNRListItemType
     */
    public function setSurName($surName = null)
    {
        // validation for constraint: string
        if (!is_null($surName) && !is_string($surName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surName)), __LINE__);
        }
        $this->SurName = $surName;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \dgsoft\StructType\DgPNRListItemType
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get Carrier value
     * @return string|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param string $carrier
     * @return \dgsoft\StructType\DgPNRListItemType
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: string
        if (!is_null($carrier) && !is_string($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrier)), __LINE__);
        }
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get From value
     * @return string|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param string $from
     * @return \dgsoft\StructType\DgPNRListItemType
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from)), __LINE__);
        }
        $this->From = $from;
        return $this;
    }
    /**
     * Get To value
     * @return string|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param string $to
     * @return \dgsoft\StructType\DgPNRListItemType
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($to)), __LINE__);
        }
        $this->To = $to;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPNRListItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
