<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherSrvcPrefType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOtherSrvcPrefType extends AbstractStructBase
{
    /**
     * The OtherSrvcName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherSrvcName;
    /**
     * The VendorPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNamePrefType[]
     */
    public $VendorPref;
    /**
     * The LoyaltyPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLoyaltyPrefType[]
     */
    public $LoyaltyPref;
    /**
     * The PaymentFormPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPaymentFormPrefType[]
     */
    public $PaymentFormPref;
    /**
     * The SpecRequestPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSpecRequestPrefType[]
     */
    public $SpecRequestPref;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The TravelPurpose
     * @var string
     */
    public $TravelPurpose;
    /**
     * Constructor method for OtherSrvcPrefType
     * @uses DgOtherSrvcPrefType::setOtherSrvcName()
     * @uses DgOtherSrvcPrefType::setVendorPref()
     * @uses DgOtherSrvcPrefType::setLoyaltyPref()
     * @uses DgOtherSrvcPrefType::setPaymentFormPref()
     * @uses DgOtherSrvcPrefType::setSpecRequestPref()
     * @uses DgOtherSrvcPrefType::setTPA_Extensions()
     * @uses DgOtherSrvcPrefType::setPreferLevel()
     * @uses DgOtherSrvcPrefType::setShareSynchInd()
     * @uses DgOtherSrvcPrefType::setShareMarketInd()
     * @uses DgOtherSrvcPrefType::setTravelPurpose()
     * @param string $otherSrvcName
     * @param \dgsoft\StructType\DgCompanyNamePrefType[] $vendorPref
     * @param \dgsoft\StructType\DgLoyaltyPrefType[] $loyaltyPref
     * @param \dgsoft\StructType\DgPaymentFormPrefType[] $paymentFormPref
     * @param \dgsoft\StructType\DgSpecRequestPrefType[] $specRequestPref
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param string $preferLevel
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $travelPurpose
     */
    public function __construct($otherSrvcName = null, array $vendorPref = array(), array $loyaltyPref = array(), array $paymentFormPref = array(), array $specRequestPref = array(), \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $preferLevel = 'Preferred', $shareSynchInd = null, $shareMarketInd = null, $travelPurpose = null)
    {
        $this
            ->setOtherSrvcName($otherSrvcName)
            ->setVendorPref($vendorPref)
            ->setLoyaltyPref($loyaltyPref)
            ->setPaymentFormPref($paymentFormPref)
            ->setSpecRequestPref($specRequestPref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setPreferLevel($preferLevel)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setTravelPurpose($travelPurpose);
    }
    /**
     * Get OtherSrvcName value
     * @return string|null
     */
    public function getOtherSrvcName()
    {
        return $this->OtherSrvcName;
    }
    /**
     * Set OtherSrvcName value
     * @param string $otherSrvcName
     * @return \dgsoft\StructType\DgOtherSrvcPrefType
     */
    public function setOtherSrvcName($otherSrvcName = null)
    {
        // validation for constraint: string
        if (!is_null($otherSrvcName) && !is_string($otherSrvcName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherSrvcName)), __LINE__);
        }
        $this->OtherSrvcName = $otherSrvcName;
        return $this;
    }
    /**
     * Get VendorPref value
     * @return \dgsoft\StructType\DgCompanyNamePrefType[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNamePrefType[] $vendorPref
     * @return \dgsoft\StructType\DgOtherSrvcPrefType
     */
    public function setVendorPref(array $vendorPref = array())
    {
        foreach ($vendorPref as $otherSrvcPrefTypeVendorPrefItem) {
            // validation for constraint: itemType
            if (!$otherSrvcPrefTypeVendorPrefItem instanceof \dgsoft\StructType\DgCompanyNamePrefType) {
                throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \dgsoft\StructType\DgCompanyNamePrefType, "%s" given', is_object($otherSrvcPrefTypeVendorPrefItem) ? get_class($otherSrvcPrefTypeVendorPrefItem) : gettype($otherSrvcPrefTypeVendorPrefItem)), __LINE__);
            }
        }
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNamePrefType $item
     * @return \dgsoft\StructType\DgOtherSrvcPrefType
     */
    public function addToVendorPref(\dgsoft\StructType\DgCompanyNamePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCompanyNamePrefType) {
            throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \dgsoft\StructType\DgCompanyNamePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyPref value
     * @return \dgsoft\StructType\DgLoyaltyPrefType[]|null
     */
    public function getLoyaltyPref()
    {
        return $this->LoyaltyPref;
    }
    /**
     * Set LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLoyaltyPrefType[] $loyaltyPref
     * @return \dgsoft\StructType\DgOtherSrvcPrefType
     */
    public function setLoyaltyPref(array $loyaltyPref = array())
    {
        foreach ($loyaltyPref as $otherSrvcPrefTypeLoyaltyPrefItem) {
            // validation for constraint: itemType
            if (!$otherSrvcPrefTypeLoyaltyPrefItem instanceof \dgsoft\StructType\DgLoyaltyPrefType) {
                throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \dgsoft\StructType\DgLoyaltyPrefType, "%s" given', is_object($otherSrvcPrefTypeLoyaltyPrefItem) ? get_class($otherSrvcPrefTypeLoyaltyPrefItem) : gettype($otherSrvcPrefTypeLoyaltyPrefItem)), __LINE__);
            }
        }
        $this->LoyaltyPref = $loyaltyPref;
        return $this;
    }
    /**
     * Add item to LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLoyaltyPrefType $item
     * @return \dgsoft\StructType\DgOtherSrvcPrefType
     */
    public function addToLoyaltyPref(\dgsoft\StructType\DgLoyaltyPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgLoyaltyPrefType) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \dgsoft\StructType\DgLoyaltyPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LoyaltyPref[] = $item;
        return $this;
    }
    /**
     * Get PaymentFormPref value
     * @return \dgsoft\StructType\DgPaymentFormPrefType[]|null
     */
    public function getPaymentFormPref()
    {
        return $this->PaymentFormPref;
    }
    /**
     * Set PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentFormPrefType[] $paymentFormPref
     * @return \dgsoft\StructType\DgOtherSrvcPrefType
     */
    public function setPaymentFormPref(array $paymentFormPref = array())
    {
        foreach ($paymentFormPref as $otherSrvcPrefTypePaymentFormPrefItem) {
            // validation for constraint: itemType
            if (!$otherSrvcPrefTypePaymentFormPrefItem instanceof \dgsoft\StructType\DgPaymentFormPrefType) {
                throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \dgsoft\StructType\DgPaymentFormPrefType, "%s" given', is_object($otherSrvcPrefTypePaymentFormPrefItem) ? get_class($otherSrvcPrefTypePaymentFormPrefItem) : gettype($otherSrvcPrefTypePaymentFormPrefItem)), __LINE__);
            }
        }
        $this->PaymentFormPref = $paymentFormPref;
        return $this;
    }
    /**
     * Add item to PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentFormPrefType $item
     * @return \dgsoft\StructType\DgOtherSrvcPrefType
     */
    public function addToPaymentFormPref(\dgsoft\StructType\DgPaymentFormPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPaymentFormPrefType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \dgsoft\StructType\DgPaymentFormPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentFormPref[] = $item;
        return $this;
    }
    /**
     * Get SpecRequestPref value
     * @return \dgsoft\StructType\DgSpecRequestPrefType[]|null
     */
    public function getSpecRequestPref()
    {
        return $this->SpecRequestPref;
    }
    /**
     * Set SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSpecRequestPrefType[] $specRequestPref
     * @return \dgsoft\StructType\DgOtherSrvcPrefType
     */
    public function setSpecRequestPref(array $specRequestPref = array())
    {
        foreach ($specRequestPref as $otherSrvcPrefTypeSpecRequestPrefItem) {
            // validation for constraint: itemType
            if (!$otherSrvcPrefTypeSpecRequestPrefItem instanceof \dgsoft\StructType\DgSpecRequestPrefType) {
                throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of \dgsoft\StructType\DgSpecRequestPrefType, "%s" given', is_object($otherSrvcPrefTypeSpecRequestPrefItem) ? get_class($otherSrvcPrefTypeSpecRequestPrefItem) : gettype($otherSrvcPrefTypeSpecRequestPrefItem)), __LINE__);
            }
        }
        $this->SpecRequestPref = $specRequestPref;
        return $this;
    }
    /**
     * Add item to SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSpecRequestPrefType $item
     * @return \dgsoft\StructType\DgOtherSrvcPrefType
     */
    public function addToSpecRequestPref(\dgsoft\StructType\DgSpecRequestPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgSpecRequestPrefType) {
            throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of \dgsoft\StructType\DgSpecRequestPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecRequestPref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgOtherSrvcPrefType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \dgsoft\EnumType\DgPreferLevelType::valueIsValid()
     * @uses \dgsoft\EnumType\DgPreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \dgsoft\StructType\DgOtherSrvcPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgPreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferLevel, implode(', ', \dgsoft\EnumType\DgPreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \dgsoft\StructType\DgOtherSrvcPrefType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \dgsoft\StructType\DgOtherSrvcPrefType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get TravelPurpose value
     * @return string|null
     */
    public function getTravelPurpose()
    {
        return $this->TravelPurpose;
    }
    /**
     * Set TravelPurpose value
     * @param string $travelPurpose
     * @return \dgsoft\StructType\DgOtherSrvcPrefType
     */
    public function setTravelPurpose($travelPurpose = null)
    {
        // validation for constraint: string
        if (!is_null($travelPurpose) && !is_string($travelPurpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelPurpose)), __LINE__);
        }
        $this->TravelPurpose = $travelPurpose;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOtherSrvcPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
